/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.uml2sd.ITmfSyncSequenceDiagramEvent;
import org.eclipse.tracecompass.tmf.core.uml2sd.TmfSyncSequenceDiagramEvent;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.Criteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterCriteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterListDialog;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFindProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.load.IUml2SDLoader;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.Messages;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.TmfSyncMessage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class TmfUml2SDSyncLoader
extends TmfComponent
implements IUml2SDLoader,
ISDFindProvider,
ISDFilterProvider,
ISDAdvancedPagingProvider,
ISelectionListener {
    protected static final String TITLE = Messages.TmfUml2SDSyncLoader_ViewName;
    protected static final int MAX_NUM_OF_MSG = 10000;
    private static final int INDEXING_THREAD_SLEEP_VALUE = 100;
    protected ITmfTrace fTrace = null;
    protected ITmfEventRequest fIndexRequest = null;
    protected ITmfEventRequest fPageRequest = null;
    protected volatile boolean fIsSignalSent = false;
    protected SDView fView = null;
    protected Frame fFrame = null;
    protected List<ITmfSyncSequenceDiagramEvent> fEvents = new ArrayList<ITmfSyncSequenceDiagramEvent>();
    protected List<TmfTimeRange> fCheckPoints = new ArrayList<TmfTimeRange>(10000);
    protected volatile int fCurrentPage = 0;
    protected ITmfTimestamp fCurrentTime = null;
    protected volatile boolean fIsSelect = false;
    protected SearchJob fFindJob = null;
    protected List<GraphNode> fFindResults = new ArrayList<GraphNode>();
    protected Criteria fFindCriteria = null;
    protected volatile int fCurrentFindIndex = 0;
    protected List<FilterCriteria> fFilterCriteria = null;
    protected ReentrantLock fLock = new ReentrantLock();

    public TmfUml2SDSyncLoader() {
        super(TITLE);
    }

    public TmfUml2SDSyncLoader(String name) {
        super(name);
    }

    public ITmfTimestamp getCurrentTime() {
        this.fLock.lock();
        try {
            if (this.fCurrentTime != null) {
                ITmfTimestamp iTmfTimestamp = this.fCurrentTime;
                return iTmfTimestamp;
            }
            return null;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void waitForCompletion() {
        this.fLock.lock();
        ITmfEventRequest request = this.fPageRequest;
        this.fLock.unlock();
        if (request != null) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (!trace.equals(this.fTrace)) {
            this.fTrace = trace;
        }
        this.loadTrace();
    }

    protected void loadTrace() {
        ITmfEventRequest indexRequest = null;
        this.fLock.lock();
        try {
            final IndexingJob job = new IndexingJob("Indexing " + this.getName() + "...");
            job.setUser(false);
            job.schedule();
            indexRequest = this.fIndexRequest;
            this.cancelOngoingRequests();
            TmfTimeRange window = TmfTimeRange.ETERNITY;
            this.fIndexRequest = new TmfEventRequest(ITmfEvent.class, window, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND){
                private ITmfTimestamp fFirstTime;
                private ITmfTimestamp fLastTime;
                private int fNbSeqEvents;
                private final List<ITmfSyncSequenceDiagramEvent> fSdEvents;
                {
                    super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                    this.fFirstTime = null;
                    this.fLastTime = null;
                    this.fNbSeqEvents = 0;
                    this.fSdEvents = new ArrayList<ITmfSyncSequenceDiagramEvent>(10000);
                }

                public void handleData(ITmfEvent event) {
                    super.handleData(event);
                    ITmfSyncSequenceDiagramEvent sdEvent = TmfUml2SDSyncLoader.this.getSequenceDiagramEvent(event);
                    ITmfTimestamp firstTime = this.fFirstTime;
                    ITmfTimestamp lastTime = this.fLastTime;
                    if (sdEvent != null) {
                        ++this.fNbSeqEvents;
                        if (firstTime == null) {
                            this.fFirstTime = firstTime = event.getTimestamp();
                        }
                        this.fLastTime = lastTime = event.getTimestamp();
                        if (this.fNbSeqEvents % 10000 == 0) {
                            TmfUml2SDSyncLoader.this.fLock.lock();
                            try {
                                TmfUml2SDSyncLoader.this.fCheckPoints.add(new TmfTimeRange(firstTime, lastTime));
                                if (TmfUml2SDSyncLoader.this.fView != null) {
                                    TmfUml2SDSyncLoader.this.fView.updateCoolBar();
                                }
                            }
                            finally {
                                TmfUml2SDSyncLoader.this.fLock.unlock();
                            }
                            this.fFirstTime = null;
                        }
                        if (this.fNbSeqEvents > 10000) {
                            return;
                        }
                        this.fSdEvents.add(sdEvent);
                        if (this.fNbSeqEvents == 10000) {
                            TmfUml2SDSyncLoader.this.fillCurrentPage(this.fSdEvents);
                        }
                    }
                }

                public void handleSuccess() {
                    ITmfTimestamp firstTime = this.fFirstTime;
                    ITmfTimestamp lastTime = this.fLastTime;
                    if (firstTime != null && lastTime != null) {
                        TmfUml2SDSyncLoader.this.fLock.lock();
                        try {
                            TmfUml2SDSyncLoader.this.fCheckPoints.add(new TmfTimeRange(firstTime, lastTime));
                            if (TmfUml2SDSyncLoader.this.fView != null) {
                                TmfUml2SDSyncLoader.this.fView.updateCoolBar();
                            }
                        }
                        finally {
                            TmfUml2SDSyncLoader.this.fLock.unlock();
                        }
                    }
                    if (this.fNbSeqEvents <= 10000) {
                        TmfUml2SDSyncLoader.this.fillCurrentPage(this.fSdEvents);
                    }
                    super.handleSuccess();
                }

                public void handleCompleted() {
                    if (TmfUml2SDSyncLoader.this.fEvents.isEmpty()) {
                        SDView sdView;
                        TmfUml2SDSyncLoader.this.fFrame = new Frame();
                        TmfUml2SDSyncLoader.this.fLock.lock();
                        try {
                            sdView = TmfUml2SDSyncLoader.this.fView;
                        }
                        finally {
                            TmfUml2SDSyncLoader.this.fLock.unlock();
                        }
                        if (sdView != null) {
                            sdView.setFrameSync(TmfUml2SDSyncLoader.this.fFrame);
                        }
                    }
                    super.handleCompleted();
                    job.cancel();
                }
            };
        }
        finally {
            this.fLock.unlock();
        }
        if (indexRequest != null && !indexRequest.isCompleted()) {
            indexRequest.cancel();
        }
        this.resetLoader();
        this.fTrace.sendRequest(this.fIndexRequest);
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        ITmfEventRequest indexRequest = null;
        this.fLock.lock();
        try {
            indexRequest = this.fIndexRequest;
            this.fIndexRequest = null;
            this.cancelOngoingRequests();
            if (this.fFilterCriteria != null) {
                this.fFilterCriteria.clear();
            }
            FilterListDialog.deactivateSavedGlobalFilters();
        }
        finally {
            this.fTrace = null;
            this.fLock.unlock();
        }
        if (indexRequest != null && !indexRequest.isCompleted()) {
            indexRequest.cancel();
        }
        this.resetLoader();
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        this.fLock.lock();
        try {
            if (signal.getSource() != this && this.fFrame != null && !this.fCheckPoints.isEmpty()) {
                this.fCurrentTime = signal.getBeginTime();
                this.fIsSelect = true;
                this.moveToMessage();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        this.fLock.lock();
        try {
            if (signal.getSource() != this && this.fFrame != null && !this.fIsSignalSent && !this.fCheckPoints.isEmpty()) {
                TmfTimeRange newTimeRange = signal.getCurrentRange();
                this.fIsSelect = false;
                this.fCurrentTime = newTimeRange.getStartTime();
                this.moveToMessage();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void setViewer(SDView viewer) {
        this.fLock.lock();
        try {
            ITmfTrace trace;
            this.fView = viewer;
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
            this.fView.setSDFindProvider(this);
            this.fView.setSDPagingProvider(this);
            this.fView.setSDFilterProvider(this);
            this.resetLoader();
            IEditorPart editor = this.fView.getSite().getPage().getActiveEditor();
            if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
                this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public String getTitleString() {
        return this.getName();
    }

    @Override
    public void dispose() {
        super.dispose();
        ITmfEventRequest indexRequest = null;
        this.fLock.lock();
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                window.getSelectionService().removePostSelectionListener((ISelectionListener)this);
            }
            indexRequest = this.fIndexRequest;
            this.fIndexRequest = null;
            this.cancelOngoingRequests();
            this.fView.setSDFindProvider(null);
            this.fView.setSDPagingProvider(null);
            this.fView.setSDFilterProvider(null);
            this.fView = null;
        }
        finally {
            this.fLock.unlock();
        }
        if (indexRequest != null && !indexRequest.isCompleted()) {
            indexRequest.cancel();
        }
    }

    @Override
    public boolean isNodeSupported(int nodeType) {
        switch (nodeType) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getNodeName(int nodeType, String loaderClassName) {
        switch (nodeType) {
            case 0: {
                return Messages.TmfUml2SDSyncLoader_CategoryLifeline;
            }
            case 1: {
                return Messages.TmfUml2SDSyncLoader_CategoryMessage;
            }
        }
        return "";
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        StructuredSelection stSel;
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel != null && sel instanceof StructuredSelection && (stSel = (StructuredSelection)sel).getFirstElement() instanceof TmfSyncMessage) {
            TmfSyncMessage syncMsg = (TmfSyncMessage)stSel.getFirstElement();
            ITmfTimestamp startTime = syncMsg.getStartTime();
            if (startTime == null) {
                startTime = TmfTimestamp.BIG_BANG;
            }
            this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, startTime, startTime, this.fTrace));
        }
    }

    @Override
    public boolean find(Criteria toSearch) {
        this.fLock.lock();
        try {
            if (this.fFrame == null) {
                return false;
            }
            if (this.fFindResults == null || this.fFindCriteria == null || !this.fFindCriteria.compareTo(toSearch)) {
                List<GraphNode> selection;
                this.fFindResults = new CopyOnWriteArrayList<GraphNode>();
                this.fFindCriteria = toSearch;
                if (this.fFindCriteria.isLifeLineSelected()) {
                    int i = 0;
                    while (i < this.fFrame.lifeLinesCount()) {
                        if (this.fFindCriteria.matches(this.fFrame.getLifeline(i).getName())) {
                            this.fFindResults.add(this.fFrame.getLifeline(i));
                        }
                        ++i;
                    }
                }
                ArrayList<SyncMessage> msgs = new ArrayList<SyncMessage>();
                if (this.fFindCriteria.isSyncMessageSelected()) {
                    int i = 0;
                    while (i < this.fFrame.syncMessageCount()) {
                        if (this.fFindCriteria.matches(this.fFrame.getSyncMessage(i).getName())) {
                            msgs.add(this.fFrame.getSyncMessage(i));
                        }
                        ++i;
                    }
                }
                if (!msgs.isEmpty()) {
                    this.fFindResults.addAll(msgs);
                }
                this.fCurrentFindIndex = (selection = this.fView.getSDWidget().getSelection()) != null && selection.size() == 1 ? this.fFindResults.indexOf(selection.get(0)) + 1 : 0;
            } else {
                ++this.fCurrentFindIndex;
            }
            if (this.fFindResults.size() > this.fCurrentFindIndex) {
                GraphNode current = this.fFindResults.get(this.fCurrentFindIndex);
                this.fView.getSDWidget().moveTo(current);
                return true;
            }
            this.fFindResults = null;
            this.fCurrentFindIndex = 0;
            boolean bl = this.findInNextPages(this.fFindCriteria);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void cancel() {
        this.cancelOngoingRequests();
    }

    @Override
    public boolean filter(List<FilterCriteria> filters) {
        this.fLock.lock();
        try {
            this.cancelOngoingRequests();
            if (filters == null) {
                this.fFilterCriteria = new ArrayList<FilterCriteria>();
            } else {
                List<FilterCriteria> list = filters;
                this.fFilterCriteria = new ArrayList<FilterCriteria>(list);
            }
            this.fillCurrentPage(this.fEvents);
        }
        finally {
            this.fLock.unlock();
        }
        return true;
    }

    @Override
    public boolean hasNextPage() {
        this.fLock.lock();
        try {
            int size = this.fCheckPoints.size();
            if (size > 0) {
                boolean bl = this.fCurrentPage < size - 1;
                return bl;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return false;
    }

    @Override
    public boolean hasPrevPage() {
        this.fLock.lock();
        try {
            boolean bl = this.fCurrentPage > 0;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void nextPage() {
        this.fLock.lock();
        try {
            if (this.fCurrentPage >= this.fCheckPoints.size() - 1) {
                return;
            }
            this.cancelOngoingRequests();
            this.fCurrentTime = null;
            ++this.fCurrentPage;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void prevPage() {
        this.fLock.lock();
        try {
            if (this.fCurrentPage <= 0) {
                return;
            }
            this.cancelOngoingRequests();
            this.fCurrentTime = null;
            --this.fCurrentPage;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void firstPage() {
        this.fLock.lock();
        try {
            this.cancelOngoingRequests();
            this.fCurrentTime = null;
            this.fCurrentPage = 0;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void lastPage() {
        this.fLock.lock();
        try {
            this.cancelOngoingRequests();
            this.fCurrentTime = null;
            this.fCurrentPage = this.fCheckPoints.size() - 1;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public int currentPage() {
        this.fLock.lock();
        try {
            int n = this.fCurrentPage;
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public int pagesCount() {
        this.fLock.lock();
        try {
            int n = this.fCheckPoints.size();
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void pageNumberChanged(int pagenNumber) {
        int localPageNumber = pagenNumber;
        this.fLock.lock();
        try {
            int size;
            this.cancelOngoingRequests();
            if (localPageNumber < 0) {
                localPageNumber = 0;
            }
            if (localPageNumber > (size = this.fCheckPoints.size()) - 1) {
                localPageNumber = size - 1;
            }
            this.fCurrentPage = localPageNumber;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void broadcast(TmfSignal signal) {
        this.fIsSignalSent = true;
        super.broadcast(signal);
        this.fIsSignalSent = false;
    }

    protected void cancelOngoingRequests() {
        this.fLock.lock();
        ITmfEventRequest pageRequest = null;
        try {
            if (this.fFindJob != null) {
                this.fFindJob.cancel();
            }
            this.fFindResults = null;
            this.fFindCriteria = null;
            this.fCurrentFindIndex = 0;
            pageRequest = this.fPageRequest;
            this.fPageRequest = null;
        }
        finally {
            this.fLock.unlock();
        }
        if (pageRequest != null && !pageRequest.isCompleted()) {
            pageRequest.cancel();
        }
    }

    protected void resetLoader() {
        this.fLock.lock();
        try {
            this.fCurrentTime = null;
            this.fEvents.clear();
            this.fCheckPoints.clear();
            this.fCurrentPage = 0;
            this.fCurrentFindIndex = 0;
            this.fFindCriteria = null;
            this.fFindResults = null;
            this.fView.setFrameSync(new Frame());
            this.fFrame = null;
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected void fillCurrentPage(List<ITmfSyncSequenceDiagramEvent> events) {
        this.fLock.lock();
        try {
            this.fEvents = new ArrayList<ITmfSyncSequenceDiagramEvent>(events);
            if (this.fView != null && !events.isEmpty()) {
                this.fView.toggleWaitCursorAsync(true);
            }
        }
        finally {
            this.fLock.unlock();
        }
        Frame frame = new Frame();
        if (!events.isEmpty()) {
            HashMap<String, Lifeline> nodeToLifelineMap = new HashMap<String, Lifeline>();
            frame.setName(Messages.TmfUml2SDSyncLoader_FrameName);
            int i = 0;
            while (i < events.size()) {
                Lifeline lifeline;
                ITmfSyncSequenceDiagramEvent sdEvent = events.get(i);
                if (nodeToLifelineMap.get(sdEvent.getSender()) == null && !this.filterLifeLine(sdEvent.getSender())) {
                    lifeline = new Lifeline();
                    lifeline.setName(sdEvent.getSender());
                    nodeToLifelineMap.put(sdEvent.getSender(), lifeline);
                    frame.addLifeLine(lifeline);
                }
                if (nodeToLifelineMap.get(sdEvent.getReceiver()) == null && !this.filterLifeLine(sdEvent.getReceiver())) {
                    lifeline = new Lifeline();
                    lifeline.setName(sdEvent.getReceiver());
                    nodeToLifelineMap.put(sdEvent.getReceiver(), lifeline);
                    frame.addLifeLine(lifeline);
                }
                ++i;
            }
            int eventOccurence = 1;
            int i2 = 0;
            while (i2 < events.size()) {
                ITmfSyncSequenceDiagramEvent sdEvent = events.get(i2);
                if (!this.filterMessage(sdEvent)) {
                    Lifeline startLifeline = (Lifeline)nodeToLifelineMap.get(sdEvent.getSender());
                    Lifeline endLifeline = (Lifeline)nodeToLifelineMap.get(sdEvent.getReceiver());
                    if (startLifeline != null && endLifeline != null) {
                        int tmp = Math.max(startLifeline.getEventOccurrence(), endLifeline.getEventOccurrence());
                        eventOccurence = Math.max(eventOccurence, tmp);
                        startLifeline.setCurrentEventOccurrence(eventOccurence);
                        endLifeline.setCurrentEventOccurrence(eventOccurence);
                        TmfSyncMessage message = new TmfSyncMessage(sdEvent, eventOccurence++);
                        message.setStartLifeline(startLifeline);
                        message.setEndLifeline(endLifeline);
                        message.setTime(sdEvent.getStartTime());
                        frame.addMessage(message);
                    }
                }
                ++i2;
            }
            this.fLock.lock();
            try {
                if (!this.fView.getSDWidget().isDisposed()) {
                    this.fView.getSDWidget().getDisplay().asyncExec(() -> {
                        this.fLock.lock();
                        try {
                            if (this.fView != null && !this.fView.getSDWidget().isDisposed()) {
                                this.fFrame = frame;
                                this.fView.setFrame(this.fFrame);
                                if (this.fCurrentTime != null) {
                                    this.moveToMessageInPage();
                                }
                                if (this.fFindCriteria != null) {
                                    this.find(this.fFindCriteria);
                                }
                                this.fView.toggleWaitCursorAsync(false);
                            }
                        }
                        finally {
                            this.fLock.unlock();
                        }
                    });
                }
            }
            finally {
                this.fLock.unlock();
            }
        }
    }

    protected void moveToMessage() {
        int page = 0;
        this.fLock.lock();
        try {
            page = this.getPage(this.fCurrentTime);
            if (page == this.fCurrentPage) {
                this.moveToMessageInPage();
                return;
            }
            this.fCurrentPage = page;
            this.moveToPage(false);
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected void moveToMessageInPage() {
        this.fLock.lock();
        try {
            if (!this.fView.getSDWidget().isDisposed()) {
                if (Display.getCurrent() != null) {
                    TmfSyncMessage prevMessage = null;
                    TmfSyncMessage syncMessage = null;
                    boolean isExactTime = false;
                    int i = 0;
                    while (i < this.fFrame.syncMessageCount()) {
                        if (this.fFrame.getSyncMessage(i) instanceof TmfSyncMessage) {
                            syncMessage = (TmfSyncMessage)this.fFrame.getSyncMessage(i);
                            if (syncMessage.getStartTime().compareTo(this.fCurrentTime) == 0) {
                                isExactTime = true;
                                break;
                            }
                            if (syncMessage.getStartTime().compareTo(this.fCurrentTime) > 0 && prevMessage != null) {
                                syncMessage = prevMessage;
                                break;
                            }
                            prevMessage = syncMessage;
                        }
                        ++i;
                    }
                    if (this.fIsSelect && isExactTime) {
                        this.fView.getSDWidget().moveTo(syncMessage);
                    } else {
                        this.fView.getSDWidget().ensureVisible(syncMessage);
                        this.fView.getSDWidget().clearSelection();
                        this.fView.getSDWidget().redraw();
                    }
                } else {
                    this.fView.getSDWidget().getDisplay().asyncExec(this::moveToMessageInPage);
                }
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected void moveToPage() {
        this.moveToPage(true);
    }

    protected void moveToPage(boolean notifyAll) {
        TmfTimeRange window = null;
        this.fLock.lock();
        try {
            if (this.fCurrentPage > this.fCheckPoints.size()) {
                return;
            }
            window = this.fCheckPoints.get(this.fCurrentPage);
        }
        finally {
            this.fLock.unlock();
        }
        if (window == null) {
            window = TmfTimeRange.ETERNITY;
        }
        this.fPageRequest = new TmfEventRequest(ITmfEvent.class, window, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND){
            private final List<ITmfSyncSequenceDiagramEvent> fSdEvent;
            {
                this.fSdEvent = new ArrayList<ITmfSyncSequenceDiagramEvent>();
            }

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                ITmfSyncSequenceDiagramEvent sdEvent = TmfUml2SDSyncLoader.this.getSequenceDiagramEvent(event);
                if (sdEvent != null) {
                    this.fSdEvent.add(sdEvent);
                }
            }

            public void handleSuccess() {
                TmfUml2SDSyncLoader.this.fillCurrentPage(this.fSdEvent);
                super.handleSuccess();
            }
        };
        this.fTrace.sendRequest(this.fPageRequest);
        if (notifyAll) {
            TmfTimeRange timeRange = this.getSignalTimeRange(window.getStartTime());
            this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, timeRange, this.fTrace));
        }
    }

    protected int getPage(ITmfTimestamp time) {
        this.fLock.lock();
        try {
            int size = this.fCheckPoints.size();
            int page = 0;
            while (page < size) {
                TmfTimeRange timeRange = this.fCheckPoints.get(page);
                if (timeRange.getEndTime().compareTo(time) >= 0) break;
                ++page;
            }
            if (page >= size) {
                page = size - 1;
            }
            int n = page;
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected boolean findInNextPages(Criteria findCriteria) {
        this.fLock.lock();
        try {
            if (this.fFindJob != null) {
                return true;
            }
            int nextPage = this.fCurrentPage + 1;
            if (nextPage >= this.fCheckPoints.size()) {
                return false;
            }
            TmfTimeRange window = new TmfTimeRange(this.fCheckPoints.get(nextPage).getStartTime(), this.fCheckPoints.get(this.fCheckPoints.size() - 1).getEndTime());
            this.fFindJob = new SearchJob(findCriteria, window);
            this.fFindJob.schedule();
            this.fView.toggleWaitCursorAsync(true);
        }
        finally {
            this.fLock.unlock();
        }
        return true;
    }

    protected TmfTimeRange getSignalTimeRange(ITmfTimestamp startTime) {
        this.fLock.lock();
        try {
            TmfTimeRange currentRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            long offset = this.fTrace == null ? 0L : currentRange.getEndTime().getDelta(currentRange.getStartTime()).toNanos();
            ITmfTimestamp initialEndOfWindow = TmfTimestamp.create((long)(startTime.getValue() + offset), (int)startTime.getScale());
            TmfTimeRange tmfTimeRange = new TmfTimeRange(startTime, initialEndOfWindow);
            return tmfTimeRange;
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected boolean filterMessage(ITmfSyncSequenceDiagramEvent sdEvent) {
        this.fLock.lock();
        try {
            if (this.fFilterCriteria != null) {
                for (FilterCriteria criteria : this.fFilterCriteria) {
                    if (!criteria.isActive() || !criteria.getCriteria().isSyncMessageSelected() || !criteria.getCriteria().matches(sdEvent.getName())) continue;
                    return true;
                }
            }
        }
        finally {
            this.fLock.unlock();
        }
        return false;
    }

    protected boolean filterLifeLine(String lifeline) {
        this.fLock.lock();
        try {
            if (this.fFilterCriteria != null) {
                for (FilterCriteria criteria : this.fFilterCriteria) {
                    if (!criteria.isActive() || !criteria.getCriteria().isLifeLineSelected() || !criteria.getCriteria().matches(lifeline)) continue;
                    return true;
                }
            }
        }
        finally {
            this.fLock.unlock();
        }
        return false;
    }

    protected ITmfSyncSequenceDiagramEvent getSequenceDiagramEvent(ITmfEvent tmfEvent) {
        String eventName = tmfEvent.getName();
        if (eventName.contains(Messages.TmfUml2SDSyncLoader_EventTypeSend) || eventName.contains(Messages.TmfUml2SDSyncLoader_EventTypeReceive)) {
            Object sender = tmfEvent.getContent().getFieldValue(Object.class, new String[]{(String)NonNullUtils.checkNotNull((Object)Messages.TmfUml2SDSyncLoader_FieldSender)});
            Object receiver = tmfEvent.getContent().getFieldValue(Object.class, new String[]{(String)NonNullUtils.checkNotNull((Object)Messages.TmfUml2SDSyncLoader_FieldReceiver)});
            ITmfEventField content = tmfEvent.getContent();
            Object name = content.getFieldValue(Object.class, new String[]{(String)NonNullUtils.checkNotNull((Object)Messages.TmfUml2SDSyncLoader_FieldSignal)});
            if (sender != null && receiver != null && name != null) {
                TmfSyncSequenceDiagramEvent sdEvent = new TmfSyncSequenceDiagramEvent(tmfEvent, sender.toString(), receiver.toString(), name.toString());
                return sdEvent;
            }
        }
        return null;
    }

    protected static class IndexingJob
    extends Job {
        public IndexingJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!monitor.isCanceled()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return Status.OK_STATUS;
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    protected class SearchEventRequest
    extends TmfEventRequest {
        private final Criteria fCriteria;
        private IProgressMonitor fMonitor;
        private boolean fIsFound;
        private ITmfTimestamp fFoundTime;

        public SearchEventRequest(TmfTimeRange range, int nbRequested, ITmfEventRequest.ExecutionType priority, Criteria criteria) {
            this(range, nbRequested, priority, criteria, null);
        }

        public SearchEventRequest(TmfTimeRange range, int nbRequested, ITmfEventRequest.ExecutionType priority, Criteria criteria, IProgressMonitor monitor) {
            super(ITmfEvent.class, range, 0L, nbRequested, priority);
            this.fIsFound = false;
            this.fFoundTime = null;
            this.fCriteria = new Criteria(criteria);
            this.fMonitor = monitor;
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (this.fMonitor != null && this.fMonitor.isCanceled()) {
                super.cancel();
                return;
            }
            ITmfSyncSequenceDiagramEvent sdEvent = TmfUml2SDSyncLoader.this.getSequenceDiagramEvent(event);
            if (sdEvent != null) {
                if (this.fCriteria.isLifeLineSelected()) {
                    if (this.fCriteria.matches(sdEvent.getSender())) {
                        this.fFoundTime = event.getTimestamp();
                        this.fIsFound = true;
                        super.cancel();
                    }
                    if (this.fCriteria.matches(sdEvent.getReceiver())) {
                        this.fFoundTime = event.getTimestamp();
                        this.fIsFound = true;
                        super.cancel();
                    }
                }
                if (this.fCriteria.isSyncMessageSelected() && this.fCriteria.matches(sdEvent.getName())) {
                    this.fFoundTime = event.getTimestamp();
                    this.fIsFound = true;
                    super.cancel();
                }
            }
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public boolean isFound() {
            return this.fIsFound;
        }

        public ITmfTimestamp getFoundTime() {
            return this.fFoundTime;
        }
    }

    protected class SearchJob
    extends Job {
        protected final SearchEventRequest fSearchRequest;

        public SearchJob(Criteria findCriteria, TmfTimeRange window) {
            super(Messages.TmfUml2SDSyncLoader_SearchJobDescrition);
            this.fSearchRequest = new SearchEventRequest(window, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND, findCriteria);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.fSearchRequest.setMonitor(monitor);
            TmfUml2SDSyncLoader.this.fTrace.sendRequest((ITmfEventRequest)this.fSearchRequest);
            try {
                this.fSearchRequest.waitForCompletion();
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError("Search request interrupted!", e);
            }
            Object status = Status.OK_STATUS;
            if (this.fSearchRequest.isFound() && this.fSearchRequest.getFoundTime() != null) {
                TmfUml2SDSyncLoader.this.fCurrentTime = this.fSearchRequest.getFoundTime();
                TmfUml2SDSyncLoader.this.fIsSelect = false;
                if (!TmfUml2SDSyncLoader.this.fView.getSDWidget().isDisposed()) {
                    TmfUml2SDSyncLoader.this.fView.getSDWidget().getDisplay().asyncExec(() -> TmfUml2SDSyncLoader.this.moveToMessage());
                }
            } else {
                status = monitor.isCanceled() ? Status.CANCEL_STATUS : new Status(2, "org.eclipse.tracecompass.tmf.ui", Messages.TmfUml2SDSyncLoader_SearchNotFound);
                this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            }
            monitor.done();
            TmfUml2SDSyncLoader.this.fLock.lock();
            try {
                TmfUml2SDSyncLoader.this.fView.toggleWaitCursorAsync(false);
                TmfUml2SDSyncLoader.this.fFindJob = null;
            }
            finally {
                TmfUml2SDSyncLoader.this.fLock.unlock();
            }
            return status;
        }

        protected void canceling() {
            this.fSearchRequest.cancel();
            TmfUml2SDSyncLoader.this.fLock.lock();
            try {
                TmfUml2SDSyncLoader.this.fFindJob = null;
            }
            finally {
                TmfUml2SDSyncLoader.this.fLock.unlock();
            }
        }
    }
}

