/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.genericeditor.AutoEditStrategyRegistry;
import org.eclipse.ui.internal.genericeditor.CharacterPairMatcherRegistry;
import org.eclipse.ui.internal.genericeditor.ContentAssistProcessorRegistry;
import org.eclipse.ui.internal.genericeditor.IconsRegistry;
import org.eclipse.ui.internal.genericeditor.PresentationReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.ReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.hover.TextHoverRegistry;
import org.eclipse.ui.internal.genericeditor.preferences.GenericEditorPluginPreferenceInitializer;
import org.eclipse.ui.internal.genericeditor.preferences.GenericEditorPreferenceConstants;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GenericEditorPlugin
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.ui.genericeditor";
    private static GenericEditorPlugin INSTANCE;
    private TextHoverRegistry textHoversRegistry;
    private ContentAssistProcessorRegistry contentAssistProcessorsRegistry;
    private ReconcilerRegistry reconcilierRegistry;
    private PresentationReconcilerRegistry presentationReconcilierRegistry;
    private AutoEditStrategyRegistry autoEditStrategyRegistry;
    private CharacterPairMatcherRegistry characterPairMatcherRegistry;
    private IconsRegistry editorImagesRegistry;
    private IPropertyChangeListener themeListener;

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        super.start(context);
        if (PlatformUI.isWorkbenchRunning()) {
            this.themeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("CHANGE_CURRENT_THEME".equals(event.getProperty())) {
                        GenericEditorPluginPreferenceInitializer.setThemeBasedPreferences(GenericEditorPreferenceConstants.getPreferenceStore(), true);
                    }
                }
            };
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.themeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
            this.themeListener = null;
        }
        INSTANCE = null;
    }

    public static GenericEditorPlugin getDefault() {
        return INSTANCE;
    }

    public synchronized TextHoverRegistry getHoverRegistry() {
        if (this.textHoversRegistry == null) {
            this.textHoversRegistry = new TextHoverRegistry(this.getPreferenceStore());
        }
        return this.textHoversRegistry;
    }

    public synchronized ContentAssistProcessorRegistry getContentAssistProcessorRegistry() {
        if (this.contentAssistProcessorsRegistry == null) {
            this.contentAssistProcessorsRegistry = new ContentAssistProcessorRegistry();
        }
        return this.contentAssistProcessorsRegistry;
    }

    public synchronized ReconcilerRegistry getReconcilerRegistry() {
        if (this.reconcilierRegistry == null) {
            this.reconcilierRegistry = new ReconcilerRegistry();
        }
        return this.reconcilierRegistry;
    }

    public synchronized PresentationReconcilerRegistry getPresentationReconcilerRegistry() {
        if (this.presentationReconcilierRegistry == null) {
            this.presentationReconcilierRegistry = new PresentationReconcilerRegistry();
        }
        return this.presentationReconcilierRegistry;
    }

    public synchronized AutoEditStrategyRegistry getAutoEditStrategyRegistry() {
        if (this.autoEditStrategyRegistry == null) {
            this.autoEditStrategyRegistry = new AutoEditStrategyRegistry();
        }
        return this.autoEditStrategyRegistry;
    }

    public synchronized CharacterPairMatcherRegistry getCharacterPairMatcherRegistry() {
        if (this.characterPairMatcherRegistry == null) {
            this.characterPairMatcherRegistry = new CharacterPairMatcherRegistry();
        }
        return this.characterPairMatcherRegistry;
    }

    public synchronized IconsRegistry getContentTypeImagesRegistry() {
        if (this.editorImagesRegistry == null) {
            this.editorImagesRegistry = new IconsRegistry();
        }
        return this.editorImagesRegistry;
    }
}

