/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.registry.ImportExportPespectiveHandler;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectiveRegistry
implements IPerspectiveRegistry,
IExtensionChangeHandler {
    @Inject
    private IExtensionRegistry extensionRegistry;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;
    @Inject
    IEclipseContext context;
    private IEclipseContext impExpHandlerContext;
    @Inject
    Logger logger;
    private Map<String, PerspectiveDescriptor> descriptors = new HashMap<String, PerspectiveDescriptor>();

    @PostConstruct
    void postConstruct(MApplication application) {
        String id;
        IExtensionPoint point = this.extensionRegistry.getExtensionPoint("org.eclipse.ui.perspectives");
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            id = element.getAttribute("id");
            this.descriptors.put(id, new PerspectiveDescriptor(id, element));
            ++n2;
        }
        List snippets = application.getSnippets();
        for (MUIElement snippet : snippets) {
            if (!(snippet instanceof MPerspective)) continue;
            MPerspective perspective = (MPerspective)snippet;
            id = perspective.getElementId();
            PerspectiveDescriptor existingDescriptor = this.descriptors.get(id);
            if (existingDescriptor == null) {
                this.createDescriptor(perspective);
                continue;
            }
            existingDescriptor.setHasCustomDefinition(true);
        }
        this.impExpHandlerContext = this.context.createChild();
        this.impExpHandlerContext.set(PerspectiveRegistry.class, (Object)this);
        ContextInjectionFactory.make(ImportExportPespectiveHandler.class, (IEclipseContext)this.impExpHandlerContext);
    }

    public void addPerspective(MPerspective perspective) {
        this.application.getSnippets().add(perspective);
        this.createDescriptor(perspective);
    }

    private void createDescriptor(MPerspective perspective) {
        String label = perspective.getLocalizedLabel();
        String originalId = this.getOriginalId(perspective);
        PerspectiveDescriptor originalDescriptor = this.descriptors.get(originalId);
        String id = perspective.getElementId();
        PerspectiveDescriptor newDescriptor = new PerspectiveDescriptor(id, label, originalDescriptor);
        if (perspective.getIconURI() != null) {
            try {
                ImageDescriptor img = ImageDescriptor.createFromURL((URL)new URI(perspective.getIconURI()).toURL());
                newDescriptor.setImageDescriptor(img);
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                this.logger.warn((Throwable)e, MessageFormat.format("Error on applying configured perspective icon: {0}", perspective.getIconURI()));
            }
        }
        this.descriptors.put(id, newDescriptor);
    }

    public PerspectiveRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, null);
    }

    @Override
    public IPerspectiveDescriptor clonePerspective(String id, String label, IPerspectiveDescriptor desc) throws IllegalArgumentException {
        E4Util.unsupported("clonePerspective");
        return null;
    }

    @Override
    public void deletePerspective(IPerspectiveDescriptor toDelete) {
        PerspectiveDescriptor perspective = (PerspectiveDescriptor)toDelete;
        if (perspective.isPredefined()) {
            return;
        }
        this.descriptors.remove(perspective.getId());
        this.removeSnippet((MSnippetContainer)this.application, perspective.getId());
    }

    private MUIElement removeSnippet(MSnippetContainer snippetContainer, String id) {
        MUIElement snippet = this.modelService.findSnippet(snippetContainer, id);
        if (snippet != null) {
            snippetContainer.getSnippets().remove(snippet);
        }
        return snippet;
    }

    public void deletePerspectives(ArrayList<IPerspectiveDescriptor> perspToDelete) {
        int i = 0;
        while (i < perspToDelete.size()) {
            this.deletePerspective(perspToDelete.get(i));
            ++i;
        }
    }

    @Override
    public IPerspectiveDescriptor findPerspectiveWithId(String perspectiveId) {
        return this.findPerspectiveWithId(perspectiveId, true);
    }

    public IPerspectiveDescriptor findPerspectiveWithId(String perspectiveId, boolean considerRestrictRules) {
        IPerspectiveDescriptor candidate = this.descriptors.get(perspectiveId);
        if (considerRestrictRules && WorkbenchActivityHelper.restrictUseOf(candidate)) {
            return null;
        }
        return candidate;
    }

    @Override
    public IPerspectiveDescriptor findPerspectiveWithLabel(String label) {
        for (IPerspectiveDescriptor iPerspectiveDescriptor : this.descriptors.values()) {
            if (!iPerspectiveDescriptor.getLabel().equals(label)) continue;
            if (WorkbenchActivityHelper.restrictUseOf(iPerspectiveDescriptor)) {
                return null;
            }
            return iPerspectiveDescriptor;
        }
        return null;
    }

    @Override
    public String getDefaultPerspective() {
        String defaultId = PrefUtil.getAPIPreferenceStore().getString("defaultPerspectiveId");
        if (defaultId.length() == 0 || this.findPerspectiveWithId(defaultId) == null) {
            Workbench instance = Workbench.getInstance();
            return instance == null ? null : instance.getDefaultPerspectiveId();
        }
        return defaultId;
    }

    @Override
    public IPerspectiveDescriptor[] getPerspectives() {
        Collection<PerspectiveDescriptor> descs = WorkbenchActivityHelper.restrictCollection(this.descriptors.values(), new ArrayList());
        return descs.toArray(new IPerspectiveDescriptor[descs.size()]);
    }

    @Override
    public void setDefaultPerspective(String id) {
        IPerspectiveDescriptor desc = this.findPerspectiveWithId(id);
        if (desc != null) {
            PrefUtil.getAPIPreferenceStore().setValue("defaultPerspectiveId", id);
        }
    }

    public boolean validateLabel(String label) {
        return (label = label.trim()).length() > 0;
    }

    @Override
    public void revertPerspective(IPerspectiveDescriptor perspToRevert) {
        PerspectiveDescriptor perspective = (PerspectiveDescriptor)perspToRevert;
        if (!perspective.isPredefined()) {
            return;
        }
        perspective.setHasCustomDefinition(false);
        this.removeSnippet((MSnippetContainer)this.application, perspective.getId());
    }

    public void dispose() {
        if (this.impExpHandlerContext != null) {
            this.impExpHandlerContext.dispose();
        }
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    public void removeExtension(IExtension source, Object[] objects) {
    }

    public void addExtension(IExtensionTracker tracker, IExtension addedExtension) {
    }

    public PerspectiveDescriptor createPerspective(String label, PerspectiveDescriptor originalDescriptor) {
        String newID = this.createNewId(label, originalDescriptor);
        PerspectiveDescriptor newDescriptor = new PerspectiveDescriptor(newID, label, originalDescriptor);
        this.descriptors.put(newDescriptor.getId(), newDescriptor);
        return newDescriptor;
    }

    private String createNewId(String label, PerspectiveDescriptor originalDescriptor) {
        return String.valueOf(originalDescriptor.getOriginalId()) + '.' + label;
    }

    private String getOriginalId(MPerspective p) {
        String id = p.getElementId();
        String label = p.getLabel();
        if (label == null) {
            label = "";
            this.logger.warn(String.format("Perspective %s has no label. Contributor is %s.", p.getElementId(), p.getContributorURI()));
        }
        int index = id.lastIndexOf(46);
        String trimE4 = label.trim();
        String trimE3 = label.replace(' ', '_').trim();
        if (id.endsWith(label)) {
            index = id.lastIndexOf(label) - 1;
        } else if (id.endsWith(trimE4)) {
            index = id.lastIndexOf(trimE4) - 1;
        } else if (id.endsWith(trimE3)) {
            index = id.lastIndexOf(trimE3) - 1;
        }
        if (index >= 0 && index < id.length()) {
            return id.substring(0, index);
        }
        return id;
    }
}

