/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.internal.HashUtil;

public class VirtualArchiveComponent
implements IVirtualComponent,
IAdaptable {
    public static final Class ADAPTER_TYPE = VirtualArchiveComponent.class;
    public static final String LIBARCHIVETYPE = "lib";
    public static final String VARARCHIVETYPE = "var";
    public static final String CLASSPATHARCHIVETYPE = "cpe";
    private static final IVirtualReference[] NO_REFERENCES = new VirtualReference[0];
    private static final IVirtualComponent[] NO_COMPONENTS = new VirtualComponent[0];
    private static final IVirtualResource[] NO_VIRTUAL_RESOURCES = null;
    private static final Properties NO_PROPERTIES = new Properties();
    private static final IPath[] NO_PATHS = new Path[0];
    private IPath runtimePath;
    private IProject componentProject;
    private IPath archivePath;
    private String archiveType;

    public VirtualArchiveComponent(IProject aComponentProject, String archiveLocation, IPath aRuntimePath) {
        if (aComponentProject == null) {
            throw new NullPointerException();
        }
        this.componentProject = aComponentProject;
        this.runtimePath = aRuntimePath;
        String archivePathString = archiveLocation.substring(4, archiveLocation.length());
        this.archiveType = archiveLocation.substring(0, 3);
        this.archivePath = new Path(archivePathString);
    }

    @Override
    public IVirtualComponent getComponent() {
        return this;
    }

    @Override
    public String getName() {
        return String.valueOf(this.archiveType) + '/' + this.archivePath.toString();
    }

    @Override
    public String getDeployedName() {
        return this.getName();
    }

    public void setComponentTypeId(String aComponentTypeId) {
    }

    public int getType() {
        return 64;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public IPath[] getMetaResources() {
        return NO_PATHS;
    }

    @Override
    public void setMetaResources(IPath[] theMetaResourcePaths) {
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    @Deprecated
    public String getFileExtension() {
        return this.archivePath.getFileExtension();
    }

    @Deprecated
    public IPath getWorkspaceRelativePath() {
        IFile aFile;
        if (this.archivePath.segmentCount() > 1 && (aFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.archivePath)).exists()) {
            return aFile.getFullPath();
        }
        return null;
    }

    @Deprecated
    public IPath getProjectRelativePath() {
        IFile aFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getWorkspaceRelativePath());
        if (aFile.exists()) {
            return aFile.getProjectRelativePath();
        }
        return null;
    }

    @Override
    public IProject getProject() {
        return this.componentProject;
    }

    public IPath getRuntimePath() {
        return this.runtimePath == null ? ROOT : this.runtimePath;
    }

    public IPath getArchivePath() {
        return this.archivePath;
    }

    public boolean isAccessible() {
        return true;
    }

    @Override
    public Properties getMetaProperties() {
        return NO_PROPERTIES;
    }

    public IVirtualResource[] getResources(String aResourceType) {
        return NO_VIRTUAL_RESOURCES;
    }

    @Override
    public void create(int updateFlags, IProgressMonitor aMonitor) throws CoreException {
    }

    @Override
    public IVirtualReference[] getReferences(Map<String, Object> options) {
        return NO_REFERENCES;
    }

    @Override
    public IVirtualReference[] getReferences() {
        return NO_REFERENCES;
    }

    @Override
    public void setReferences(IVirtualReference[] theReferences) {
    }

    @Override
    public void addReferences(IVirtualReference[] references) {
    }

    @Override
    public IVirtualReference getReference(String aComponentName) {
        return null;
    }

    @Override
    public boolean exists() {
        File f = (File)this.getAdapter(File.class);
        return f != null && f.exists();
    }

    @Override
    public IVirtualFolder getRootFolder() {
        return null;
    }

    @Override
    public IVirtualComponent[] getReferencingComponents() {
        return NO_COMPONENTS;
    }

    public Object getAdapter(Class adapterType) {
        if (File.class.equals((Object)adapterType)) {
            return this.getUnderlyingDiskFile();
        }
        if (IFile.class.equals((Object)adapterType)) {
            return this.getUnderlyingWorkbenchFile();
        }
        if (IPath.class.equals((Object)adapterType)) {
            IFile f = this.getUnderlyingWorkbenchFile();
            if (f != null) {
                return f.getFullPath();
            }
            File f2 = this.getUnderlyingDiskFile();
            if (f2 != null) {
                return new Path(f2.getAbsolutePath());
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String getArchiveType() {
        return this.archiveType;
    }

    public int hashCode() {
        int hash = HashUtil.SEED;
        hash = HashUtil.hash((int)hash, (Object)this.getProject().getName());
        hash = HashUtil.hash((int)hash, (Object)this.getName());
        hash = HashUtil.hash((int)hash, (boolean)this.isBinary());
        return hash;
    }

    public boolean equals(Object anOther) {
        if (anOther instanceof VirtualArchiveComponent) {
            VirtualArchiveComponent otherComponent = (VirtualArchiveComponent)anOther;
            return this.getProject().equals((Object)otherComponent.getProject()) && this.getName().equals(otherComponent.getName()) && this.isBinary() == otherComponent.isBinary();
        }
        return false;
    }

    @Override
    public void setMetaProperty(String name, String value) {
    }

    @Override
    public void setMetaProperties(Properties properties) {
    }

    @Deprecated
    public IFile getUnderlyingWorkbenchFile() {
        if (this.getWorkspaceRelativePath() == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getWorkspaceRelativePath());
    }

    @Deprecated
    public File getUnderlyingDiskFile() {
        String osPath = null;
        IPath loc = null;
        if (this.getArchiveType().equals(VARARCHIVETYPE)) {
            IPath resolvedpath = (IPath)Platform.getAdapterManager().getAdapter((Object)this, IPath.class);
            if (resolvedpath != null) {
                osPath = resolvedpath.toOSString();
            }
        } else if (!this.archivePath.isAbsolute()) {
            IFile file = this.getProject().getFile(this.archivePath);
            if (file.exists()) {
                loc = file.getLocation();
            } else if (this.archivePath.segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.archivePath)).exists()) {
                loc = file.getLocation();
            }
            if (loc != null) {
                osPath = loc.toOSString();
            }
        } else {
            osPath = this.archivePath.toOSString();
        }
        if (osPath == null || osPath.length() == 0) {
            return null;
        }
        File diskFile = new File(osPath);
        return diskFile;
    }

    public String toString() {
        if (this.archivePath != null) {
            return this.componentProject + " " + this.archivePath;
        }
        return super.toString();
    }
}

