/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.monitor.core.internal.IProtocolAdapter;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;

public class MonitorDialog
extends Dialog {
    protected IMonitorWorkingCopy monitor;
    protected boolean isEdit;
    private Button okButton;
    private Spinner monitorPort;
    private Label validateLabel;

    public MonitorDialog(Shell parentShell, IMonitorWorkingCopy monitor) {
        super(parentShell);
        this.monitor = monitor;
        this.isEdit = true;
    }

    public MonitorDialog(Shell parentShell) {
        super(parentShell);
        this.monitor = MonitorCore.createMonitor();
        this.isEdit = false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isEdit) {
            shell.setText(Messages.editMonitor);
        } else {
            shell.setText(Messages.newMonitor);
        }
    }

    protected Button createCheckBox(Composite comp, String txt, boolean selected, final BooleanModifyListener listener) {
        final Button button = new Button(comp, 32);
        button.setText(txt);
        button.setSelection(selected);
        button.setLayoutData((Object)new GridData(36));
        if (listener != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    listener.valueChanged(button.getSelection());
                }
            });
        }
        return button;
    }

    protected Label createLabel(Composite comp, String txt) {
        Label label = new Label(comp, 0);
        label.setText(txt);
        label.setLayoutData((Object)new GridData(36));
        return label;
    }

    protected Text createText(Composite comp, String txt, final StringModifyListener listener) {
        final Text text = new Text(comp, 2048);
        if (txt != null) {
            text.setText(txt);
        }
        GridData data = new GridData(772);
        data.widthHint = 150;
        text.setLayoutData((Object)data);
        if (listener != null) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    listener.valueChanged(text.getText());
                }
            });
        }
        return text;
    }

    protected Spinner createSpinner(Composite comp, int v, final IntModifyListener listener) {
        final Spinner s = new Spinner(comp, 2048);
        s.setMinimum(0);
        s.setMaximum(Integer.MAX_VALUE);
        if (v != -1) {
            s.setSelection(v);
        }
        GridData data = new GridData(772);
        data.widthHint = 150;
        s.setLayoutData((Object)data);
        if (listener != null) {
            s.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    listener.valueChanged(s.getSelection());
                }
            });
        }
        return s;
    }

    protected Combo createTypeCombo(Composite comp, final String[] types, String sel, final StringModifyListener listener) {
        final Combo combo = new Combo(comp, 12);
        int size = types.length;
        String[] items = new String[size];
        int index = -1;
        int i = 0;
        while (i < size) {
            items[i] = types[i];
            if (types[i].equals(sel)) {
                index = i;
            }
            ++i;
        }
        combo.setItems(items);
        if (index >= 0) {
            combo.select(index);
        }
        GridData data = new GridData(260);
        data.widthHint = 150;
        combo.setLayoutData((Object)data);
        if (listener != null) {
            combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    listener.valueChanged(types[combo.getSelectionIndex()]);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        return combo;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.internet.monitor.ui.tmpr0006");
        this.createLabel(composite, Messages.localPort);
        this.monitorPort = this.createSpinner(composite, this.monitor.getLocalPort(), new IntModifyListener(){

            public void valueChanged(int i) {
                try {
                    MonitorDialog.this.monitor.setLocalPort(i);
                }
                catch (Exception exception) {}
                MonitorDialog.this.validateFields();
            }
        });
        Group group = new Group(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(Messages.remoteGroup);
        this.createLabel((Composite)group, Messages.remoteHost);
        this.createText((Composite)group, this.monitor.getRemoteHost(), new StringModifyListener(){

            public void valueChanged(String s) {
                MonitorDialog.this.monitor.setRemoteHost(s);
                MonitorDialog.this.validateFields();
            }
        });
        this.createLabel((Composite)group, Messages.remotePort);
        this.createSpinner((Composite)group, this.monitor.getRemotePort(), new IntModifyListener(){

            public void valueChanged(int i) {
                try {
                    MonitorDialog.this.monitor.setRemotePort(i);
                }
                catch (Exception exception) {}
                MonitorDialog.this.validateFields();
            }
        });
        this.createLabel((Composite)group, Messages.parseType);
        this.createTypeCombo((Composite)group, new String[]{"TCP/IP", "HTTP"}, this.monitor.getProtocol(), new StringModifyListener(){

            public void valueChanged(String protocolId) {
                MonitorDialog.this.monitor.setProtocol(protocolId);
            }
        });
        this.createLabel((Composite)group, Messages.connectionTimeout);
        this.createSpinner((Composite)group, this.monitor.getTimeout(), new IntModifyListener(){

            public void valueChanged(int i) {
                MonitorDialog.this.monitor.setTimeout(i);
                MonitorDialog.this.validateFields();
            }
        });
        this.createLabel((Composite)group, "");
        this.createCheckBox((Composite)group, Messages.autoStart, this.monitor.isAutoStart(), new BooleanModifyListener(){

            public void valueChanged(boolean b) {
                MonitorDialog.this.monitor.setAutoStart(b);
            }
        });
        this.validateLabel = this.createLabel(composite, "");
        this.validateLabel.setForeground(composite.getDisplay().getSystemColor(3));
        return composite;
    }

    protected void okPressed() {
        IMonitor savedMonitor = null;
        try {
            savedMonitor = this.monitor.save();
        }
        catch (CoreException ce) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.errorDialogTitle, (String)ce.getLocalizedMessage(), (IStatus)ce.getStatus());
            return;
        }
        if (savedMonitor != null && savedMonitor.isAutoStart()) {
            try {
                savedMonitor.start();
            }
            catch (CoreException ce) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.errorDialogTitle, (String)ce.getLocalizedMessage(), (IStatus)ce.getStatus());
            }
        }
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonControl = super.createButtonBar(parent);
        this.validateFields();
        return buttonControl;
    }

    private void setOKButtonEnabled(boolean curIsEnabled) {
        if (this.okButton == null) {
            this.okButton = this.getButton(0);
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(curIsEnabled);
        }
    }

    protected void validateFields() {
        if (this.monitorPort == null) {
            return;
        }
        boolean result = true;
        IStatus status = this.monitor.validate();
        if (!status.isOK()) {
            if (this.monitor.getRemoteHost() == null || this.monitor.getRemoteHost().length() < 1) {
                this.validateLabel.setText("");
            } else {
                this.validateLabel.setText(status.getMessage());
            }
            result = false;
        } else {
            this.validateLabel.setText("");
        }
        this.setOKButtonEnabled(result);
    }

    static interface BooleanModifyListener {
        public void valueChanged(boolean var1);
    }

    static interface IntModifyListener {
        public void valueChanged(int var1);
    }

    static interface StringModifyListener {
        public void valueChanged(String var1);
    }

    static interface TypeModifyListener {
        public void valueChanged(IProtocolAdapter var1);
    }
}

