/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.bower.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.wst.jsdt.js.bower.BowerJson;
import org.eclipse.wst.jsdt.js.bower.internal.BowerConstants;
import org.eclipse.wst.jsdt.js.bower.internal.Messages;
import org.eclipse.wst.jsdt.js.common.ui.PopUpPropertyDialog;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;

public class BowerInitPage
extends WizardPage {
    private final IStructuredSelection selection;
    private IContainer selectedContainer;
    private Text dirText;
    private Text nameText;
    private Text versionText;
    private Text licenseText;
    private Button useDefaultCheckBox;
    private Table authorsTable;
    private Button addAuthorButton;
    private Table ignoreTable;
    private Button addIgnoreButton;
    private String defaultName;
    private String defaultVersion;
    private String defaultLicense;
    private List<String> defaultAuthors;
    private List<String> defaultIgnore;
    private String defaultDirectory;

    public BowerInitPage(IStructuredSelection selection) {
        super(Messages.BowerInitWizard_pageName);
        this.setTitle(Messages.BowerInitWizard_pageTitle);
        this.setDescription(Messages.BowerInitWizard_pageDescription);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite mainComposite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)mainComposite.getLayout()).verticalSpacing = 4;
        this.createExecutionDirEditor(mainComposite);
        this.createUseDefaultsEditor(mainComposite);
        this.createBasePropertyEditor(mainComposite);
        this.createAuthorsEditor(mainComposite);
        this.createIgnoreEditor(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
        this.initiDefaultsValues();
        this.setControl((Control)mainComposite);
    }

    public String getExecutionDir() {
        return this.dirText.getText();
    }

    public BowerJson getModel() {
        String name = this.nameText.getText();
        String version = this.versionText.getText();
        String license = this.licenseText.getText();
        List<String> authors = this.getItems(this.authorsTable);
        List<String> ignore = this.getItems(this.ignoreTable);
        BowerJson.Builder builder = new BowerJson.Builder();
        if (name != null && !name.isEmpty()) {
            builder.name(name);
        }
        if (version != null && !version.isEmpty()) {
            builder.version(version);
        }
        if (license != null && !license.isEmpty()) {
            builder.license(license);
        }
        if (authors != null && !authors.isEmpty()) {
            builder.authrors(authors);
        }
        if (ignore != null && !ignore.isEmpty()) {
            builder.ignore(ignore);
        }
        BowerJson model = builder.build();
        return model;
    }

    private void initiDefaultsValues() {
        this.selectedContainer = WorkbenchResourceUtil.getContainerFromSelection((IStructuredSelection)this.selection);
        String location = WorkbenchResourceUtil.getAbsolutePath((IResource)this.selectedContainer);
        this.defaultDirectory = location != null ? location : "";
        this.defaultName = this.selectedContainer != null ? this.selectedContainer.getProject().getName().replaceAll("\\s", "") : "Bower";
        this.defaultVersion = "0.0.0";
        this.defaultLicense = "MIT";
        this.defaultIgnore = Arrays.asList(BowerConstants.DEFAULT_IGNORE);
        this.dirText.setText(this.defaultDirectory);
        this.nameText.setText(this.defaultName);
        this.versionText.setText(this.defaultVersion);
        this.licenseText.setText(this.defaultLicense);
        this.setDefaults(this.authorsTable, this.defaultAuthors);
        this.setDefaults(this.ignoreTable, this.defaultIgnore);
        boolean useDefault = this.useDefaultCheckBox.getSelection();
        this.nameText.setEnabled(!useDefault);
        this.versionText.setEnabled(!useDefault);
        this.licenseText.setEnabled(!useDefault);
        this.authorsTable.setEnabled(!useDefault);
        this.addAuthorButton.setEnabled(!useDefault);
        this.ignoreTable.setEnabled(!useDefault);
        this.addIgnoreButton.setEnabled(!useDefault);
    }

    private void createExecutionDirEditor(Composite mainComposite) {
        Label label = new Label(mainComposite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        label.setText(Messages.BowerLaunchConfigurationTab_baseDirectory);
        this.dirText = new Text(mainComposite, 2048);
        this.dirText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        this.dirText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Composite buttonComposite = new Composite(mainComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 5, 1));
        GridLayout buttonGridLayout = new GridLayout();
        buttonGridLayout.marginWidth = 0;
        buttonGridLayout.marginHeight = 0;
        buttonGridLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)buttonGridLayout);
        Button browseWorkspaceButton = new Button(buttonComposite, 0);
        browseWorkspaceButton.setText(Messages.BowerLaunchConfigurationTab_browseWorkspace);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] resource;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(BowerInitPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.BowerLaunchConfigurationTab_rootFolderSelection);
                dialog.showClosedProjects(false);
                int buttonId = dialog.open();
                if (buttonId == 0 && (resource = dialog.getResult()) != null && resource.length > 0) {
                    IPath path = (IPath)resource[0];
                    IResource selectedResource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    String location = WorkbenchResourceUtil.getAbsolutePath((IResource)selectedResource);
                    if (selectedResource.exists()) {
                        BowerInitPage.this.dirText.setText(location);
                    }
                }
            }
        });
    }

    private void createUseDefaultsEditor(Composite mainComposite) {
        Composite group = SWTFactory.createComposite((Composite)mainComposite, (int)2, (int)1, (int)768);
        this.useDefaultCheckBox = SWTFactory.createCheckButton((Composite)group, (String)Messages.BowerLaunchConfigurationTab_useDefaulConfiguration, null, (boolean)true, (int)2);
        this.useDefaultCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefault = ((Button)e.widget).getSelection();
                BowerInitPage.this.nameText.setEnabled(!useDefault);
                BowerInitPage.this.versionText.setEnabled(!useDefault);
                BowerInitPage.this.licenseText.setEnabled(!useDefault);
                BowerInitPage.this.authorsTable.setEnabled(!useDefault);
                BowerInitPage.this.addAuthorButton.setEnabled(!useDefault);
                BowerInitPage.this.ignoreTable.setEnabled(!useDefault);
                BowerInitPage.this.addIgnoreButton.setEnabled(!useDefault);
                if (useDefault) {
                    BowerInitPage.this.setDefaults();
                } else {
                    BowerInitPage.this.nameText.setEnabled(true);
                    BowerInitPage.this.versionText.setEnabled(true);
                    BowerInitPage.this.licenseText.setEnabled(true);
                    BowerInitPage.this.authorsTable.setEnabled(true);
                    BowerInitPage.this.addAuthorButton.setEnabled(true);
                    BowerInitPage.this.ignoreTable.setEnabled(true);
                    BowerInitPage.this.addIgnoreButton.setEnabled(true);
                }
            }
        });
    }

    private void createBasePropertyEditor(Composite mainComposite) {
        Group group = SWTFactory.createGroup((Composite)mainComposite, (String)Messages.BowerLaunchConfigurationTab_Properties, (int)2, (int)1, (int)768);
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText(Messages.BowerLaunchConfigurationTab_Name);
        this.nameText = new Text((Composite)group, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.nameText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Label versionLabel = new Label((Composite)group, 0);
        versionLabel.setText(Messages.BowerLaunchConfigurationTab_Version);
        this.versionText = new Text((Composite)group, 2048);
        this.versionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.versionText.addModifyListener((ModifyListener)new EntriesChangedListener());
        Label licenseLabel = new Label((Composite)group, 0);
        licenseLabel.setText(Messages.BowerLaunchConfigurationTab_License);
        this.licenseText = new Text((Composite)group, 2048);
        this.licenseText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.licenseText.addModifyListener((ModifyListener)new EntriesChangedListener());
    }

    private void createAuthorsEditor(Composite mainComposite) {
        TableGroupComposite authorsComposite = new TableGroupComposite(Messages.BowerLaunchConfigurationTab_Authors, Messages.BowerLaunchConfigurationTab_Author, mainComposite, Messages.BowerInitWizard_addAuthor, Messages.BowerInitWizard_editAuthor);
        authorsComposite.createControls();
        this.authorsTable = authorsComposite.getTable();
        this.addAuthorButton = authorsComposite.getAddButton();
    }

    private void createIgnoreEditor(Composite mainComposite) {
        TableGroupComposite ignoreComposite = new TableGroupComposite(Messages.BowerLaunchConfigurationTab_Ignore, Messages.BowerLaunchConfigurationTab_Ignore, mainComposite, Messages.BowerInitWizard_addIgnore, Messages.BowerInitWizard_editIgnore);
        ignoreComposite.createControls();
        this.ignoreTable = ignoreComposite.getTable();
        this.addIgnoreButton = ignoreComposite.getAddButton();
    }

    public String getName() {
        return Messages.BowerLaunchConfigurationTab_launchMainTabName;
    }

    private List<String> getItems(Table table) {
        ArrayList<String> authors = new ArrayList<String>();
        TableItem[] items = table.getItems();
        if (items != null && items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                authors.add(item.getText());
                ++n2;
            }
        }
        return authors;
    }

    private void setDefaults(Table table, List<String> defaultItems) {
        if (table != null && defaultItems != null && !defaultItems.isEmpty()) {
            table.removeAll();
            for (String item : defaultItems) {
                new TableItem(table, 0).setText(item);
            }
        }
    }

    private void setDefaults() {
        this.nameText.setText(this.defaultName);
        this.versionText.setText(this.defaultVersion);
        this.licenseText.setText(this.defaultLicense);
        this.setDefaults(this.authorsTable, this.defaultAuthors);
        this.setDefaults(this.ignoreTable, this.defaultIgnore);
    }

    private void entriesChanged() {
        String dir = this.dirText.getText();
        if (dir == null || dir.isEmpty()) {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.BowerInitWizard_errorDirNotDefiened);
        } else {
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(dir));
            if (container != null && container.exists()) {
                IFile bowerJson = container.getFile((IPath)new Path("bower.json"));
                if (bowerJson.exists()) {
                    this.setError(Messages.BowerInitWizard_errorBowerJsonAlreadyExist);
                } else {
                    this.setComplete();
                }
            } else {
                this.setError(Messages.BowerInitWizard_errorDirNotExist);
            }
        }
    }

    private void setError(String message) {
        this.setPageComplete(false);
        this.setErrorMessage(message);
    }

    private void setComplete() {
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    private class EntriesChangedListener
    implements ModifyListener,
    SelectionListener {
        private EntriesChangedListener() {
        }

        public void modifyText(ModifyEvent e) {
            BowerInitPage.this.entriesChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            BowerInitPage.this.entriesChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            BowerInitPage.this.entriesChanged();
        }
    }

    private class TableGroupComposite {
        private String groupLabel;
        private String propertyLabel;
        private Composite parent;
        private Table table;
        private Button addButton;
        private Button editButton;
        private Button removeButton;
        private String addDialogTitle;
        private String editDialogTitle;

        public TableGroupComposite(String groupLabel, String propertyLabel, Composite parent, String addDialogTitle, String editDialogTitle) {
            this.groupLabel = groupLabel;
            this.propertyLabel = propertyLabel;
            this.parent = parent;
            this.addDialogTitle = addDialogTitle;
            this.editDialogTitle = editDialogTitle;
        }

        public Table getTable() {
            return this.table;
        }

        public Button getAddButton() {
            return this.addButton;
        }

        public void createControls() {
            Group tableGroup = SWTFactory.createGroup((Composite)this.parent, (String)this.groupLabel, (int)2, (int)1, (int)768);
            TableViewer tableViewer = new TableViewer((Composite)tableGroup, 67586);
            tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    TableItem[] selection = TableGroupComposite.this.table.getSelection();
                    if (selection.length == 1) {
                        TableGroupComposite.this.editProperty(TableGroupComposite.this.editDialogTitle, selection[0].getText(0), selection[0].getText(1));
                    }
                }
            });
            tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TableItem[] items = TableGroupComposite.this.table.getSelection();
                    if (items == null || items.length == 0) {
                        TableGroupComposite.this.editButton.setEnabled(false);
                        TableGroupComposite.this.removeButton.setEnabled(false);
                    } else if (items.length == 1) {
                        TableGroupComposite.this.editButton.setEnabled(true);
                        TableGroupComposite.this.removeButton.setEnabled(true);
                    } else {
                        TableGroupComposite.this.editButton.setEnabled(false);
                        TableGroupComposite.this.removeButton.setEnabled(true);
                    }
                }
            });
            this.table = tableViewer.getTable();
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 50;
            this.table.setLayoutData((Object)data);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            TableColumn propColumn = new TableColumn(this.table, 0, 0);
            propColumn.setWidth(300);
            Composite buttonComposite = new Composite((Composite)tableGroup, 0);
            FillLayout fillLayout = new FillLayout(512);
            fillLayout.spacing = 2;
            buttonComposite.setLayout((Layout)fillLayout);
            this.addButton = new Button(buttonComposite, 0);
            this.addButton.setText(Messages.BowerLaunchConfigurationTab_buttonAdd);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableGroupComposite.this.addProperty(TableGroupComposite.this.addDialogTitle);
                }
            });
            this.editButton = new Button(buttonComposite, 0);
            this.editButton.setText(Messages.BowerLaunchConfigurationTab_buttonEdit);
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] selection;
                    if (TableGroupComposite.this.table.getSelectionCount() > 0 && (selection = TableGroupComposite.this.table.getSelection()).length == 1) {
                        TableGroupComposite.this.editProperty(TableGroupComposite.this.editDialogTitle, selection[0].getText(0), selection[0].getText(1));
                    }
                }
            });
            this.editButton.setEnabled(false);
            this.removeButton = new Button(buttonComposite, 0);
            this.removeButton.setText(Messages.BowerLaunchConfigurationTab_buttonRemove);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (TableGroupComposite.this.table.getSelectionCount() > 0) {
                        TableGroupComposite.this.table.remove(TableGroupComposite.this.table.getSelectionIndices());
                    }
                }
            });
            this.removeButton.setEnabled(false);
        }

        private void addProperty(String title) {
            PopUpPropertyDialog dialog = new PopUpPropertyDialog(BowerInitPage.this.getShell(), title, this.propertyLabel, "", null);
            if (dialog.open() == 0) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, dialog.getName());
            }
        }

        private void editProperty(String title, String name, String value) {
            PopUpPropertyDialog dialog = new PopUpPropertyDialog(BowerInitPage.this.getShell(), title, this.propertyLabel, name, null);
            if (dialog.open() == 0) {
                TableItem[] item = this.table.getSelection();
                item[0].setText(0, dialog.getName());
            }
        }
    }
}

