/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.util;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.wizards.XSDSelectIncludeFileWizard;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.w3c.dom.Element;

public class XSDDirectivesSchemaLocationUpdater {
    public static void updateSchemaLocation(XSDSchema xsdSchema, Object selection, boolean isInclude) {
        ResourceFilter filter;
        Shell shell = Display.getCurrent().getActiveShell();
        IFile currentIFile = null;
        IEditorInput editorInput = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            currentIFile = ((IFileEditorInput)editorInput).getFile();
            filter = new ResourceFilter(new String[]{".xsd"}, new IFile[]{currentIFile}, null);
        } else {
            filter = new ResourceFilter(new String[]{".xsd"}, null, null);
        }
        XSDSelectIncludeFileWizard fileSelectWizard = new XSDSelectIncludeFileWizard(xsdSchema, isInclude, XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_SCHEMA"), XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_DESC"), (ViewerFilter)filter, (IStructuredSelection)new StructuredSelection(selection));
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)fileSelectWizard);
        wizardDialog.create();
        wizardDialog.setBlockOnOpen(true);
        int result = wizardDialog.open();
        if (result == 0) {
            IFile selectedIFile = fileSelectWizard.getResultFile();
            String schemaFileString = selectedIFile != null && currentIFile != null ? URIHelper.getRelativeURI((IPath)selectedIFile.getLocation(), (IPath)currentIFile.getLocation()) : (selectedIFile != null && currentIFile == null ? selectedIFile.getLocationURI().toString() : fileSelectWizard.getURL());
            String attributeSchemaLocation = "schemaLocation";
            if (selection instanceof XSDImport) {
                XSDImport xsdImport = (XSDImport)selection;
                xsdImport.getElement().setAttribute(attributeSchemaLocation, schemaFileString);
                String namespace = fileSelectWizard.getNamespace();
                if (namespace == null) {
                    namespace = "";
                }
                XSDSchema externalSchema = fileSelectWizard.getExternalSchema();
                Map map = xsdSchema.getQNamePrefixToNamespaceMap();
                Element schemaElement = xsdSchema.getElement();
                TypesHelper helper = new TypesHelper(externalSchema);
                String prefix = helper.getPrefix(namespace, false);
                if (map.containsKey(prefix)) {
                    prefix = null;
                }
                if (prefix == null || prefix != null && prefix.length() == 0) {
                    StringBuffer newPrefix = new StringBuffer("pref");
                    int prefixExtension = 1;
                    while (map.containsKey(newPrefix.toString()) && prefixExtension < 100) {
                        newPrefix = new StringBuffer("pref" + String.valueOf(prefixExtension));
                        ++prefixExtension;
                    }
                    prefix = newPrefix.toString();
                }
                String attributeNamespace = "namespace";
                if (namespace.length() > 0) {
                    if (map.containsValue(namespace)) {
                        TypesHelper typesHelper = new TypesHelper(xsdSchema);
                        prefix = typesHelper.getPrefix(namespace, false);
                    } else {
                        schemaElement.setAttribute("xmlns:" + prefix, namespace);
                    }
                    xsdImport.getElement().setAttribute(attributeNamespace, namespace);
                }
                if (selection instanceof XSDImportImpl) {
                    XSDImportImpl xsdImportImpl = (XSDImportImpl)selection;
                    xsdImportImpl.importSchema();
                }
            } else if (selection instanceof XSDInclude) {
                XSDInclude xsdInclude = (XSDInclude)selection;
                xsdInclude.getElement().setAttribute(attributeSchemaLocation, schemaFileString);
            } else if (selection instanceof XSDRedefine) {
                XSDRedefine xsdRedefine = (XSDRedefine)selection;
                xsdRedefine.getElement().setAttribute(attributeSchemaLocation, schemaFileString);
            }
        }
    }
}

