/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import uk.co.spudsoft.birt.emitters.excel.AreaBorders;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableContainer;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableHandler;

public class AbstractRealListHandler
extends AbstractHandler
implements NestedTableContainer {
    protected int startRow;
    protected int startCol;
    private IListGroupContent currentGroup;
    private IListBandContent currentBand;
    private AreaBorders borderDefn;
    private List<NestedTableHandler> nestedTables;

    public AbstractRealListHandler(Logger log, IHandler parent, IListContent list) {
        super(log, parent, (IContent)list);
    }

    @Override
    public void addNestedTable(NestedTableHandler nestedTableHandler) {
        if (this.nestedTables == null) {
            this.nestedTables = new ArrayList<NestedTableHandler>();
        }
        this.log.debug("Adding nested table: ", nestedTableHandler);
        this.nestedTables.add(nestedTableHandler);
    }

    @Override
    public boolean rowHasNestedTable(int rowNum) {
        if (this.nestedTables != null) {
            for (NestedTableHandler nestedTableHandler : this.nestedTables) {
                if (!nestedTableHandler.includesRow(rowNum)) continue;
                this.log.debug("Row ", rowNum, " has nested table ", nestedTableHandler);
                return true;
            }
        }
        this.log.debug("Row ", rowNum, " has no nested tables");
        return false;
    }

    @Override
    public int extendRowBy(int rowNum) {
        int offset = 1;
        if (this.nestedTables != null) {
            for (NestedTableHandler nestedTableHandler : this.nestedTables) {
                int nestedTablesOffset = nestedTableHandler.extendParentsRowBy(rowNum);
                if (nestedTablesOffset <= offset) continue;
                this.log.debug("Row ", rowNum, " is extended by ", nestedTablesOffset, " thanks to ", nestedTableHandler);
                offset = nestedTablesOffset;
            }
        }
        return offset;
    }

    @Override
    public void startList(HandlerState state, IListContent list) throws BirtException {
        this.startRow = state.rowNum;
        this.startCol = state.colNum;
        this.log.debug("List started at [", this.startRow, ",", this.startCol, "]");
    }

    @Override
    public void endList(HandlerState state, IListContent list) throws BirtException {
        state.setHandler(this.parent);
        int endRow = state.rowNum - 1;
        int colStart = 0;
        int colEnd = 0;
        int row = this.startRow;
        while (row < endRow) {
            int lastColInRow;
            if (state.currentSheet.getRow(row) != null && (lastColInRow = state.currentSheet.getRow(row).getLastCellNum() - 1) > colEnd) {
                colEnd = lastColInRow;
            }
            ++row;
        }
        state.getSmu().applyBordersToArea(state.getSm(), state.currentSheet, colStart, colEnd, this.startRow, endRow, new BirtStyle((IContent)list));
        if (this.borderDefn != null) {
            state.removeBorderOverload(this.borderDefn);
        }
        if (list.getBookmark() != null) {
            this.createName(state, AbstractRealListHandler.prepareName(list.getBookmark()), this.startRow, 0, state.rowNum - 1, 0);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)list, "ExcelEmitter.DisplayFormulas", false)) {
            state.currentSheet.setDisplayFormulas(true);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)list, "ExcelEmitter.DisplayGridlines", true)) {
            state.currentSheet.setDisplayGridlines(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)list, "ExcelEmitter.DisplayRowColHeadings", true)) {
            state.currentSheet.setDisplayRowColHeadings(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)list, "ExcelEmitter.DisplayZeros", true)) {
            state.currentSheet.setDisplayZeros(false);
        }
    }

    @Override
    public void startListBand(HandlerState state, IListBandContent band) throws BirtException {
        this.currentBand = band;
        state.colNum = this.startCol;
        this.log.debug("startListBand with startCol = ", this.startCol);
    }

    @Override
    public void endListBand(HandlerState state, IListBandContent band) throws BirtException {
        boolean rowHasNestedTable = this.rowHasNestedTable(state.rowNum);
        if (rowHasNestedTable) {
            state.rowNum += this.extendRowBy(state.rowNum);
        }
        state.colNum = this.startCol;
        this.currentBand = null;
    }

    @Override
    public void startListGroup(HandlerState state, IListGroupContent group) throws BirtException {
        this.currentGroup = group;
    }

    @Override
    public void endListGroup(HandlerState state, IListGroupContent group) throws BirtException {
        this.currentGroup = null;
    }
}

