/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.client.impl;

import com.google.gwt.junit.client.TimeoutException;
import com.google.gwt.junit.client.impl.JUnitResult;
import com.google.gwt.user.client.rpc.RemoteService;
import java.io.Serializable;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JUnitHost
extends RemoteService {
    public InitialResponse getTestBlock(int var1, ClientInfo var2) throws TimeoutException;

    public TestBlock reportResultsAndGetTestBlock(HashMap<TestInfo, JUnitResult> var1, int var2, ClientInfo var3) throws TimeoutException;

    public static class ClientInfo
    implements Serializable {
        private int sessionId;
        private String userAgent;

        public ClientInfo(int sessionId, String userAgent) {
            this.sessionId = sessionId;
            this.userAgent = userAgent;
        }

        ClientInfo() {
        }

        public int getSessionId() {
            return this.sessionId;
        }

        public String getUserAgent() {
            return this.userAgent;
        }
    }

    public static class InitialResponse
    implements Serializable {
        private int sessionId;
        private TestBlock testBlock;

        public InitialResponse(int sessionId, TestBlock testBlock) {
            this.sessionId = sessionId;
            this.testBlock = testBlock;
        }

        InitialResponse() {
        }

        public int getSessionId() {
            return this.sessionId;
        }

        public TestBlock getTestBlock() {
            return this.testBlock;
        }
    }

    public static class TestBlock
    implements Serializable {
        private int index;
        private TestInfo[] tests;

        public TestBlock(TestInfo[] tests, int index) {
            this.tests = tests;
            this.index = index;
        }

        TestBlock() {
        }

        public int getIndex() {
            return this.index;
        }

        public TestInfo[] getTests() {
            return this.tests;
        }
    }

    public static class TestInfo
    implements Serializable {
        private String testClass;
        private String testMethod;
        private String testModule;

        public TestInfo(String testModule, String testClass, String testMethod) {
            this.testModule = testModule;
            this.testClass = testClass;
            this.testMethod = testMethod;
        }

        TestInfo() {
        }

        public boolean equals(Object o) {
            if (o instanceof TestInfo) {
                TestInfo other = (TestInfo)o;
                return this.getTestModule().equals(other.getTestModule()) && this.getTestClass().equals(other.getTestClass()) && this.getTestMethod().equals(other.getTestMethod());
            }
            return false;
        }

        public String getTestClass() {
            return this.testClass;
        }

        public String getTestMethod() {
            return this.testMethod;
        }

        public String getTestModule() {
            return this.testModule;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.testModule + ":" + this.testClass + "." + this.testMethod;
        }
    }
}

