/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.ImagePushFailedException;
import com.spotify.docker.client.messages.ProgressMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPushHandler
implements ProgressHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingPushHandler.class);
    private final String image;

    public LoggingPushHandler(String image) {
        this.image = image;
    }

    @Override
    public void progress(ProgressMessage message) throws DockerException {
        if (message.error() != null) {
            throw new ImagePushFailedException(this.image, message.toString());
        }
        log.info("push {}: {}", (Object)this.image, (Object)message);
    }
}

