/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.dap;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.debug.dap.Activator;
import org.eclipse.cdt.debug.dap.CDTDebugProtocol;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AbstractDisassemblyBackend;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.ErrorPosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyBackend;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.DSPStackFrame;
import org.eclipse.lsp4j.debug.DisassembleArguments;
import org.eclipse.lsp4j.debug.DisassembleResponse;
import org.eclipse.lsp4j.debug.DisassembledInstruction;

public class DapDisassemblyBackend
extends AbstractDisassemblyBackend {
    private DSPStackFrame dspStackFrame;

    public boolean supportsDebugContext(IAdaptable context) {
        return context instanceof DSPStackFrame;
    }

    public boolean hasDebugContext() {
        return this.dspStackFrame != null;
    }

    public IDisassemblyBackend.SetDebugContextResult setDebugContext(IAdaptable context) {
        assert (context instanceof DSPStackFrame);
        IDisassemblyBackend.SetDebugContextResult setDebugContextResult = new IDisassemblyBackend.SetDebugContextResult();
        if (context instanceof DSPStackFrame) {
            DSPStackFrame newDspStackFrame = (DSPStackFrame)context;
            setDebugContextResult.contextChanged = !newDspStackFrame.equals(this.dspStackFrame);
            this.dspStackFrame = newDspStackFrame;
            setDebugContextResult.sessionId = "";
            if (!setDebugContextResult.contextChanged) {
                this.fCallback.gotoFrameIfActive(this.dspStackFrame.getDepth());
            }
        } else {
            setDebugContextResult.contextChanged = true;
            setDebugContextResult.sessionId = null;
        }
        return setDebugContextResult;
    }

    public void clearDebugContext() {
        this.dspStackFrame = null;
    }

    public void retrieveFrameAddress(int frame) {
        this.fCallback.setUpdatePending(false);
        this.fCallback.asyncExec(() -> {
            int addressBits = this.dspStackFrame.getFrameInstructionAddressBits();
            BigInteger address = this.dspStackFrame.getFrameInstructionAddress();
            if (addressBits != this.fCallback.getAddressSize()) {
                this.fCallback.addressSizeChanged(addressBits);
            }
            if (frame == 0) {
                this.fCallback.updatePC(address);
            } else {
                this.fCallback.gotoFrame(frame, address);
            }
        });
    }

    public int getFrameLevel() {
        return this.dspStackFrame.getDepth();
    }

    public boolean isSuspended() {
        return this.dspStackFrame.getDebugTarget().isSuspended();
    }

    public boolean hasFrameContext() {
        return false;
    }

    public String getFrameFile() {
        return null;
    }

    public int getFrameLine() {
        return 0;
    }

    public void retrieveDisassembly(BigInteger startAddress, BigInteger endAddress, String file, int lineNumber, int lines, boolean mixed, boolean showSymbols, boolean showDisassembly, int linesHint) {
        CDTDebugProtocol.CDTDisassembleArguments args = new CDTDebugProtocol.CDTDisassembleArguments();
        args.setMemoryReference("0x" + startAddress.toString(16));
        args.setInstructionCount(Long.valueOf(lines));
        args.setEndMemoryReference("1+0x" + endAddress.toString(16));
        CompletableFuture future = this.dspStackFrame.getDebugProtocolServer().disassemble((DisassembleArguments)args);
        future.thenAcceptAsync(res -> this.fCallback.asyncExec(() -> this.insertDisassembly(startAddress, endAddress, (DisassembleResponse)res, showSymbols, showDisassembly)));
    }

    /*
     * Unable to fully structure code
     */
    private void insertDisassembly(BigInteger startAddress, BigInteger endAddress, DisassembleResponse response, boolean showSymbols, boolean showDisassembly) {
        block36: {
            if (!this.fCallback.hasViewer() || this.dspStackFrame == null) {
                if (DisassemblyUtils.DEBUG) {
                    System.out.println(MessageFormat.format("insertDisassembly ignored at {0} : missing context: [dspStackFrame={1}]", new Object[]{DisassemblyUtils.getAddressText((BigInteger)startAddress), this.dspStackFrame}));
                }
                if (this.dspStackFrame == null) {
                    this.fCallback.setUpdatePending(false);
                }
                return;
            }
            if (DisassemblyUtils.DEBUG) {
                System.out.println("insertDisassembly " + DisassemblyUtils.getAddressText((BigInteger)startAddress));
            }
            updatePending = this.fCallback.getUpdatePending();
            if (!DapDisassemblyBackend.$assertionsDisabled && !updatePending) {
                throw new AssertionError();
            }
            if (!updatePending) {
                return;
            }
            insertedAnyAddress = false;
            try {
                this.fCallback.lockScroller();
                p = null;
                location = null;
                instructions = response.getInstructions();
                i = 0;
                while (i < instructions.length) {
                    block37: {
                        instruction = instructions[i];
                        if (instruction.getLocation() != null) {
                            location = instruction.getLocation();
                        }
                        if (!DapDisassemblyBackend.$assertionsDisabled && location == null) {
                            throw new AssertionError();
                        }
                        file = null;
                        if (location != null) {
                            file = location.getPath();
                        }
                        lineNumber = ((line = instruction.getLine()) == null ? 0 : line.intValue()) - 1;
                        address = this.getAddress(instruction);
                        if (startAddress == null) {
                            startAddress = address;
                            this.fCallback.setGotoAddressPending(address);
                        }
                        if (p == null || !p.containsAddress(address)) {
                            p = this.fCallback.getPositionOfAddress(address);
                        }
                        if (!(p instanceof ErrorPosition) || !p.fValid) break block37;
                        p.fValid = false;
                        this.fCallback.getDocument().addInvalidAddressRange(p);
                        ** GOTO lbl53
                    }
                    if (p == null || address.compareTo(endAddress) > 0) {
                        if (DisassemblyUtils.DEBUG) {
                            System.out.println("Excess disassembly lines at " + DisassemblyUtils.getAddressText((BigInteger)address));
                        }
                        return;
                    }
                    try {
                        block39: {
                            block38: {
                                if (!p.fValid) break block38;
                                if (DisassemblyUtils.DEBUG) {
                                    System.out.println("Excess disassembly lines at " + DisassemblyUtils.getAddressText((BigInteger)address));
                                }
                                if (p.fAddressOffset.equals(address)) break block39;
                                p.fValid = false;
                                this.fCallback.getDocument().addInvalidAddressRange(p);
                            }
                            hasSource = false;
                            if (file != null && lineNumber >= 0) {
                                p = this.fCallback.insertSource(p, address, file, lineNumber);
                                v0 = hasSource = this.fCallback.getStorageForFile(file) != null;
                            }
                            if ((symbol = instruction.getSymbol()) != null) {
                                split = symbol.split("\\+", 2);
                                functionName = split[0];
                                if (split.length > 1) {
                                    try {
                                        offset = Integer.parseInt(split[1]);
                                    }
                                    catch (NumberFormatException e) {
                                        offset = 0;
                                    }
                                } else {
                                    offset = 0;
                                }
                            } else {
                                functionName = null;
                                offset = 0;
                            }
                            if (functionName != null && !functionName.isEmpty() && offset == 0) {
                                p = this.fCallback.getDocument().insertLabel(p, address, functionName, showSymbols != false && (hasSource == false || showDisassembly != false));
                            }
                            instrLength = null;
                            if (i >= instructions.length - 1) break block36;
                            instrLength = this.getAddress(instructions[i + 1]).subtract(address).abs();
                            funcOffset = instruction.getSymbol();
                            if (funcOffset == null) {
                                funcOffset = "";
                            }
                            opCodes = null;
                            if (instruction.getInstructionBytes() != null) {
                                opCodes = new BigInteger(instruction.getInstructionBytes().replace(" ", ""), 16);
                            }
                            if ((p = this.fCallback.getDocument().insertDisassemblyLine(p, address, instrLength.intValue(), funcOffset, opCodes, instruction.getInstruction(), file, lineNumber)) == null) {
                                break;
                            }
                            insertedAnyAddress = true;
                        }
                        ++i;
                        continue;
                    }
                    catch (BadLocationException e) {
                        DisassemblyUtils.internalError((Throwable)e);
                    }
                    break;
                }
            }
            finally {
                this.fCallback.setUpdatePending(false);
                if (insertedAnyAddress) {
                    this.fCallback.updateInvalidSource();
                    this.fCallback.unlockScroller();
                    this.fCallback.doPending();
                    this.fCallback.updateVisibleArea();
                } else {
                    this.fCallback.unlockScroller();
                }
            }
        }
    }

    private BigInteger getAddress(DisassembledInstruction instruction) {
        if (instruction.getAddress().startsWith("0x")) {
            return new BigInteger(instruction.getAddress().substring(2), 16);
        }
        return new BigInteger(instruction.getAddress(), 10);
    }

    public Object insertSource(Position pos, BigInteger address, String file, int lineNumber) {
        ISourceLookupDirector lookupDirector = this.getSourceLookupDirector();
        return lookupDirector.getSourceElement((Object)file);
    }

    private ISourceLookupDirector getSourceLookupDirector() {
        if (this.dspStackFrame == null) {
            return null;
        }
        DSPDebugTarget debugTarget = this.dspStackFrame.getDebugTarget();
        if (debugTarget == null) {
            return null;
        }
        ILaunch launch = debugTarget.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator sourceLocator = launch.getSourceLocator();
        if (sourceLocator instanceof ISourceLookupDirector) {
            ISourceLookupDirector lookupDirector = (ISourceLookupDirector)sourceLocator;
            return lookupDirector;
        }
        return null;
    }

    public void gotoSymbol(String symbol) {
        String.class.getClass();
    }

    public void retrieveDisassembly(String file, int lines, BigInteger endAddress, boolean mixed, boolean showSymbols, boolean showDisassembly) {
        String.class.getClass();
    }

    public String evaluateExpression(String expression) {
        CompletableFuture evaluate = this.dspStackFrame.evaluate(expression);
        try {
            IVariable iVariable = (IVariable)evaluate.get();
            return iVariable.getValue().getValueString();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (NumberFormatException | ExecutionException | DebugException e) {
            return null;
        }
    }

    public void dispose() {
        String.class.getClass();
    }

    protected void handleError(IStatus status) {
        Activator.log(status);
    }

    public BigInteger evaluateAddressExpression(String expression, boolean suppressError) {
        CompletableFuture evaluate = this.dspStackFrame.evaluate(expression);
        try {
            IVariable variable = (IVariable)evaluate.get();
            return DisassemblyUtils.decodeAddress((String)variable.getValue().getValueString());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (NumberFormatException | ExecutionException | DebugException e) {
            if (!suppressError) {
                this.handleError((IStatus)new Status(4, "org.eclipse.cdt.debug.dap", 0, "Expression does not evaluate to an address (" + e.getMessage() + ")", null));
            }
            return null;
        }
    }
}

