/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.manipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.manipulation.IRefactoringEngine;
import org.eclipse.dltk.internal.core.manipulation.ScriptManipulationPlugin;

public class RefactoringEngineManager {
    private static RefactoringEngineManager instance;

    protected IRefactoringEngine doFindRefactoringEngine(String natureId) throws CoreException {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.dltk.core.manipulation.refactoringEngine");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] ce = ext.getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                Object obj;
                if (natureId.equals(ce[j].getAttribute("natureID")) && (obj = ce[j].createExecutableExtension("class")) instanceof IRefactoringEngine) {
                    return (IRefactoringEngine)obj;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static synchronized RefactoringEngineManager getInstance() {
        if (instance == null) {
            instance = new RefactoringEngineManager();
        }
        return instance;
    }

    public IRefactoringEngine findRefactoringEngine(IModelElement element) {
        try {
            return this.doFindRefactoringEngine(DLTKLanguageManager.getLanguageToolkit((IModelElement)element).getNatureId());
        }
        catch (CoreException e) {
            ScriptManipulationPlugin.log(e);
            return null;
        }
    }
}

