/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitUI;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesTree;
import org.eclipse.egit.ui.internal.stash.StashCreateUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CleanupUncomittedChangesDialog
extends MessageDialog {
    private static final Image INFO = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    private final Repository repository;
    private List<String> fileList;
    private boolean shouldContinue = false;
    private final boolean needResult;

    public CleanupUncomittedChangesDialog(Shell shell, String dialogTitle, String dialogMessage, Repository repository, List<String> fileList) {
        this(shell, dialogTitle, dialogMessage, repository, fileList, true);
    }

    public CleanupUncomittedChangesDialog(Shell shell, String title, String message, Repository repository, List<String> fileList, boolean needResult) {
        super(shell, title, INFO, message, 2, new String[0], -1);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.fileList = fileList;
        this.needResult = needResult;
    }

    protected Control createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        new NonDeletedFilesTree(main, this.repository, this.fileList);
        CleanupUncomittedChangesDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 10: {
                if (this.needResult) {
                    CommitUI commitUI = new CommitUI(this.getShell(), this.repository, new IResource[0], true);
                    this.shouldContinue = commitUI.commit();
                    break;
                }
                CommonUtils.runCommand("org.eclipse.egit.ui.team.Commit", (IStructuredSelection)new StructuredSelection((Object)this.repository));
                break;
            }
            case 7: {
                DiscardChangesOperation operation = new DiscardChangesOperation(this.repository, this.fileList, "HEAD");
                JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.DiscardChangesAction_discardChanges, (Object)JobFamilies.DISCARD_CHANGES);
                this.shouldContinue = true;
                break;
            }
            case 5: {
                StashCreateUI stashCreateUI = new StashCreateUI(this.repository);
                this.shouldContinue = stashCreateUI.createStash(this.getShell());
                break;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 10, UIText.BranchResultDialog_buttonCommit, false);
        this.createButton(parent, 5, UIText.BranchResultDialog_buttonStash, false);
        this.createButton(parent, 7, UIText.BranchResultDialog_buttonDiscardChanges, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public boolean shouldContinue() {
        return this.shouldContinue;
    }
}

