/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.RealmUtil;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.impl.SecurityItemImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.security.IPasswordCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryImpl
extends SecurityItemImpl
implements Directory {
    protected DirectoryImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SecurityPackage.Literals.DIRECTORY;
    }

    @Override
    public EList<SecurityItem> getItems() {
        return (EList)this.eGet((EStructuralFeature)SecurityPackage.Literals.DIRECTORY__ITEMS, true);
    }

    @Override
    public String getName() {
        return (String)this.eGet((EStructuralFeature)SecurityPackage.Literals.DIRECTORY__NAME, true);
    }

    @Override
    public void setName(String newName) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.DIRECTORY__NAME, newName);
    }

    @Override
    public Role getRole(String id) {
        return RealmUtil.findRole(this.getItems(), id);
    }

    @Override
    public Group getGroup(String id) {
        return RealmUtil.findGroup(this.getItems(), id);
    }

    @Override
    public User getUser(String id) {
        return RealmUtil.findUser(this.getItems(), id);
    }

    @Override
    public Role addRole(String id) {
        Role role = SecurityFactory.eINSTANCE.createRole(id);
        this.getItems().add((Object)role);
        return role;
    }

    @Override
    public Group addGroup(String id) {
        Group group = SecurityFactory.eINSTANCE.createGroup(id);
        this.getItems().add((Object)group);
        return group;
    }

    @Override
    public User addUser(String id) {
        User user = SecurityFactory.eINSTANCE.createUser(id);
        this.getItems().add((Object)user);
        return user;
    }

    @Override
    public User addUser(String id, String password) {
        User user = SecurityFactory.eINSTANCE.createUser(id, password);
        this.getItems().add((Object)user);
        return user;
    }

    @Override
    public User addUser(IPasswordCredentials credentials) {
        return this.addUser(credentials.getUserID(), new String(credentials.getPassword()));
    }

    @Override
    public User setPassword(String id, String password) {
        return this.getRealm().setPassword(id, password);
    }

    @Override
    public Role removeRole(String id) {
        return RealmUtil.removeRole(this.getItems(), id);
    }

    @Override
    public Group removeGroup(String id) {
        return RealmUtil.removeGroup(this.getItems(), id);
    }

    @Override
    public User removeUser(String id) {
        return RealmUtil.removeUser(this.getItems(), id);
    }
}

