/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.security.PermissionUtil;
import org.eclipse.emf.cdo.internal.security.ViewCreator;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.PatternStyle;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.cdo.security.impl.PermissionImpl;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.ObjectWriteAccessHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.spi.cdo.InternalCDOSessionInvalidationEvent;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.ArrayUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IAuthenticator2;
import org.eclipse.net4j.util.security.IPasswordCredentials;

public class SecurityManager
extends Lifecycle
implements InternalSecurityManager {
    private static final Map<IRepository, InternalSecurityManager> SECURITY_MANAGERS = new HashMap<IRepository, InternalSecurityManager>();
    private static final SecurityFactory SF = SecurityFactory.eINSTANCE;
    private final IListener repositoryListener = new LifecycleEventAdapter(){

        protected void onActivated(ILifecycle lifecycle) {
            SecurityManager.this.init();
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            SECURITY_MANAGERS.remove(SecurityManager.this.getRepository());
            SecurityManager.this.deactivate();
        }
    };
    private final IListener sessionManagerListener = new ContainerEventAdapter<ISession>(){

        protected void onRemoved(IContainer<ISession> container, ISession session) {
            SecurityManager.this.removeUserInfo(session);
        }
    };
    private final IListener systemListener = new IListener(){
        private boolean clearUserInfos;

        public void notifyEvent(IEvent event) {
            if (event instanceof InternalCDOSessionInvalidationEvent) {
                InternalCDOSessionInvalidationEvent e = (InternalCDOSessionInvalidationEvent)event;
                if (e.getSecurityImpact() == 2) {
                    this.clearUserInfos = true;
                }
            } else if (event instanceof CDOViewInvalidationEvent && this.clearUserInfos) {
                SecurityManager.this.clearUserInfos();
                this.clearUserInfos = false;
            }
        }
    };
    private final IAuthenticator authenticator = new Authenticator();
    private final IPermissionManager permissionManager = new PermissionManager();
    private final IRepository.WriteAccessHandler writeAccessHandler = new WriteAccessHandler();
    private final String realmPath;
    private final IManagedContainer container;
    private final Map<ISession, UserInfo> userInfos = new HashMap<ISession, UserInfo>();
    private final HashBag<PermissionImpl> permissionBag = new HashBag();
    private final Object commitHandlerLock = new Object();
    private InternalSecurityManager.CommitHandler[] commitHandlers = new InternalSecurityManager.CommitHandler[0];
    private InternalSecurityManager.CommitHandler2[] commitHandlers2 = new InternalSecurityManager.CommitHandler2[0];
    private PermissionImpl[] permissionArray = new PermissionImpl[0];
    private InternalRepository repository;
    private IAcceptor acceptor;
    private IConnector connector;
    private CDONet4jSession systemSession;
    private CDOView systemView;
    private Realm realm;
    private CDOID realmID;
    private long lastRealmModification = 0L;

    public SecurityManager(String realmPath, IManagedContainer container) {
        this.realmPath = realmPath;
        this.container = container;
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    public final String getRealmPath() {
        return this.realmPath;
    }

    public final IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(InternalRepository repository) {
        this.repository = repository;
        if (this.isActive()) {
            this.init();
        }
    }

    public Realm getRealm() {
        return this.realm;
    }

    public Role getRole(String id) {
        Role item = this.realm.getRole(id);
        if (item == null) {
            throw new SecurityException("Role " + id + " not found");
        }
        return item;
    }

    public Group getGroup(String id) {
        Group item = this.realm.getGroup(id);
        if (item == null) {
            throw new SecurityException("Group " + id + " not found");
        }
        return item;
    }

    public User getUser(String id) {
        User item = this.realm.getUser(id);
        if (item == null) {
            throw new SecurityException("User " + id + " not found");
        }
        return item;
    }

    public Role addRole(final String id) {
        final Role[] result = new Role[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.addRole(id);
            }
        });
        return result[0];
    }

    public Group addGroup(final String id) {
        final Group[] result = new Group[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.addGroup(id);
            }
        });
        return result[0];
    }

    public User addUser(final String id) {
        final User[] result = new User[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.addUser(id);
            }
        });
        return result[0];
    }

    public User addUser(final String id, final String password) {
        final User[] result = new User[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                UserPassword userPassword = SF.createUserPassword();
                userPassword.setEncrypted(new String(password));
                result[0] = realm.addUser(id);
                result[0].setPassword(userPassword);
            }
        });
        return result[0];
    }

    public User addUser(IPasswordCredentials credentials) {
        return this.addUser(credentials.getUserID(), new String(credentials.getPassword()));
    }

    public User setPassword(final String id, final String password) {
        final User[] result = new User[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.setPassword(id, password);
            }
        });
        return result[0];
    }

    public Role removeRole(final String id) {
        final Role[] result = new Role[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.removeRole(id);
            }
        });
        return result[0];
    }

    public Group removeGroup(final String id) {
        final Group[] result = new Group[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.removeGroup(id);
            }
        });
        return result[0];
    }

    public User removeUser(final String id) {
        final User[] result = new User[1];
        this.modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                result[0] = realm.removeUser(id);
            }
        });
        return result[0];
    }

    public void read(ISecurityManager.RealmOperation operation) {
        this.checkReady();
        operation.execute(this.realm);
    }

    public void modify(ISecurityManager.RealmOperation operation) {
        this.modify(operation, false);
    }

    public void modify(ISecurityManager.RealmOperation operation, boolean waitUntilReadable) {
        this.modifyWithInfo(operation, waitUntilReadable);
    }

    public CDOCommitInfo modifyWithInfo(ISecurityManager.RealmOperation operation, boolean waitUntilReadable) {
        this.checkReady();
        CDOTransaction transaction = this.systemSession.openTransaction();
        try {
            Realm transactionRealm = (Realm)transaction.getObject((EObject)this.realm);
            operation.execute(transactionRealm);
            CDOCommitInfo info = transaction.commit();
            if (waitUntilReadable && !this.systemView.waitForUpdate(info.getTimeStamp(), 10000L)) {
                throw new TimeoutRuntimeException();
            }
            CDOCommitInfo cDOCommitInfo = info;
            return cDOCommitInfo;
        }
        catch (CommitException ex) {
            throw WrappedException.wrap((Exception)((Object)ex));
        }
        finally {
            transaction.close();
        }
    }

    public InternalSecurityManager.CommitHandler[] getCommitHandlers() {
        return this.commitHandlers;
    }

    public InternalSecurityManager.CommitHandler2[] getCommitHandlers2() {
        return this.commitHandlers2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommitHandler(InternalSecurityManager.CommitHandler handler) {
        this.checkInactive();
        Object object = this.commitHandlerLock;
        synchronized (object) {
            this.commitHandlers = (InternalSecurityManager.CommitHandler[])ArrayUtil.add((Object[])this.commitHandlers, (Object)handler);
            if (handler instanceof InternalSecurityManager.CommitHandler2) {
                this.commitHandlers2 = (InternalSecurityManager.CommitHandler2[])ArrayUtil.add((Object[])this.commitHandlers2, (Object)((InternalSecurityManager.CommitHandler2)handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommitHandler(InternalSecurityManager.CommitHandler handler) {
        this.checkInactive();
        Object object = this.commitHandlerLock;
        synchronized (object) {
            this.commitHandlers = (InternalSecurityManager.CommitHandler[])ArrayUtil.remove((Object[])this.commitHandlers, (Object)handler);
            if (handler instanceof InternalSecurityManager.CommitHandler2) {
                this.commitHandlers2 = (InternalSecurityManager.CommitHandler2[])ArrayUtil.remove((Object[])this.commitHandlers2, (Object)((InternalSecurityManager.CommitHandler2)handler));
            }
        }
    }

    protected void initCommitHandlers(boolean firstTime) {
        InternalSecurityManager.CommitHandler[] handlers = this.getCommitHandlers();
        int i = 0;
        while (i < handlers.length) {
            InternalSecurityManager.CommitHandler handler = handlers[i];
            try {
                handler.init(this, firstTime);
                OM.LOG.info("Security realm handled by " + handler);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++i;
        }
    }

    protected void handleCommit(IStoreAccessor.CommitContext commitContext, User user) {
        InternalSecurityManager.CommitHandler[] handlers = this.getCommitHandlers();
        int i = 0;
        while (i < handlers.length) {
            InternalSecurityManager.CommitHandler handler = handlers[i];
            try {
                handler.handleCommit(this, commitContext, user);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++i;
        }
    }

    protected void handleCommitted(IStoreAccessor.CommitContext commitContext) {
        InternalSecurityManager.CommitHandler2[] handlers = this.getCommitHandlers2();
        int i = 0;
        while (i < handlers.length) {
            InternalSecurityManager.CommitHandler2 handler = handlers[i];
            try {
                handler.handleCommitted(this, commitContext);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++i;
        }
    }

    protected void checkReady() {
        if (this.realm == null || this.systemSession == null) {
            this.checkActive();
        }
    }

    protected void init() {
        CDOResource resource;
        boolean firstTime;
        if (this.realm != null) {
            return;
        }
        if (this.repository == null) {
            return;
        }
        this.repository.addListener(this.repositoryListener);
        if (!LifecycleUtil.isActive((Object)this.repository)) {
            return;
        }
        String repositoryName = this.repository.getName();
        String acceptorName = String.valueOf(repositoryName) + "_security";
        this.acceptor = Net4jUtil.getAcceptor((IManagedContainer)this.container, (String)"jvm", (String)acceptorName);
        this.connector = Net4jUtil.getConnector((IManagedContainer)this.container, (String)"jvm", (String)acceptorName);
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(this.connector);
        config.setRepositoryName(repositoryName);
        config.setUserID("CDO_SYSTEM");
        this.systemSession = config.openNet4jSession();
        this.systemSession.options().setGeneratedPackageEmulationEnabled(true);
        this.systemSession.addListener(this.systemListener);
        CDOTransaction initialTransaction = this.systemSession.openTransaction();
        boolean bl = firstTime = !initialTransaction.hasResource(this.realmPath);
        if (firstTime) {
            this.realm = this.createRealm();
            resource = initialTransaction.createResource(this.realmPath);
            resource.getContents().add((Object)this.realm);
            OM.LOG.info("Security realm created in " + this.realmPath);
        } else {
            resource = initialTransaction.getResource(this.realmPath);
            this.realm = (Realm)resource.getContents().get(0);
            OM.LOG.info("Security realm loaded from " + this.realmPath);
        }
        try {
            try {
                initialTransaction.commit();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            initialTransaction.close();
        }
        this.systemView = this.systemSession.openView();
        this.systemView.addListener(this.systemListener);
        this.realm = (Realm)this.systemView.getObject((EObject)this.realm);
        this.realmID = this.realm.cdoID();
        InternalSessionManager sessionManager = this.repository.getSessionManager();
        sessionManager.setAuthenticator(this.authenticator);
        sessionManager.setPermissionManager(this.permissionManager);
        sessionManager.addListener(this.sessionManagerListener);
        this.repository.addHandler((IRepository.Handler)this.writeAccessHandler);
        SECURITY_MANAGERS.put((IRepository)this.repository, this);
        this.initCommitHandlers(firstTime);
    }

    protected Realm createRealm() {
        Realm realm = SF.createRealm("Security Realm");
        realm.setDefaultRoleDirectory(this.addDirectory(realm, "Roles"));
        realm.setDefaultGroupDirectory(this.addDirectory(realm, "Groups"));
        realm.setDefaultUserDirectory(this.addDirectory(realm, "Users"));
        Role allReaderRole = realm.addRole("All Objects Reader");
        allReaderRole.getPermissions().add((Object)SF.createFilterPermission(Access.READ, new PermissionFilter[]{SF.createResourceFilter(".*", PatternStyle.REGEX)}));
        Role allWriterRole = realm.addRole("All Objects Writer");
        allWriterRole.getPermissions().add((Object)SF.createFilterPermission(Access.WRITE, new PermissionFilter[]{SF.createResourceFilter(".*", PatternStyle.REGEX)}));
        Role treeReaderRole = realm.addRole("Resource Tree Reader");
        treeReaderRole.getPermissions().add((Object)SF.createFilterPermission(Access.READ, new PermissionFilter[]{SF.createPackageFilter((EPackage)EresourcePackage.eINSTANCE)}));
        Role treeWriterRole = realm.addRole("Resource Tree Writer");
        treeWriterRole.getPermissions().add((Object)SF.createFilterPermission(Access.WRITE, new PermissionFilter[]{SF.createPackageFilter((EPackage)EresourcePackage.eINSTANCE)}));
        Role adminRole = realm.addRole("Administration");
        adminRole.getPermissions().add((Object)SF.createFilterPermission(Access.WRITE, new PermissionFilter[]{SF.createResourceFilter(this.realmPath, PatternStyle.EXACT, false)}));
        adminRole.getPermissions().add((Object)SF.createFilterPermission(Access.READ, new PermissionFilter[]{SF.createResourceFilter(this.realmPath, PatternStyle.EXACT, true)}));
        Group adminsGroup = realm.addGroup("Administrators");
        adminsGroup.getRoles().add((Object)adminRole);
        realm.addGroup("Users");
        User adminUser = realm.addUser("Administrator", "0000");
        adminUser.getGroups().add((Object)adminsGroup);
        return realm;
    }

    protected Directory addDirectory(Realm realm, String name) {
        Directory directory = SF.createDirectory(name);
        realm.getItems().add((Object)directory);
        return directory;
    }

    protected CDOPermission convertPermission(Access permission) {
        if (permission != null) {
            switch (permission) {
                case READ: {
                    return CDOPermission.READ;
                }
                case WRITE: {
                    return CDOPermission.WRITE;
                }
            }
        }
        return CDOPermission.NONE;
    }

    protected CDOPermission authorize(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext, ISession session, Access defaultAccess, Permission[] permissions) {
        boolean setUser;
        if (this.lastRealmModification != 0L) {
            if (!this.systemView.waitForUpdate(this.lastRealmModification, 10000L)) {
                throw new TimeoutRuntimeException();
            }
            this.lastRealmModification = 0L;
        }
        boolean bl = setUser = defaultAccess == null;
        if (setUser) {
            UserInfo userInfo = this.getUserInfo(session);
            User user = userInfo.getUser();
            defaultAccess = user.getDefaultAccess();
            permissions = userInfo.getPermissions();
            PermissionUtil.setUser((String)user.getId());
        }
        try {
            CDOPermission result = this.convertPermission(defaultAccess);
            if (result == CDOPermission.WRITE) {
                CDOPermission cDOPermission = result;
                return cDOPermission;
            }
            int i = 0;
            while (i < permissions.length) {
                Permission permission = permissions[i];
                CDOPermission p = this.convertPermission(permission.getAccess());
                if (p.ordinal() > result.ordinal() && permission.isApplicable(revision, revisionProvider, securityContext) && (result = p) == CDOPermission.WRITE) {
                    CDOPermission cDOPermission = result;
                    return cDOPermission;
                }
                ++i;
            }
            CDOPermission cDOPermission = result;
            return cDOPermission;
        }
        finally {
            if (setUser) {
                PermissionUtil.setUser(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserInfo getUserInfo(ISession session) {
        UserInfo userInfo;
        Map<ISession, UserInfo> map = this.userInfos;
        synchronized (map) {
            userInfo = this.userInfos.get(session);
        }
        if (userInfo == null) {
            userInfo = this.addUserInfo(session);
        }
        return userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserInfo addUserInfo(ISession session) {
        String userID = session.getUserID();
        User user = this.getUser(userID);
        UserInfo userInfo = new UserInfo(user);
        Map<ISession, UserInfo> map = this.userInfos;
        synchronized (map) {
            this.userInfos.put(session, userInfo);
            Permission[] permissions = userInfo.getPermissions();
            int i = 0;
            while (i < permissions.length) {
                Permission permission = permissions[i];
                this.permissionBag.add((Object)((PermissionImpl)permission));
                ++i;
            }
            this.permissionArray = (PermissionImpl[])this.permissionBag.toArray((Object[])new PermissionImpl[this.permissionBag.size()]);
        }
        return userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserInfo removeUserInfo(ISession session) {
        UserInfo userInfo;
        Map<ISession, UserInfo> map = this.userInfos;
        synchronized (map) {
            userInfo = this.userInfos.remove(session);
            if (userInfo != null) {
                Permission[] permissions = userInfo.getPermissions();
                int i = 0;
                while (i < permissions.length) {
                    Permission permission = permissions[i];
                    this.permissionBag.remove((Object)permission);
                    ++i;
                }
                this.permissionArray = (PermissionImpl[])this.permissionBag.toArray((Object[])new PermissionImpl[this.permissionBag.size()]);
            }
        }
        return userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearUserInfos() {
        Map<ISession, UserInfo> map = this.userInfos;
        synchronized (map) {
            this.userInfos.clear();
            this.permissionBag.clear();
            this.permissionArray = null;
        }
    }

    protected final boolean isAdministrator(User user) {
        Realm realm = this.getRealm();
        if (realm != null) {
            CDORevision revision = realm.cdoRevision();
            CDOView revisionProvider = realm.cdoView();
            CDOView securityContext = realm.cdoView();
            for (Permission permission : user.getAllPermissions()) {
                if (permission.getAccess() != Access.WRITE || !permission.isApplicable(revision, (CDORevisionProvider)revisionProvider, (CDOBranchPoint)securityContext)) continue;
                return true;
            }
        }
        return false;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.init();
    }

    protected void doDeactivate() throws Exception {
        this.clearUserInfos();
        this.realm = null;
        this.realmID = null;
        this.systemSession.close();
        this.systemSession = null;
        this.systemView = null;
        this.connector.close();
        this.connector = null;
        this.acceptor.close();
        this.acceptor = null;
        super.doDeactivate();
    }

    public static InternalSecurityManager get(IRepository repository) {
        return SECURITY_MANAGERS.get(repository);
    }

    private final class Authenticator
    implements IAuthenticator2 {
        private Authenticator() {
        }

        public void authenticate(String userID, char[] password) throws SecurityException {
            String encrypted;
            User user = SecurityManager.this.getUser(userID);
            UserPassword userPassword = user.getPassword();
            if (userPassword != null && !Arrays.equals(password, (encrypted = userPassword.getEncrypted()) == null ? null : encrypted.toCharArray())) {
                throw new SecurityException("Access denied");
            }
        }

        public void updatePassword(String userID, char[] oldPassword, char[] newPassword) {
            this.authenticate(userID, oldPassword);
            SecurityManager.this.setPassword(userID, new String(newPassword));
        }

        public void resetPassword(String adminID, char[] adminPassword, String userID, char[] newPassword) {
            this.authenticate(adminID, adminPassword);
            User admin = SecurityManager.this.getUser(adminID);
            if (!SecurityManager.this.isAdministrator(admin)) {
                throw new SecurityException("Password reset requires administrator privilege");
            }
            SecurityManager.this.setPassword(userID, new String(newPassword));
        }

        public boolean isAdministrator(String userID) {
            Realm realm = SecurityManager.this.getRealm();
            if (realm != null) {
                User user = realm.getUser(userID);
                return user != null && SecurityManager.this.isAdministrator(user);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PermissionManager
    implements IPermissionManager {
        private PermissionManager() {
        }

        @Deprecated
        public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext, String userID) {
            throw new UnsupportedOperationException();
        }

        public CDOPermission getPermission(CDORevision revision, final CDOBranchPoint securityContext, final ISession session) {
            String userID = session.getUserID();
            if ("CDO_SYSTEM".equals(userID)) {
                return CDOPermission.WRITE;
            }
            if (revision.getEClass() == SecurityPackage.Literals.USER_PASSWORD) {
                return CDOPermission.NONE;
            }
            InternalCDORevisionManager revisionManager = SecurityManager.this.repository.getRevisionManager();
            ManagedRevisionProvider revisionProvider = new ManagedRevisionProvider((CDORevisionManager)revisionManager, securityContext);
            PermissionUtil.initViewCreation((ViewCreator)new ViewCreator(){

                public CDOView createView(CDORevisionProvider revisionProvider) {
                    CDOView view = CDOServerUtil.openView((ISession)session, (CDOBranchPoint)securityContext, (CDORevisionProvider)revisionProvider);
                    view.getSession().options().setGeneratedPackageEmulationEnabled(true);
                    return view;
                }
            });
            try {
                CDOPermission permission;
                CDOPermission cDOPermission = permission = SecurityManager.this.authorize(revision, (CDORevisionProvider)revisionProvider, securityContext, session, null, null);
                return cDOPermission;
            }
            finally {
                PermissionUtil.doneViewCreation();
            }
        }

        public boolean hasAnyRule(ISession session, Set<? extends Object> rules) {
            String userID = session.getUserID();
            if ("CDO_SYSTEM".equals(userID)) {
                return false;
            }
            UserInfo userInfo = SecurityManager.this.getUserInfo(session);
            Permission[] userPermissions = userInfo.getPermissions();
            int i = 0;
            while (i < userPermissions.length) {
                Permission userPermission = userPermissions[i];
                if (rules.contains(userPermission)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RealmValidationHandler
    extends ObjectWriteAccessHandler {
        private final EValidator realmValidator = EValidator.Registry.INSTANCE.getEValidator((EPackage)SecurityPackage.eINSTANCE);

        private RealmValidationHandler() {
        }

        protected void handleTransactionBeforeCommitting(OMMonitor monitor) throws RuntimeException {
            EObject object;
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            Map<Object, Object> context = this.createValidationContext();
            boolean realmChecked = false;
            EObject[] eObjectArray = this.getDirtyObjects();
            int n = eObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = eObjectArray[n2];
                if (object.eClass().getEPackage() == SecurityPackage.eINSTANCE) {
                    this.validate(object, (DiagnosticChain)diagnostic, context);
                    realmChecked |= object instanceof Realm;
                }
                ++n2;
            }
            eObjectArray = this.getNewObjects();
            n = eObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                object = eObjectArray[n2];
                if (object.eClass().getEPackage() == SecurityPackage.eINSTANCE) {
                    this.validate(object, (DiagnosticChain)diagnostic, context);
                }
                ++n2;
            }
            if (!realmChecked) {
                this.validate((EObject)this.getView().getObject(SecurityManager.this.realmID), (DiagnosticChain)diagnostic, context);
            }
        }

        protected Map<Object, Object> createValidationContext() {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            IStoreAccessor.CommitContext commitContext = this.getCommitContext();
            result.put(CDORevisionProvider.class, commitContext);
            result.put(CDOBranchPoint.class, commitContext.getBranchPoint());
            return result;
        }

        protected void validate(EObject object, DiagnosticChain diagnostics, Map<Object, Object> context) {
            this.realmValidator.validate(object, diagnostics, context);
            Diagnostic error = this.getError(diagnostics);
            if (error != null) {
                throw new IRepository.WriteAccessHandler.TransactionValidationException("Security realm integrity violation: " + error.getMessage());
            }
        }

        protected Diagnostic getError(DiagnosticChain diagnostics) {
            Diagnostic diagnostic = (Diagnostic)diagnostics;
            if (diagnostic.getSeverity() >= 4) {
                for (Diagnostic child : diagnostic.getChildren()) {
                    if (child.getSeverity() < 4) continue;
                    return child;
                }
            }
            return null;
        }
    }

    private static final class UserInfo {
        private final User user;
        private final Permission[] permissions;

        public UserInfo(User user) {
            this.user = user;
            EList allPermissions = user.getAllPermissions();
            this.permissions = (Permission[])allPermissions.toArray((Object[])new Permission[allPermissions.size()]);
        }

        public User getUser() {
            return this.user;
        }

        public Permission[] getPermissions() {
            return this.permissions;
        }
    }

    private final class WriteAccessHandler
    implements IRepository.WriteAccessHandler {
        private final IRepository.WriteAccessHandler realmValidationHandler;

        private WriteAccessHandler() {
            this.realmValidationHandler = new RealmValidationHandler();
        }

        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            this.doHandleTransactionBeforeCommitting(transaction, commitContext, monitor);
            if (commitContext.getSecurityImpact() == 2) {
                this.realmValidationHandler.handleTransactionBeforeCommitting(transaction, commitContext, monitor);
            }
        }

        protected void doHandleTransactionBeforeCommitting(ITransaction transaction, final IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            if (transaction.getSessionID() == SecurityManager.this.systemSession.getSessionID()) {
                SecurityManager.this.handleCommit(commitContext, null);
                ((InternalCommitContext)commitContext).setSecurityImpact((byte)2, null);
                return;
            }
            UserInfo userInfo = SecurityManager.this.getUserInfo(transaction.getSession());
            User user = userInfo.getUser();
            SecurityManager.this.handleCommit(commitContext, user);
            PermissionUtil.setUser((String)user.getId());
            PermissionUtil.initViewCreation((ViewCreator)new ViewCreator(){

                public CDOView createView(CDORevisionProvider revisionProvider) {
                    return CDOServerUtil.openView((IStoreAccessor.CommitContext)commitContext);
                }
            });
            try {
                PermissionImpl[] assignedPermissions;
                CDOBranchPoint securityContext = commitContext.getBranchPoint();
                ISession session = transaction.getSession();
                Access userDefaultAccess = user.getDefaultAccess();
                Permission[] userPermissions = userInfo.getPermissions();
                final InternalCDORevision[] revisions = commitContext.getDirtyObjects();
                final InternalCDORevisionDelta[] revisionDeltas = commitContext.getDirtyObjectDeltas();
                int securityImpact = 0;
                int i = 0;
                while (i < revisions.length) {
                    InternalCDORevisionDelta revisionDelta;
                    InternalCDORevision revision = revisions[i];
                    CDOPermission permission = SecurityManager.this.authorize((CDORevision)revision, (CDORevisionProvider)commitContext, securityContext, session, userDefaultAccess, userPermissions);
                    if (permission != CDOPermission.WRITE) {
                        throw new SecurityException("User " + commitContext.getUserID() + " is not allowed to write to " + revision);
                    }
                    if (securityImpact != 2 && CDORevisionUtil.isContained((CDOID)(revisionDelta = revisionDeltas[i]).getID(), (CDOID)SecurityManager.this.realmID, (CDORevisionProvider)transaction)) {
                        securityImpact = 2;
                    }
                    ++i;
                }
                HashSet<PermissionImpl> impactedRules = null;
                if (securityImpact != 2 && (assignedPermissions = SecurityManager.this.permissionArray).length != 0) {
                    PermissionImpl.CommitImpactContext commitImpactContext = new PermissionImpl.CommitImpactContext(){

                        public CDORevision[] getNewObjects() {
                            return commitContext.getNewObjects();
                        }

                        public CDORevision[] getDirtyObjects() {
                            return revisions;
                        }

                        public CDORevisionDelta[] getDirtyObjectDeltas() {
                            return revisionDeltas;
                        }

                        public CDOID[] getDetachedObjects() {
                            return commitContext.getDetachedObjects();
                        }
                    };
                    int i2 = 0;
                    while (i2 < assignedPermissions.length) {
                        PermissionImpl permission = assignedPermissions[i2];
                        if (permission.isImpacted(commitImpactContext)) {
                            if (impactedRules == null) {
                                impactedRules = new HashSet<PermissionImpl>();
                            }
                            impactedRules.add(permission);
                        }
                        ++i2;
                    }
                    if (impactedRules != null) {
                        securityImpact = 1;
                    }
                }
                ((InternalCommitContext)commitContext).setSecurityImpact((byte)securityImpact, impactedRules);
            }
            finally {
                PermissionUtil.setUser(null);
                PermissionUtil.doneViewCreation();
            }
        }

        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
            if (commitContext.getSecurityImpact() == 2) {
                SecurityManager.this.lastRealmModification = commitContext.getBranchPoint().getTimeStamp();
            }
            SecurityManager.this.handleCommitted(commitContext);
        }
    }
}

