/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.ResetSendMode;
import org.eclipse.epp.logging.aeri.core.SendMode;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>System Settings</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl#getSendMode <em>Send Mode</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl#getResetSendMode <em>Reset Send Mode</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl#getResetSendModeOn <em>Reset Send Mode On</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl#isConfigured <em>Configured</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl#isDebugEnabled <em>Debug Enabled</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SystemSettingsImpl#getAnonymousId <em>Anonymous Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SystemSettingsImpl extends UserSettingsImpl implements ISystemSettings {
	/**
	 * The default value of the '{@link #getSendMode() <em>Send Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSendMode()
	 * @generated
	 * @ordered
	 */
	protected static final SendMode SEND_MODE_EDEFAULT = SendMode.NOTIFY;

	/**
	 * The cached value of the '{@link #getSendMode() <em>Send Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSendMode()
	 * @generated
	 * @ordered
	 */
	protected SendMode sendMode = SEND_MODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getResetSendMode() <em>Reset Send Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResetSendMode()
	 * @generated
	 * @ordered
	 */
	protected static final ResetSendMode RESET_SEND_MODE_EDEFAULT = ResetSendMode.HOURS_24;

	/**
	 * The cached value of the '{@link #getResetSendMode() <em>Reset Send Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResetSendMode()
	 * @generated
	 * @ordered
	 */
	protected ResetSendMode resetSendMode = RESET_SEND_MODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getResetSendModeOn() <em>Reset Send Mode On</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResetSendModeOn()
	 * @generated
	 * @ordered
	 */
	protected static final long RESET_SEND_MODE_ON_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getResetSendModeOn() <em>Reset Send Mode On</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResetSendModeOn()
	 * @generated
	 * @ordered
	 */
	protected long resetSendModeOn = RESET_SEND_MODE_ON_EDEFAULT;

	/**
	 * The default value of the '{@link #isConfigured() <em>Configured</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isConfigured()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CONFIGURED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isConfigured() <em>Configured</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isConfigured()
	 * @generated
	 * @ordered
	 */
	protected boolean configured = CONFIGURED_EDEFAULT;

	/**
	 * The default value of the '{@link #isDebugEnabled() <em>Debug Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDebugEnabled()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DEBUG_ENABLED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDebugEnabled() <em>Debug Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDebugEnabled()
	 * @generated
	 * @ordered
	 */
	protected boolean debugEnabled = DEBUG_ENABLED_EDEFAULT;

	/**
	 * The default value of the '{@link #getAnonymousId() <em>Anonymous Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnonymousId()
	 * @generated
	 * @ordered
	 */
	protected static final String ANONYMOUS_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAnonymousId() <em>Anonymous Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnonymousId()
	 * @generated
	 * @ordered
	 */
	protected String anonymousId = ANONYMOUS_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SystemSettingsImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IModelPackage.Literals.SYSTEM_SETTINGS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SendMode getSendMode() {
		return sendMode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSendMode(SendMode newSendMode) {
		SendMode oldSendMode = sendMode;
		sendMode = newSendMode == null ? SEND_MODE_EDEFAULT : newSendMode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.SYSTEM_SETTINGS__SEND_MODE, oldSendMode, sendMode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResetSendMode getResetSendMode() {
		return resetSendMode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResetSendMode(ResetSendMode newResetSendMode) {
		ResetSendMode oldResetSendMode = resetSendMode;
		resetSendMode = newResetSendMode == null ? RESET_SEND_MODE_EDEFAULT : newResetSendMode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE, oldResetSendMode, resetSendMode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getResetSendModeOn() {
		return resetSendModeOn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResetSendModeOn(long newResetSendModeOn) {
		long oldResetSendModeOn = resetSendModeOn;
		resetSendModeOn = newResetSendModeOn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE_ON, oldResetSendModeOn, resetSendModeOn));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isConfigured() {
		return configured;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfigured(boolean newConfigured) {
		boolean oldConfigured = configured;
		configured = newConfigured;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.SYSTEM_SETTINGS__CONFIGURED, oldConfigured, configured));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDebugEnabled() {
		return debugEnabled;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDebugEnabled(boolean newDebugEnabled) {
		boolean oldDebugEnabled = debugEnabled;
		debugEnabled = newDebugEnabled;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.SYSTEM_SETTINGS__DEBUG_ENABLED, oldDebugEnabled, debugEnabled));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAnonymousId() {
		return anonymousId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnonymousId(String newAnonymousId) {
		String oldAnonymousId = anonymousId;
		anonymousId = newAnonymousId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.SYSTEM_SETTINGS__ANONYMOUS_ID, oldAnonymousId, anonymousId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IModelPackage.SYSTEM_SETTINGS__SEND_MODE:
				return getSendMode();
			case IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE:
				return getResetSendMode();
			case IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE_ON:
				return getResetSendModeOn();
			case IModelPackage.SYSTEM_SETTINGS__CONFIGURED:
				return isConfigured();
			case IModelPackage.SYSTEM_SETTINGS__DEBUG_ENABLED:
				return isDebugEnabled();
			case IModelPackage.SYSTEM_SETTINGS__ANONYMOUS_ID:
				return getAnonymousId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IModelPackage.SYSTEM_SETTINGS__SEND_MODE:
				setSendMode((SendMode)newValue);
				return;
			case IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE:
				setResetSendMode((ResetSendMode)newValue);
				return;
			case IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE_ON:
				setResetSendModeOn((Long)newValue);
				return;
			case IModelPackage.SYSTEM_SETTINGS__CONFIGURED:
				setConfigured((Boolean)newValue);
				return;
			case IModelPackage.SYSTEM_SETTINGS__DEBUG_ENABLED:
				setDebugEnabled((Boolean)newValue);
				return;
			case IModelPackage.SYSTEM_SETTINGS__ANONYMOUS_ID:
				setAnonymousId((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IModelPackage.SYSTEM_SETTINGS__SEND_MODE:
				setSendMode(SEND_MODE_EDEFAULT);
				return;
			case IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE:
				setResetSendMode(RESET_SEND_MODE_EDEFAULT);
				return;
			case IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE_ON:
				setResetSendModeOn(RESET_SEND_MODE_ON_EDEFAULT);
				return;
			case IModelPackage.SYSTEM_SETTINGS__CONFIGURED:
				setConfigured(CONFIGURED_EDEFAULT);
				return;
			case IModelPackage.SYSTEM_SETTINGS__DEBUG_ENABLED:
				setDebugEnabled(DEBUG_ENABLED_EDEFAULT);
				return;
			case IModelPackage.SYSTEM_SETTINGS__ANONYMOUS_ID:
				setAnonymousId(ANONYMOUS_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IModelPackage.SYSTEM_SETTINGS__SEND_MODE:
				return sendMode != SEND_MODE_EDEFAULT;
			case IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE:
				return resetSendMode != RESET_SEND_MODE_EDEFAULT;
			case IModelPackage.SYSTEM_SETTINGS__RESET_SEND_MODE_ON:
				return resetSendModeOn != RESET_SEND_MODE_ON_EDEFAULT;
			case IModelPackage.SYSTEM_SETTINGS__CONFIGURED:
				return configured != CONFIGURED_EDEFAULT;
			case IModelPackage.SYSTEM_SETTINGS__DEBUG_ENABLED:
				return debugEnabled != DEBUG_ENABLED_EDEFAULT;
			case IModelPackage.SYSTEM_SETTINGS__ANONYMOUS_ID:
				return ANONYMOUS_ID_EDEFAULT == null ? anonymousId != null : !ANONYMOUS_ID_EDEFAULT.equals(anonymousId);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (sendMode: ");
		result.append(sendMode);
		result.append(", resetSendMode: ");
		result.append(resetSendMode);
		result.append(", resetSendModeOn: ");
		result.append(resetSendModeOn);
		result.append(", configured: ");
		result.append(configured);
		result.append(", debugEnabled: ");
		result.append(debugEnabled);
		result.append(", anonymousId: ");
		result.append(anonymousId);
		result.append(')');
		return result.toString();
	}

} //SystemSettingsImpl
