/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.command;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class AddAttributeCommand
implements Command {
    private PersistentType jpt;
    private String attributeType;
    private String mapKeyType;
    private String attributeName;
    private String actName;
    private String[] attrTypes;
    private List<String> annotations;
    private boolean isCollection;

    public AddAttributeCommand(PersistentType jpt, String attributeType, String mapKeyType, String attributeName, String actName, String[] attrTypes, List<String> annotations, boolean isCollection) {
        this.jpt = jpt;
        this.attributeType = attributeType;
        this.mapKeyType = mapKeyType;
        this.attributeName = attributeName;
        this.actName = actName;
        this.attrTypes = attrTypes;
        this.annotations = annotations;
        this.isCollection = isCollection;
    }

    public void execute() {
        try {
            IJavaProject jp = JavaCore.create((IProject)this.jpt.getJpaProject().getProject());
            IType type = jp.findType(this.jpt.getName());
            ICompilationUnit cu = type.getCompilationUnit();
            JPAEditorUtil.createImport(cu, this.attributeType);
            this.attributeType = JPAEditorUtil.returnSimpleName(this.attributeType);
            if (this.attrTypes != null && this.attrTypes.length > 0) {
                JPAEditorUtil.createImports(cu, this.attrTypes);
            }
            String contents = "";
            if (this.annotations != null) {
                for (String an : this.annotations) {
                    contents = String.valueOf(contents) + "   " + an + "\n";
                }
            }
            this.createAttribute(this.jpt, this.attributeType, this.mapKeyType, this.attributeName, this.actName, cu, type, this.isCollection, this.attrTypes, contents);
            this.jpt.getJavaResourceType().getJavaResourceCompilationUnit().synchronizeWithJavaSource();
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannnot create a new attribute with name " + this.attributeName, e);
        }
    }

    private void createAttribute(PersistentType jpt, String attrTypeName, String mapKeyType, String attrName, String actName, ICompilationUnit cu, IType type, boolean isCollection, String[] attrTypeElementNames, String annotationContents) throws JavaModelException {
        if (isCollection) {
            this.createAttributeOfCollectiontype(jpt, attrTypeName, mapKeyType, attrName, actName, cu, type);
        } else {
            this.createSimpleAttribute(attrTypeName, attrName, actName, isCollection, type, attrTypeElementNames, annotationContents);
        }
    }

    private void createSimpleAttribute(String attributeType, String attributeName, String actName, boolean isCollection, IType type, String[] attrTypeElementNames, String annotationContents) throws JavaModelException {
        String attrFieldContent = "    private " + attributeType + (this.attrTypes == null ? "" : "<" + JPAEditorUtil.createCommaSeparatedListOfSimpleTypeNames(this.attrTypes) + ">") + " " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";";
        String contents = "";
        contents = this.jpt != null && !JpaArtifactFactory.instance().isMethodAnnotated(this.jpt) ? String.valueOf(annotationContents) + attrFieldContent : attrFieldContent;
        type.createField(contents, null, false, (IProgressMonitor)new NullProgressMonitor());
        type.createMethod(this.genGetterContents(attributeName, attributeType, actName, attrTypeElementNames, annotationContents), null, false, (IProgressMonitor)new NullProgressMonitor());
        type.createMethod(this.genSetterContents(attributeName, attributeType, actName, attrTypeElementNames), null, false, (IProgressMonitor)new NullProgressMonitor());
    }

    private void createAttributeOfCollectiontype(PersistentType jpt, String attributeType, String mapKeyType, String attributeName, String actName, ICompilationUnit cu, IType type) throws JavaModelException {
        Properties props;
        IProject project = jpt.getJpaProject().getProject();
        if (JPADiagramPropertyPage.isCollectionType(project, props = this.loadProperties(project))) {
            this.createAttributeByCollectionMethodType(attributeType, null, attributeName, actName, cu, type, "java.util.Collection");
        } else if (JPADiagramPropertyPage.isListType(project, props)) {
            this.createAttributeByCollectionMethodType(attributeType, null, attributeName, actName, cu, type, "java.util.List");
        } else if (JPADiagramPropertyPage.isSetType(project, props)) {
            this.createAttributeByCollectionMethodType(attributeType, null, attributeName, actName, cu, type, "java.util.Set");
        } else {
            this.createAttributeByCollectionMethodType(attributeType, mapKeyType, attributeName, actName, cu, type, "java.util.Map");
        }
    }

    private void createAttributeByCollectionMethodType(String attributeType, String mapKeyType, String attributeName, String actName, ICompilationUnit cu, IType type, String collectionType) throws JavaModelException {
        mapKeyType = this.createContentType(mapKeyType, attributeType, actName, cu, type, collectionType);
        type.createMethod(this.genGetterWithAppropriateType(attributeName, mapKeyType, attributeType, actName, collectionType), null, false, (IProgressMonitor)new NullProgressMonitor());
        type.createMethod(this.genSetterWithAppropriateType(attributeName, mapKeyType, attributeType, actName, collectionType), null, false, (IProgressMonitor)new NullProgressMonitor());
    }

    private String createContentType(String mapKeyType, String attributeType, String actName, ICompilationUnit cu, IType type, String collectionType) throws JavaModelException {
        if (mapKeyType != null) {
            mapKeyType = JPAEditorUtil.createImport(cu, mapKeyType);
        }
        JPAEditorUtil.createImport(cu, collectionType);
        type.createField("  private " + JPAEditorUtil.returnSimpleName(collectionType) + "<" + (mapKeyType != null ? String.valueOf(mapKeyType) + ", " : "") + attributeType + "> " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";", null, false, (IProgressMonitor)new NullProgressMonitor());
        return mapKeyType;
    }

    private String genGetterWithAppropriateType(String attrName, String mapKeyType, String attrType, String actName, String type) {
        String attrNameWithCapitalA = String.valueOf(actName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + actName.substring(1);
        String contents = "    public " + JPAEditorUtil.returnSimpleName(type) + "<" + (mapKeyType != null ? String.valueOf(mapKeyType) + ", " : "") + attrType + "> " + "get" + attrNameWithCapitalA + "() {\n" + "        return " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";\n" + "    }\n";
        return contents;
    }

    private String genSetterWithAppropriateType(String attrName, String mapKeyType, String attrType, String actName, String type) {
        String attrNameWithCapitalA = String.valueOf(actName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + actName.substring(1);
        String contents = "    public void set" + attrNameWithCapitalA + "(" + JPAEditorUtil.returnSimpleName(type) + "<" + (mapKeyType != null ? String.valueOf(mapKeyType) + ", " : "") + attrType + "> param) " + "{\n" + "        this." + JPAEditorUtil.decapitalizeFirstLetter(actName) + " = param;\n" + "    }\n";
        return contents;
    }

    private String genGetterContents(String attrName, String attrType, String actName, String[] attrTypeElementNames, String annotationContents) {
        String attrNameWithCapitalA = String.valueOf(actName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + actName.substring(1);
        String contents = "";
        if (this.jpt != null && JpaArtifactFactory.instance().isMethodAnnotated(this.jpt)) {
            contents = String.valueOf(contents) + annotationContents;
        }
        contents = String.valueOf(contents) + "    public " + attrType + (attrTypeElementNames == null ? "" : "<" + JPAEditorUtil.createCommaSeparatedListOfSimpleTypeNames(attrTypeElementNames) + ">") + (attrType.equals("boolean") ? " is" : " get") + attrNameWithCapitalA + "() {\n" + "        return " + JPAEditorUtil.decapitalizeFirstLetter(actName) + ";\n" + "    }\n";
        return contents;
    }

    private String genSetterContents(String attrName, String attrType, String actName, String[] attrTypeElementNames) {
        String attrNameWithCapitalA = String.valueOf(actName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + actName.substring(1);
        String contents = "    public void set" + attrNameWithCapitalA + "(" + attrType + (attrTypeElementNames == null ? "" : "<" + JPAEditorUtil.createCommaSeparatedListOfSimpleTypeNames(attrTypeElementNames) + ">") + " param) {\n" + "        this." + JPAEditorUtil.decapitalizeFirstLetter(actName) + " = param;\n" + "    }\n";
        return contents;
    }

    private Properties loadProperties(IProject project) {
        return JPADiagramPropertyPage.loadProperties(project);
    }
}

