/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.jws.HandlerChain;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSHandlerUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.wizards.NewJAXWSHandlerWizardPage;
import org.eclipse.jst.ws.internal.jaxws.ui.wizards.OrderHandlerChainPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jdom.Document;

public class NewJAXWSHandlerWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewJAXWSHandlerWizardPage handlerWizardPage;
    private OrderHandlerChainPage handlerOrderPage;

    public void addPages() {
        if (this.handlerWizardPage == null) {
            this.handlerWizardPage = new NewJAXWSHandlerWizardPage();
            this.handlerWizardPage.init(this.getSelection());
        }
        if (this.handlerOrderPage == null) {
            this.handlerOrderPage = new OrderHandlerChainPage();
        }
        this.addPage((IWizardPage)this.handlerWizardPage);
        this.addPage((IWizardPage)this.handlerOrderPage);
    }

    public NewJAXWSHandlerWizard() {
        this.setWindowTitle(JAXWSUIMessages.JAXWS_HANDLER_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(JAXWSUIPlugin.getImageDescriptor("$nl$/icons/wizban/new_wiz.png"));
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.handlerWizardPage && this.handlerWizardPage.isConfigureHandlerChain() && this.handlerWizardPage.isEditHandlerChain()) {
            this.handlerOrderPage.setJavaProject(this.handlerWizardPage.getJavaProject());
            Path handlerChainPath = new Path(this.handlerWizardPage.getExistingHandlerChainPath());
            this.handlerOrderPage.setInput((IPath)handlerChainPath);
            this.handlerOrderPage.addHandler(this.handlerWizardPage.getTypeName(), this.handlerWizardPage.getPackageText(), this.handlerWizardPage.getSelectedHandlerType());
            return this.handlerOrderPage;
        }
        return null;
    }

    public boolean performFinish() {
        try {
            Object rule = null;
            Job job = Job.getJobManager().currentJob();
            rule = job != null ? job.getRule() : ResourcesPlugin.getWorkspace().getRoot();
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation((ISchedulingRule)rule){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    NewJAXWSHandlerWizard.this.handlerWizardPage.createType(monitor);
                    IType type = NewJAXWSHandlerWizard.this.handlerWizardPage.getCreatedType();
                    if (NewJAXWSHandlerWizard.this.handlerWizardPage.isConfigureHandlerChain()) {
                        Path handlerChainPath;
                        if (NewJAXWSHandlerWizard.this.handlerWizardPage.isCreateHandlerChain()) {
                            handlerChainPath = new Path(NewJAXWSHandlerWizard.this.handlerWizardPage.getNewHandlerChainPath());
                            JAXWSHandlerUtils.createHandlerChainFile((IPath)handlerChainPath);
                            JAXWSHandlerUtils.addHandlerToHandlerChain((IPath)handlerChainPath, (String)type.getElementName(), (String)type.getFullyQualifiedName());
                        } else if (NewJAXWSHandlerWizard.this.handlerWizardPage.isEditHandlerChain()) {
                            handlerChainPath = new Path(NewJAXWSHandlerWizard.this.handlerWizardPage.getExistingHandlerChainPath());
                            JAXWSHandlerUtils.writeDocumentToFile((IPath)handlerChainPath, (Document)NewJAXWSHandlerWizard.this.handlerOrderPage.getDocument());
                        }
                        if (NewJAXWSHandlerWizard.this.handlerWizardPage.isAssociateHandlerChain()) {
                            String fullyQualifiedName = NewJAXWSHandlerWizard.this.handlerWizardPage.getSelectedWebServicePath();
                            IType webServiceType = NewJAXWSHandlerWizard.this.handlerWizardPage.getJavaProject().findType(fullyQualifiedName);
                            Path handlerChainPath2 = new Path(NewJAXWSHandlerWizard.this.handlerWizardPage.getHandlerChainPath());
                            IFile handlerChainFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)handlerChainPath2);
                            URI relativeURI = URI.createPlatformResourceURI((String)handlerChainFile.getLocation().toOSString(), (boolean)false).deresolve(URI.createPlatformResourceURI((String)webServiceType.getResource().getLocation().toOSString(), (boolean)false));
                            ICompilationUnit compilationUnit = webServiceType.getCompilationUnit();
                            ASTParser parser = ASTParser.newParser((int)3);
                            parser.setSource(compilationUnit);
                            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
                            Annotation annotation = AnnotationUtils.getAnnotation((IJavaElement)webServiceType, HandlerChain.class);
                            if (annotation != null && annotation instanceof NormalAnnotation) {
                                NormalAnnotation handlerChainAnnotation = (NormalAnnotation)annotation;
                                MemberValuePair filePair = AnnotationUtils.getMemberValuePair((NormalAnnotation)handlerChainAnnotation, (String)"file");
                                if (filePair != null) {
                                    StringLiteral file = AnnotationsCore.createStringLiteral((AST)cu.getAST(), (String)relativeURI.toFileString());
                                    AnnotationUtils.updateMemberValuePair((MemberValuePair)filePair, (ASTNode)file);
                                }
                            } else {
                                ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
                                MemberValuePair filePair = AnnotationsCore.createStringMemberValuePair((AST)cu.getAST(), (String)"file", (String)relativeURI.toFileString());
                                memberValuePairs.add(filePair);
                                NormalAnnotation handlerChainAnnotation = AnnotationsCore.createNormalAnnotation((AST)cu.getAST(), (String)HandlerChain.class.getSimpleName(), memberValuePairs);
                                AnnotationUtils.addAnnotation((IJavaElement)webServiceType, (Annotation)handlerChainAnnotation);
                                AnnotationUtils.addImport((IJavaElement)webServiceType, (String)HandlerChain.class.getCanonicalName());
                            }
                        }
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)workspaceModifyOperation, rule);
        }
        catch (InvocationTargetException ite) {
            JAXWSUIPlugin.log(ite);
            return false;
        }
        catch (InterruptedException ie) {
            JAXWSUIPlugin.log(ie);
            return false;
        }
        IResource resource = this.handlerWizardPage.getModifiedResource();
        if (resource != null) {
            BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
            this.openResource((IFile)resource);
        }
        return true;
    }

    protected void openResource(final IFile resource) {
        Display display;
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        JAXWSUIPlugin.log(e);
                    }
                }
            });
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    private IStructuredSelection getSelection() {
        return this.selection;
    }
}

