/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.widgets.I18nDirectCombo;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractI18nCombo<TheObject>
extends I18nDirectCombo<TheObject> {
    private String m_baseKey;
    private IKeyMaker m_keyMaker;

    public AbstractI18nCombo(Composite parent, int style, String baseKey, List<TheObject> keys, IKeyMaker keyMaker, boolean isNullSelectionAllowed, Comparator<String> comparator) {
        super(parent, style, keys, AbstractI18nCombo.buildI18nKeys(baseKey, keys, keyMaker), isNullSelectionAllowed, comparator);
        this.m_baseKey = baseKey;
        this.m_keyMaker = keyMaker;
    }

    public AbstractI18nCombo(Composite parent, int style, String baseKey, List<TheObject> keys, IKeyMaker keyMaker, boolean isNullSelectionAllowed, boolean sortEntries) {
        this(parent, style, baseKey, keys, keyMaker, isNullSelectionAllowed, sortEntries ? new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        } : null);
    }

    public void setItems(List<TheObject> keys) {
        super.setItems(keys, AbstractI18nCombo.buildI18nKeys(this.m_baseKey, keys, this.m_keyMaker));
    }

    @Override
    @Deprecated
    public void setItems(List<TheObject> values, List<String> i18nKeys) {
        throw new IllegalStateException(Messages.SetItemsNotValidForThisSubclass);
    }

    @Override
    protected void checkSubclass() {
    }

    private static List<String> buildI18nKeys(String baseKey, List<?> keys, IKeyMaker keyMaker) {
        ArrayList<String> result = new ArrayList<String>(keys.size());
        String startOfKey = String.valueOf(baseKey) + '.';
        for (Object key : keys) {
            result.add(String.valueOf(startOfKey) + keyMaker.makeKey(key));
        }
        return result;
    }

    public static interface IKeyMaker {
        public String makeKey(Object var1);
    }
}

