/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.components;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.eclipse.jubula.rc.javafx.tester.util.compatibility.WindowsUtil;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStages {
    public static final String JUBULA_FX_POLLING_RATE = "JUBULA_FX_POLLING_RATE";
    public static final String JUBULA_FX_WAIT_BEFORE_INIT = "JUBULA_FX_WAIT_BEFORE_INIT";
    private static final Logger LOG;
    private static ObservableList<Window> windows;

    static {
        String waitEnvString;
        LOG = LoggerFactory.getLogger(CurrentStages.class);
        windows = FXCollections.observableArrayList();
        String pollingEnvString = EnvironmentUtils.getProcessOrSystemProperty((String)JUBULA_FX_POLLING_RATE);
        double pollingRate = 5.0;
        if (pollingEnvString != null) {
            try {
                pollingRate = Double.parseDouble(pollingEnvString);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.info("Could not convert the value.using standard polling rate " + pollingRate + "ms");
            }
        }
        if ((waitEnvString = EnvironmentUtils.getProcessOrSystemProperty((String)JUBULA_FX_WAIT_BEFORE_INIT)) != null) {
            int waitTimeInMs = 2000;
            try {
                waitTimeInMs = Integer.parseInt(waitEnvString);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.info("Could not convert the value.using standard wait time " + waitTimeInMs + "ms");
            }
            try {
                Thread.interrupted();
                Thread.sleep(waitTimeInMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        Timeline checkWindowList = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)pollingRate), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Window w;
                ListIterator it = WindowsUtil.getWindowIterator();
                ArrayList<Window> tempWin = new ArrayList<Window>();
                while (it.hasNext()) {
                    w = it.next();
                    tempWin.add(w);
                    if (windows.contains((Object)w)) continue;
                    windows.add((Object)w);
                }
                it = windows.listIterator();
                while (it.hasNext()) {
                    w = (Window)it.next();
                    if (tempWin.contains(w)) continue;
                    it.remove();
                }
            }
        }, new KeyValue[0])});
        checkWindowList.setCycleCount(-1);
        checkWindowList.play();
    }

    private CurrentStages() {
    }

    public static Window getfirstStage() {
        for (Window window : windows) {
            if (!(window instanceof Stage)) continue;
            return window;
        }
        return null;
    }

    public static List<Window> getWindowList() {
        return windows;
    }

    public static Window getfocusStage() {
        Window fStage = null;
        for (Window win : windows) {
            if (!win.isFocused() || !(win instanceof Stage)) continue;
            fStage = win;
        }
        return fStage;
    }

    public static void addStagesListener(ListChangeListener<Window> listener) {
        windows.addListener(listener);
    }

    public static void removeStagesListener(ListChangeListener<Window> listener) {
        windows.removeListener(listener);
    }
}

