/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.plugin.internal;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jwt.we.conf.model.plugin.internal.Logger;

public class EMFUtils {
    private static Logger logger = Logger.getLogger(EMFUtils.class);

    public static final EObject getRootEObject(Object modelElement) {
        if (!(modelElement instanceof EObject)) {
            return null;
        }
        EObject eModelElement = (EObject)modelElement;
        EObject eContainer = null;
        while ((eContainer = eModelElement.eContainer()) != null) {
            eModelElement = eContainer;
        }
        return eModelElement;
    }

    public static URI getResourceOrProxyURI(EObject eObject) {
        URI eObjectResourceURI = null;
        Resource eObjectResource = eObject.eResource();
        if (eObjectResource != null) {
            eObjectResourceURI = eObjectResource.getURI();
        } else if (eObject.eIsProxy() && eObject instanceof InternalEObject) {
            URI eObjectURI = ((InternalEObject)eObject).eProxyURI();
            eObjectResourceURI = eObjectURI.trimFragment();
        }
        return eObjectResourceURI;
    }

    public static final void updateResourceOrProxyURI(EObject eObject, URI newURI) {
        Resource eObjectResource = eObject.eResource();
        if (eObjectResource != null) {
            eObjectResource.setURI(newURI);
        } else if (eObject.eIsProxy()) {
            URI eObjectURI = ((InternalEObject)eObject).eProxyURI();
            URI newEObjectURI = newURI.appendFragment(eObjectURI.fragment());
            ((InternalEObject)eObject).eSetProxyURI(newEObjectURI);
        }
    }

    public static EClass toEClass(String modelElementEType) {
        int packageEndIndex = Math.max(modelElementEType.lastIndexOf(46), modelElementEType.lastIndexOf(47));
        String targetEPackageName = modelElementEType.substring(0, packageEndIndex);
        String targetEClassName = modelElementEType.substring(packageEndIndex + 1);
        EPackage targetEPackage = EPackage.Registry.INSTANCE.getEPackage(targetEPackageName);
        if (targetEPackage == null) {
            return null;
        }
        EClass targetEClass = (EClass)targetEPackage.getEClassifier(targetEClassName);
        if (targetEClass == null) {
            return null;
        }
        return targetEClass;
    }

    public static EPackage getETypeEPackage(URI eTypeURI) {
        EPackage foundEPackage = EPackage.Registry.INSTANCE.getEPackage(eTypeURI.trimFragment().toString());
        return foundEPackage;
    }

    public static EClassifier getETypeEClassifier(URI eTypeURI) {
        EPackage foundEPackage = EMFUtils.getETypeEPackage(eTypeURI);
        if (foundEPackage == null) {
            return null;
        }
        return EMFUtils.getETypeEClassifier(eTypeURI, foundEPackage);
    }

    public static EClassifier getETypeEClassifier(URI eTypeURI, EPackage eTypeEPackage) {
        Resource eTypeResource = eTypeEPackage.eResource();
        if (eTypeResource != null) {
            EObject foundEObject = eTypeResource.getEObject(eTypeURI.fragment().toString());
            if (foundEObject instanceof EClassifier) {
                return (EClassifier)foundEObject;
            }
            logger.warning("Can't find eClassifier of eType " + eTypeURI + " in ePackage " + eTypeEPackage);
        }
        return null;
    }
}

