/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet.internal;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.libra.facet.OSGiBundleFacetUtils;
import org.eclipse.libra.facet.internal.LibraFacetPlugin;
import org.eclipse.libra.facet.internal.Messages;
import org.eclipse.osgi.util.NLS;

public class WebContextRootSynchonizer
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        if (event.getType() != 1) {
            return;
        }
        final HashSet<IProject> projectsWithModifiedWTPModel = new HashSet<IProject>();
        final HashSet<IProject> projectsWithModifiedPDEModel = new HashSet<IProject>();
        IResourceDelta rootDelta = event.getDelta();
        IResourceDelta[] iResourceDeltaArray = projectDeltas = rootDelta.getAffectedChildren();
        int n = projectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta projectDelta = iResourceDeltaArray[n2];
            IProject project = (IProject)projectDelta.getResource();
            if (this.isWAB(project)) {
                IResourceDelta manifestDelta;
                IResourceDelta componentDelta = projectDelta.findMember(OSGiBundleFacetUtils.VIRTUAL_COMPONENT_PATH);
                if (this.isContentChanged(componentDelta)) {
                    projectsWithModifiedWTPModel.add(project);
                }
                if (this.isContentChanged(manifestDelta = projectDelta.findMember(OSGiBundleFacetUtils.getManifestPath(project)))) {
                    projectsWithModifiedPDEModel.add(project);
                }
            }
            ++n2;
        }
        if (projectsWithModifiedWTPModel.size() > 0 || projectsWithModifiedPDEModel.size() > 0) {
            new Job(Messages.WebContextRootSynchonizer_JobName){

                protected IStatus run(IProgressMonitor monitor) {
                    String oldContextRoot;
                    String newContextRoot;
                    for (IProject project : projectsWithModifiedWTPModel) {
                        try {
                            project.build(10, monitor);
                            newContextRoot = OSGiBundleFacetUtils.getContextRootFromWTPModel(project);
                            oldContextRoot = OSGiBundleFacetUtils.getContextRootFromPDEModel(project);
                            if (this.areEqual(newContextRoot, oldContextRoot)) continue;
                            OSGiBundleFacetUtils.setContextRootInPDEModel(project, newContextRoot, monitor);
                        }
                        catch (CoreException e) {
                            LibraFacetPlugin.logError(NLS.bind((String)Messages.WebContextRootSynchonizer_UpdatingPDEModelFailed, (Object)project.getName()), e);
                        }
                    }
                    for (IProject project : projectsWithModifiedPDEModel) {
                        try {
                            project.build(10, monitor);
                            newContextRoot = OSGiBundleFacetUtils.getContextRootFromPDEModel(project);
                            oldContextRoot = OSGiBundleFacetUtils.getContextRootFromWTPModel(project);
                            if (this.areEqual(newContextRoot, oldContextRoot)) continue;
                            OSGiBundleFacetUtils.setContextRootInWTPModel(project, newContextRoot);
                        }
                        catch (CoreException e) {
                            LibraFacetPlugin.logError(NLS.bind((String)Messages.WebContextRootSynchonizer_UpdatingWTPModelFailed, (Object)project.getName()), e);
                        }
                    }
                    return Status.OK_STATUS;
                }

                private boolean areEqual(String value1, String value2) {
                    if (value1 == null) {
                        return value2 == null;
                    }
                    return value1.equals(value2);
                }
            }.schedule();
        }
    }

    private boolean isWAB(IProject project) {
        boolean result = false;
        try {
            result = OSGiBundleFacetUtils.isWebApplicationBundle(project);
        }
        catch (CoreException e) {
            LibraFacetPlugin.logError(e);
        }
        return result;
    }

    private boolean isContentChanged(IResourceDelta delta) {
        return delta != null && delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0;
    }
}

