/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectCreationListener;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.OpenMavenConsoleAction;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractCreateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenProjectWizard;
import org.eclipse.m2e.core.ui.internal.wizards.MavenModuleWizardParentPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArchetypePage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArchetypeParametersPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArtifactPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWorkspaceAssigner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.progress.IProgressConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MavenModuleWizard
extends AbstractMavenProjectWizard
implements INewWizard {
    private static final Logger LOG = LoggerFactory.getLogger(MavenModuleWizard.class);
    protected MavenModuleWizardParentPage parentPage;
    protected MavenProjectWizardArchetypePage archetypePage;
    protected MavenProjectWizardArtifactPage artifactPage;
    protected MavenProjectWizardArchetypeParametersPage parametersPage;
    private String moduleName;
    protected boolean isEditor = false;

    public MavenModuleWizard() {
        this.setWindowTitle(Messages.wizardModuleTitle);
        this.setDefaultPageImageDescriptor(MavenImages.WIZ_NEW_PROJECT);
        this.setNeedsProgressMonitor(true);
    }

    public MavenModuleWizard(boolean isEditor) {
        this();
        this.isEditor = isEditor;
    }

    public void addPages() {
        this.parentPage = new MavenModuleWizardParentPage(this.importConfiguration, this.workingSets);
        this.archetypePage = new MavenProjectWizardArchetypePage(this.importConfiguration);
        this.parametersPage = new MavenProjectWizardArchetypeParametersPage(this.importConfiguration);
        this.artifactPage = new MavenProjectWizardArtifactPage(this.importConfiguration);
        this.addPage((IWizardPage)this.parentPage);
        this.addPage((IWizardPage)this.archetypePage);
        this.addPage((IWizardPage)this.parametersPage);
        this.addPage((IWizardPage)this.artifactPage);
    }

    public void createPageControls(Composite pageContainer) {
        this.artifactPage.setParentReadonly(true);
        this.artifactPage.setTitle(Messages.wizardModulePageArtifactTitle);
        this.archetypePage.setTitle(Messages.wizardModulePageArchetypeTitle);
        this.parametersPage.setTitle(Messages.wizardModulePageParametersTitle);
        super.createPageControls(pageContainer);
        this.parametersPage.setArtifactIdEnabled(false);
        this.parentPage.addArchetypeSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isArchetype = !MavenModuleWizard.this.parentPage.isSimpleProject();
                MavenModuleWizard.this.archetypePage.setUsed(isArchetype);
                MavenModuleWizard.this.parametersPage.setUsed(isArchetype);
            }
        });
        this.parentPage.addModuleNameListener(e -> {
            this.parametersPage.setProjectName(this.parentPage.getModuleName());
            this.artifactPage.setProjectName(this.parentPage.getModuleName());
        });
        this.parentPage.addParentProjectListener(e -> this.copyParentValues());
        this.archetypePage.addArchetypeSelectionListener(selectionchangedevent -> {
            this.parametersPage.setArchetype(this.archetypePage.getArchetype());
            this.getContainer().updateButtons();
        });
        if (this.selection != null && this.selection.size() > 0) {
            this.parentPage.setParent(this.selection.getFirstElement());
            this.copyParentValues();
        }
    }

    protected void copyParentValues() {
        Model model = this.parentPage.getParentModel();
        if (model != null) {
            Parent parent;
            String groupId = model.getGroupId();
            String artifactId = model.getArtifactId();
            String version = model.getVersion();
            if (groupId == null && (parent = model.getParent()) != null) {
                groupId = parent.getGroupId();
            }
            if (version == null && (parent = model.getParent()) != null) {
                version = parent.getVersion();
            }
            this.artifactPage.setParentProject(groupId, artifactId, version);
            this.parametersPage.setParentProject(groupId, artifactId, version);
        }
    }

    public boolean performFinish() {
        AbstractCreateMavenProjectJob job;
        final String moduleName = this.parentPage.getModuleName();
        final IPath location = this.parentPage.getParentContainer().getLocation();
        final IFile parentPom = this.parentPage.getPom();
        if (this.parentPage.isSimpleProject()) {
            final Model model = this.artifactPage.getModel();
            if (model.getParent() != null) {
                Parent par = model.getParent();
                String relPath = location.makeRelativeTo(location.append(moduleName)).toOSString();
                if (!"..".equals(relPath)) {
                    par.setRelativePath(relPath);
                }
                if (par.getGroupId() != null && par.getGroupId().equals(model.getGroupId())) {
                    model.setGroupId(null);
                }
                if (par.getVersion() != null && par.getVersion().equals(model.getVersion())) {
                    model.setVersion(null);
                }
            }
            final String[] folders = this.artifactPage.getFolders();
            job = new AbstractCreateMavenProjectJob(NLS.bind((String)Messages.wizardProjectJobCreatingProject, (Object)moduleName)){

                @Override
                protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                    this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)new OpenMavenConsoleAction());
                    String projectName = MavenModuleWizard.this.importConfiguration.getProjectName(model);
                    IProject project = MavenModuleWizard.this.importConfiguration.getProject(ResourcesPlugin.getWorkspace().getRoot(), model);
                    MavenPlugin.getProjectConfigurationManager().createSimpleProject(project, location.append(moduleName), model, folders, MavenModuleWizard.this.importConfiguration, (IProjectCreationListener)new MavenProjectWorkspaceAssigner(MavenModuleWizard.this.workingSets), monitor);
                    MavenModuleWizard.this.setModule(projectName);
                    return Arrays.asList(project);
                }
            };
        } else {
            Model model = this.parametersPage.getModel();
            final Archetype archetype = this.archetypePage.getArchetype();
            final String groupId = model.getGroupId();
            final String artifactId = model.getArtifactId();
            final String version = model.getVersion();
            final String javaPackage = this.parametersPage.getJavaPackage();
            final Properties properties = this.parametersPage.getProperties();
            job = new AbstractCreateMavenProjectJob(NLS.bind((String)Messages.wizardProjectJobCreating, (Object)archetype.getArtifactId())){

                @Override
                protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                    List projects = MavenPlugin.getProjectConfigurationManager().createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, MavenModuleWizard.this.importConfiguration, (IProjectCreationListener)new MavenProjectWorkspaceAssigner(MavenModuleWizard.this.workingSets), monitor);
                    MavenModuleWizard.this.setModule(moduleName);
                    return projects;
                }
            };
        }
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus result = event.getResult();
                if (result.isOK()) {
                    if (!MavenModuleWizard.this.isEditor) {
                        try {
                            PomEdits.performOnDOMDocument(new PomEdits.OperationTuple(parentPom, document -> {
                                Element root = document.getDocumentElement();
                                Element modules = PomEdits.getChild(root, "modules");
                                if (PomEdits.findChild(modules, "module", PomEdits.textEquals(moduleName)) == null) {
                                    PomEdits.format(PomEdits.createElementWithText(modules, "module", moduleName));
                                }
                            }));
                        }
                        catch (Exception e) {
                            LOG.error("Cannot add module to parent POM", (Throwable)e);
                        }
                    }
                } else {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)MavenModuleWizard.this.getShell(), (String)NLS.bind((String)Messages.wizardProjectJobFailed, (Object)moduleName), (String)result.getMessage()));
                }
            }
        });
        job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
        job.schedule();
        if (this.isEditor) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    void setModule(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }
}

