/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.m2m.atl.adt.ui.common.RegisteredPackageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlResourceSelectionBox
extends LoadResourceAction.LoadResourceDialog {
    private Shell shell;
    private Set<EPackage> registeredPackages = new LinkedHashSet<EPackage>();

    public AtlResourceSelectionBox(Shell parent) {
        super(parent);
        this.shell = parent;
    }

    protected boolean processResource(Resource resource) {
        ResourceSet resourceSet = this.domain.getResourceSet();
        if (!resourceSet.getResources().contains((Object)resource)) {
            EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
            for (EPackage ePackage : this.getAllPackages(resource)) {
                packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                this.registeredPackages.add(ePackage);
            }
        }
        return true;
    }

    public Set<EPackage> getRegisteredPackages() {
        return this.registeredPackages;
    }

    private Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
            }
        };
        while (j.hasNext()) {
            Object content = j.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite buttonComposite = (Composite)composite.getChildren()[0];
        Button browseRegisteredPackagesButton = new Button(buttonComposite, 8);
        browseRegisteredPackagesButton.setText(EcoreEditorPlugin.INSTANCE.getString("_UI_BrowseRegisteredPackages_label"));
        this.prepareBrowseRegisteredPackagesButton(browseRegisteredPackagesButton);
        FormData data = new FormData();
        Control[] children = buttonComposite.getChildren();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(children[0], -10);
        browseRegisteredPackagesButton.setLayoutData((Object)data);
        this.uriField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] uris;
                String text = AtlResourceSelectionBox.this.uriField.getText();
                if (text.contains(" ") && (uris = text.split(" ")).length > 0) {
                    AtlResourceSelectionBox.this.uriField.setText(uris[uris.length - 1]);
                }
            }
        });
        return composite;
    }

    private void prepareBrowseRegisteredPackagesButton(Button browseRegisteredPackagesButton) {
        browseRegisteredPackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RegisteredPackageDialog dialog = new RegisteredPackageDialog(AtlResourceSelectionBox.this.getShell());
                if (dialog.open() == 0) {
                    AtlResourceSelectionBox.this.uriField.setText(dialog.getResultAsString());
                }
            }
        });
    }

    public String getURIText() {
        String res = super.getURIText();
        if (res != null && res.contains(" ")) {
            res = res.split(" ")[0];
        }
        return res;
    }

    public void setText(String text) {
        this.uriField.setText(text);
    }

    public Shell getShell() {
        return this.shell;
    }

    protected boolean isMulti() {
        return false;
    }
}

