/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarker;
import org.eclipse.objectteams.otdt.ui.IUpdateRulerActionExtender;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class UpdateRulerAction
extends AbstractRulerActionDelegate {
    public static final String OT_PLAYEDBY_MENU_LABEL = OTDTUIPlugin.getResourceString("CallinMarker.menu_playedby_title");
    public static final String OT_CALLIN_MENU_LABEL = OTDTUIPlugin.getResourceString("CallinMarker.menu_callin_title");
    public static final String OT_CALLOUT_MENU_LABEL = OTDTUIPlugin.getResourceString("CallinMarker.menu_callout_title");
    private IEditorPart _editor = null;
    private IVerticalRulerInfo _rulerInfo = null;
    private List<IUpdateRulerActionExtender> extenders = null;

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        this._editor = targetEditor;
        super.setActiveEditor(callerAction, targetEditor);
    }

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this._rulerInfo = rulerInfo;
        return null;
    }

    public void menuAboutToShow(IMenuManager contextMenu) {
        int clickedLine;
        IDocument document;
        block13: {
            document = null;
            clickedLine = this._rulerInfo.getLineOfLastMouseButtonActivity();
            if (this._editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)this._editor;
                document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            }
            try {
                IMarker[] markers = this.findCallinMarkers();
                if (markers == null || markers.length == 0) break block13;
                int idx = 0;
                while (idx < markers.length) {
                    IMarker curMarker = markers[idx];
                    int line = curMarker.getAttribute("lineNumber", -1);
                    if (line != -1) {
                        if (line - 1 == clickedLine) {
                            this.insertTeamMenus(contextMenu, curMarker);
                        }
                    } else if (document != null) {
                        int start = curMarker.getAttribute("charStart", -1);
                        try {
                            if (clickedLine == document.getLineOfOffset(start)) {
                                this.insertTeamMenus(contextMenu, curMarker);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    ++idx;
                }
            }
            catch (CoreException ex) {
                OTDTUIPlugin.logException("Problems extending ruler context menu", ex);
            }
        }
        if (this.extenders == null) {
            this.loadExtenders();
        }
        for (IUpdateRulerActionExtender extender : this.extenders) {
            extender.menuAboutToShow(contextMenu, document, this._editor, clickedLine);
        }
    }

    private IMarker[] findCallinMarkers() throws CoreException {
        IEditorInput editorInput = this._editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            IFile file = fileEditorInput.getFile();
            IMarker[] result = CallinMarker.getAllBindingMarkers((IResource)file);
            return result;
        }
        if (editorInput instanceof IClassFileEditorInput) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IMarker[] allMarkers = CallinMarker.getAllBindingMarkers((IResource)root);
            IClassFile classFile = ((IClassFileEditorInput)editorInput).getClassFile();
            ArrayList<IMarker> filteredMarkers = new ArrayList<IMarker>(13);
            IMarker[] iMarkerArray = allMarkers;
            int n = allMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (JavaCore.isReferencedBy((IJavaElement)classFile, (IMarker)marker)) {
                    filteredMarkers.add(marker);
                }
                ++n2;
            }
            return filteredMarkers.toArray(new IMarker[filteredMarkers.size()]);
        }
        return null;
    }

    private IMenuManager getObjectTeamsMenu(IMenuManager contextMenu, String markerKind) {
        String label = "org.eclipse.objectteams.otdt.ui.callinMarker".equals(markerKind) ? OT_CALLIN_MENU_LABEL : ("org.eclipse.objectteams.otdt.ui.calloutMarker".equals(markerKind) ? OT_CALLOUT_MENU_LABEL : OT_PLAYEDBY_MENU_LABEL);
        IMenuManager subMenu = this.getSubMenu(contextMenu, label);
        if (subMenu != null) {
            return subMenu;
        }
        MenuManager otMenu = new MenuManager(label, markerKind);
        if (contextMenu.isEmpty()) {
            contextMenu.add((IContributionItem)otMenu);
        } else {
            contextMenu.insertBefore(contextMenu.getItems()[0].getId(), (IContributionItem)otMenu);
        }
        return otMenu;
    }

    private IAction createOpenEditorAction(String label, final IJavaElement target) {
        Action result = new Action(label){

            public void run() {
                try {
                    IEditorPart part = EditorUtility.openInEditor((Object)target);
                    if (target.exists()) {
                        EditorUtility.revealInEditor((IEditorPart)part, (IJavaElement)target);
                    }
                }
                catch (PartInitException ex) {
                    OTDTUIPlugin.logException("Problems initializing editor", ex);
                }
            }
        };
        return result;
    }

    List<IMember> getMappings(IMarker marker) throws CoreException {
        int pos;
        Object attr = marker.getAttribute("org.eclipse.objectteams.otdt.ui.markerAttr.RoleElements");
        if (attr == null || !(attr instanceof String)) {
            return null;
        }
        String str = (String)attr;
        ArrayList<IMember> result = new ArrayList<IMember>();
        int start = 0;
        while ((pos = str.indexOf(10, start)) != -1) {
            result.add((IMember)JavaCore.create((String)str.substring(start, pos)));
            start = pos + 1;
        }
        return result;
    }

    private void insertTeamMenus(IMenuManager contextMenu, IMarker marker) throws CoreException {
        List<IMember> mappings = this.getMappings(marker);
        if (mappings == null) {
            return;
        }
        IMenuManager otMenu = this.getObjectTeamsMenu(contextMenu, marker.getType());
        for (IMember curMapping : mappings) {
            IType type = (IType)curMapping.getAncestor(7);
            IOTType otType = OTModelManager.getOTElement((IType)type);
            if (otType == null || !otType.isRole()) continue;
            IOTType teamType = ((IRoleType)otType).getTeam();
            MenuManager curTeamMenu = null;
            if (!this.isSubMenuContained(otMenu, teamType.getElementName())) {
                curTeamMenu = new MenuManager(teamType.getElementName());
                otMenu.add((IContributionItem)curTeamMenu);
            } else {
                curTeamMenu = this.getSubMenu(otMenu, teamType.getElementName());
            }
            String actLabel = this.getMappingLabel(type, curMapping);
            curTeamMenu.add(this.createOpenEditorAction(actLabel, (IJavaElement)curMapping));
        }
    }

    private String getMappingLabel(IType type, IMember mapping) {
        if (type.equals(mapping)) {
            return type.getElementName();
        }
        return String.valueOf(type.getElementName()) + ": " + mapping.getElementName();
    }

    private IMenuManager getSubMenu(IMenuManager otMenu, String subMenuName) {
        if (otMenu == null) {
            return null;
        }
        IContributionItem[] items = otMenu.getItems();
        int idx = 0;
        while (idx < items.length) {
            MenuManager cur;
            if (items[idx] instanceof IMenuManager && (cur = (MenuManager)items[idx]).getMenuText().equals(subMenuName)) {
                return cur;
            }
            ++idx;
        }
        return null;
    }

    private boolean isSubMenuContained(IMenuManager menu, String subMenuName) {
        return this.getSubMenu(menu, subMenuName) != null;
    }

    private void loadExtenders() {
        IConfigurationElement[] configs;
        this.extenders = new ArrayList<IUpdateRulerActionExtender>();
        IConfigurationElement[] iConfigurationElementArray = configs = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.objectteams.otdt.ui", "updateRulerActionExtenders");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                if (this._editor.getClass().getName().equals(config.getAttribute("editorClass"))) {
                    this.extenders.add((IUpdateRulerActionExtender)config.createExecutableExtension("class"));
                }
            }
            catch (CoreException e) {
                OTDTUIPlugin.log(e);
            }
            ++n2;
        }
    }
}

