/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers.support;

import java.util.HashMap;
import org.eclipse.ptp.rm.lml.core.model.LMLColor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ColorConversion {
    private static HashMap<Integer, Color> colorMap = new HashMap();

    public static void disposeColors() {
        for (Color color : colorMap.values()) {
            color.dispose();
        }
        colorMap.clear();
    }

    public static Color getColor(int red, int green, int blue) {
        int id = ColorConversion.getId(red, green, blue);
        if (colorMap.containsKey(id)) {
            return colorMap.get(id);
        }
        Color result = new Color((Device)Display.getCurrent(), red, green, blue);
        colorMap.put(id, result);
        return result;
    }

    public static Color getColor(LMLColor lmlColor) {
        return ColorConversion.getColor(lmlColor.getRed(), lmlColor.getGreen(), lmlColor.getBlue());
    }

    private static int getId(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }
}

