/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.handler;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.workbench.exception.WorkbenchLayerException;
import org.eclipse.reddeer.workbench.handler.EditorHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorHandler
extends EditorHandler {
    private static TextEditorHandler instance;

    public static TextEditorHandler getInstance() {
        if (instance == null) {
            instance = new TextEditorHandler();
        }
        return instance;
    }

    public void setText(final ITextEditor editor, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set(text);
            }
        });
    }

    public String getTextAtLine(final ITextEditor editor, final int line) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                try {
                    if (TextEditorHandler.this.getDocument(editor).getLineDelimiter(line) != null) {
                        return TextEditorHandler.this.getDocument(editor).get(TextEditorHandler.this.getDocument(editor).getLineOffset(line), TextEditorHandler.this.getDocument(editor).getLineLength(line)).replace(TextEditorHandler.this.getDocument(editor).getLineDelimiter(line), "");
                    }
                    return TextEditorHandler.this.getDocument(editor).get(TextEditorHandler.this.getDocument(editor).getLineOffset(line), TextEditorHandler.this.getDocument(editor).getLineLength(line));
                }
                catch (BadLocationException e) {
                    throw new WorkbenchLayerException("Line provided is invalid for this editor", e);
                }
            }
        });
    }

    public int getNumberOfLines(final ITextEditor editor) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return TextEditorHandler.this.getDocument(editor).getNumberOfLines();
            }
        });
    }

    public void insertText(final ITextEditor editor, final int line, final int offset, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TextEditorHandler.this.getDocument(editor).replace(TextEditorHandler.this.getDocument(editor).getLineOffset(line) + offset, 0, text);
                }
                catch (BadLocationException e) {
                    throw new WorkbenchLayerException("Provided line or offset are invalid for this editor", e);
                }
            }
        });
    }

    public void insertText(final ITextEditor editor, final int offset, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TextEditorHandler.this.getDocument(editor).replace(offset, 0, text);
                }
                catch (BadLocationException e) {
                    throw new WorkbenchLayerException("Provided offset is invalid for this editor", e);
                }
            }
        });
    }

    public String getSelectedText(final ITextEditor editor) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                ISelection selection = editor.getSelectionProvider().getSelection();
                if (selection instanceof ITextSelection) {
                    return ((ITextSelection)selection).getText();
                }
                if (selection instanceof IBlockTextSelection) {
                    return ((IBlockTextSelection)selection).getText();
                }
                throw new WorkbenchLayerException("Unsuported ISelection type.");
            }
        });
    }

    public int getLineOfText(final ITextEditor editor, final String text, final int textIndex) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                int textOffset = TextEditorHandler.this.getPositionOfText(editor, text, textIndex);
                int line = -1;
                try {
                    line = TextEditorHandler.this.getDocument(editor).getLineOfOffset(textOffset);
                }
                catch (BadLocationException badLocationException) {
                    line = -1;
                }
                return line;
            }
        });
    }

    public void selectLine(final ITextEditor editor, final int lineNumber) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                int offset = 0;
                int length = 0;
                try {
                    offset = TextEditorHandler.this.getDocument(editor).getLineOffset(lineNumber);
                    length = TextEditorHandler.this.getDocument(editor).getLineLength(lineNumber);
                }
                catch (BadLocationException e) {
                    throw new WorkbenchLayerException("Unable to select line " + lineNumber, e);
                }
                editor.selectAndReveal(offset, length);
            }
        });
    }

    public void selectText(final ITextEditor editor, final String text, final int textIndex) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                int offset;
                boolean found = false;
                int iStartIndex = 0;
                int iRow = 0;
                String editorText = TextEditorHandler.this.getDocument(editor).get();
                if (editorText != null && editorText.length() > 0 && editorText.contains(text)) {
                    int iOccurenceIndex = 0;
                    while (!found && iRow < TextEditorHandler.this.getNumberOfLines(editor)) {
                        String lineText = TextEditorHandler.this.getTextAtLine(editor, iRow);
                        System.out.println(lineText);
                        iStartIndex = 0;
                        while (!found && lineText.contains(text)) {
                            if (iOccurenceIndex == textIndex) {
                                found = true;
                                iStartIndex += lineText.indexOf(text);
                                continue;
                            }
                            ++iOccurenceIndex;
                            int iNewStartIndex = lineText.indexOf(text) + text.length();
                            iStartIndex += iNewStartIndex;
                            lineText = lineText.substring(iNewStartIndex);
                        }
                        if (found) continue;
                        ++iRow;
                    }
                }
                if (found) {
                    offset = 0;
                    try {
                        offset = TextEditorHandler.this.getDocument(editor).getLineOffset(iRow) + iStartIndex;
                    }
                    catch (BadLocationException e) {
                        throw new WorkbenchLayerException("Unable to find " + text + " in editor", e);
                    }
                } else {
                    throw new WorkbenchLayerException("Unable to find " + text + " in editor");
                }
                editor.selectAndReveal(offset, text.length());
            }
        });
    }

    public int getPositionOfText(ITextEditor editor, String text) {
        return this.getPositionOfText(editor, text, 0);
    }

    public int getPositionOfText(final ITextEditor editor, final String text, final int index) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                if (index < 0) {
                    return -1;
                }
                String doc = TextEditorHandler.this.getDocument(editor).get();
                int textIndex = 0;
                int i = 0;
                while (i <= index) {
                    ++i;
                    if ((textIndex = doc.indexOf(text, textIndex)) == -1) {
                        return -1;
                    }
                    textIndex += text.length();
                }
                return textIndex - text.length();
            }
        });
    }

    public void setCursorPosition(final ITextEditor editor, final int line, final int column) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                int lineOffset = 0;
                try {
                    lineOffset = TextEditorHandler.this.getDocument(editor).getLineOffset(line);
                }
                catch (BadLocationException badLocationException) {
                    throw new WorkbenchLayerException("Unable to select line" + line + " and column " + column);
                }
                editor.selectAndReveal(lineOffset + column, 0);
            }
        });
    }

    public Point getCursorPosition(final ITextEditor editor) {
        Integer offset = (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                ISelection selection = editor.getSelectionProvider().getSelection();
                if (selection instanceof ITextSelection) {
                    return ((ITextSelection)selection).getOffset();
                }
                throw new WorkbenchLayerException("Unsuported ISelection type.");
            }
        });
        int line = this.getLineOfOffest(editor, offset);
        int column = offset - this.getLineOffset(editor, line);
        return new Point(line, column);
    }

    public void setCursorPosition(final ITextEditor editor, final int offset) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                editor.selectAndReveal(offset, 0);
            }
        });
    }

    public int getLineOffset(final ITextEditor editor, final int line) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                try {
                    return TextEditorHandler.this.getDocument(editor).getLineOffset(line);
                }
                catch (BadLocationException badLocationException) {
                    throw new WorkbenchLayerException("Unable to get offset of line");
                }
            }
        });
    }

    public int getLineOfOffest(final ITextEditor editor, final int offset) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                try {
                    return TextEditorHandler.this.getDocument(editor).getLineOfOffset(offset);
                }
                catch (BadLocationException badLocationException) {
                    throw new WorkbenchLayerException("Unable to get line of offset");
                }
            }
        });
    }

    public IDocument getDocument(ITextEditor editor) {
        return editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }
}

