/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstNodeFactory;

public abstract class AbstractAstBuilder<INSTANCE extends AbstractAstBuilder<INSTANCE>> {
    private final AstNodeFactory m_owner;
    private final Set<Modifier.ModifierKeyword> m_modifiers;
    private final INSTANCE m_return;
    private boolean m_createLinks;
    private TypeDeclaration m_declaringType;

    protected AbstractAstBuilder(AstNodeFactory owner) {
        this.m_owner = (AstNodeFactory)Validate.notNull((Object)owner);
        this.m_modifiers = new LinkedHashSet<Modifier.ModifierKeyword>();
        this.m_return = this;
        this.m_createLinks = true;
    }

    public INSTANCE withCreateLinks(boolean createLinks) {
        this.m_createLinks = createLinks;
        return this.m_return;
    }

    public INSTANCE withModifiers(Modifier.ModifierKeyword ... keywords) {
        if (keywords == null || keywords.length < 1) {
            return (INSTANCE)this;
        }
        Modifier.ModifierKeyword[] modifierKeywordArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            Modifier.ModifierKeyword keyword = modifierKeywordArray[n2];
            this.m_modifiers.add(keyword);
            ++n2;
        }
        return this.m_return;
    }

    public INSTANCE in(TypeDeclaration declaringType) {
        this.m_declaringType = declaringType;
        return this.m_return;
    }

    public AstNodeFactory getFactory() {
        return this.m_owner;
    }

    public boolean isCreateLinks() {
        return this.m_createLinks;
    }

    protected Set<Modifier.ModifierKeyword> getModifiers() {
        return this.m_modifiers;
    }

    protected TypeDeclaration getDeclaringType() {
        return this.m_declaringType;
    }

    public abstract INSTANCE insert() throws CoreException;
}

