/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal.quickfilter;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tcf.te.core.interfaces.IFilterable;
import org.eclipse.tcf.te.ui.utils.TreeViewerUtil;

public class QuickFilterTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof TreeViewer) {
            TreeViewer viewer = (TreeViewer)receiver;
            if (property.equals("isFilterable")) {
                return this.isFilterable(viewer);
            }
            if (property.equals("isFiltering")) {
                return TreeViewerUtil.isFiltering((TreeViewer)viewer);
            }
        }
        return false;
    }

    private boolean isFilterable(TreeViewer viewer) {
        TreePath[] paths;
        TreePath path;
        Object element;
        TreeSelection selection;
        ISelection obj = viewer.getSelection();
        if (!obj.isEmpty() && obj instanceof TreeSelection && (selection = (TreeSelection)obj).size() == 1 && (element = (path = (paths = selection.getPaths())[0]).getLastSegment()) != null && this.adaptFilterable(element) != null) {
            return this.isEligible(path, viewer);
        }
        return false;
    }

    private boolean isEligible(TreePath root, TreeViewer viewer) {
        if (viewer.getExpandedState((Object)root)) {
            return this.hasChildren(root, viewer);
        }
        return false;
    }

    private boolean hasChildren(TreePath root, TreeViewer viewer) {
        Object rootElement;
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        Object[] children = contentProvider.getChildren(rootElement = root.getLastSegment());
        if (children != null && children.length > 0) {
            ViewerFilter[] filters = viewer.getFilters();
            if (filters != null && filters.length > 0) {
                ViewerFilter[] viewerFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter filter = viewerFilterArray[n2];
                    if ((children = filter.filter((Viewer)viewer, rootElement, children)) == null || children.length == 0) break;
                    ++n2;
                }
            }
            return children != null && children.length > 0;
        }
        return false;
    }

    private IFilterable adaptFilterable(Object element) {
        IFilterable decorator = null;
        if (element instanceof IFilterable) {
            decorator = (IFilterable)element;
        }
        if (decorator == null && element instanceof IAdaptable) {
            decorator = (IFilterable)((IAdaptable)element).getAdapter(IFilterable.class);
        }
        if (decorator == null) {
            decorator = (IFilterable)Platform.getAdapterManager().getAdapter(element, IFilterable.class);
        }
        return decorator;
    }
}

