/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.colors;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;

public final class ColorUtils {
    private static final String HEX_COLOR_FORMAT = "#%02x%02x%02x";
    private static final String HEX_COLOR_REGEX = "#[A-Fa-f0-9]{6}";

    private ColorUtils() {
    }

    public static RGB fromHexColor(String color) {
        if (color != null && color.matches(HEX_COLOR_REGEX)) {
            return new RGB(Integer.valueOf(color.substring(1, 3), 16).intValue(), Integer.valueOf(color.substring(3, 5), 16).intValue(), Integer.valueOf(color.substring(5, 7), 16).intValue());
        }
        return null;
    }

    public static @NonNull String toHexColor(RGB rgb) {
        int r = rgb.red;
        int g = rgb.green;
        int b = rgb.blue;
        return String.format(HEX_COLOR_FORMAT, r, g, b);
    }

    public static @NonNull String toHexColor(int red, int green, int blue) {
        return String.format(HEX_COLOR_FORMAT, Math.abs(red % 256), Math.abs(green % 256), Math.abs(blue % 256));
    }

    public static RGB fromX11Color(String x11ColorName) {
        return x11ColorName == null ? null : ColorUtils.fromHexColor(X11ColorUtils.toHexColor((String)x11ColorName));
    }
}

