/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import java.util.List;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.XmlObjectMemento;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.swt.support.TableSupport;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.TableColumnInfo;
import org.eclipse.wb.internal.xwt.model.widgets.TableItemInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableInfo
extends CompositeInfo {
    public TableInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.contributeToClipboardCopy();
    }

    private void contributeToClipboardCopy() {
        this.addBroadcastListener(new XmlObjectClipboardCopy(){

            public void invoke(XmlObjectInfo object, List<ClipboardCommand> commands) throws Exception {
                if (object == TableInfo.this) {
                    for (TableColumnInfo column : TableInfo.this.getColumns()) {
                        final XmlObjectMemento columnMemento = XmlObjectMemento.createMemento((XmlObjectInfo)column);
                        commands.add(new ClipboardCommand(){
                            private static final long serialVersionUID = 0L;

                            public void execute(XmlObjectInfo object) throws Exception {
                                XmlObjectInfo column = columnMemento.create(object);
                                XmlObjectUtils.add((XmlObjectInfo)column, (Association)Associations.direct(), (XmlObjectInfo)object, null);
                                columnMemento.apply();
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        Object table = this.getObject();
        int headerHeight = TableSupport.getHeaderHeight((Object)table);
        int itemHeight = TableSupport.getItemHeight((Object)table);
        int x = 0;
        for (TableColumnInfo column : this.getColumns()) {
            int columnWidth = ((TableColumn)column.getObject()).getWidth();
            int y = 0;
            if (EnvironmentUtils.IS_MAC_COCOA) {
                y -= headerHeight;
            }
            column.setModelBounds(new Rectangle(x, y, columnWidth, headerHeight));
            x += columnWidth;
        }
        int y = headerHeight;
        int width = this.getClientArea().width;
        for (TableItemInfo item : this.getItems()) {
            item.setModelBounds(new Rectangle(0, y, width, itemHeight));
            y += itemHeight;
        }
    }

    public List<TableColumnInfo> getColumns() {
        return this.getChildren(TableColumnInfo.class);
    }

    public List<TableItemInfo> getItems() {
        return this.getChildren(TableItemInfo.class);
    }
}

