/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public class NodeUtil {
    public static File findNodeSystemPath() {
        File nodeFile = null;
        boolean isWindows = true;
        ArrayList<String> cmdLine = new ArrayList<String>();
        if (Platform.getOS().startsWith("win")) {
            cmdLine.add("cmd");
            cmdLine.add("/c");
            cmdLine.add("where");
        } else {
            isWindows = false;
            cmdLine.add("/usr/bin/which");
        }
        cmdLine.add("node");
        String output = NodeUtil.executeCmd(cmdLine);
        if (!isWindows && output.equals("")) {
            cmdLine.remove(0);
            cmdLine.add(0, "/bin/which");
            output = NodeUtil.executeCmd(cmdLine);
            if (output.equals("")) {
                cmdLine.remove(0);
                cmdLine.add(0, "/usr/local/bin/which");
                output = NodeUtil.executeCmd(cmdLine);
            }
        }
        if (output.equals("")) {
            String nodeFileName = "node";
            if (isWindows) {
                nodeFileName = "node.exe";
            }
            String path = System.getenv("PATH");
            String[] paths = path.split(File.pathSeparator, 0);
            ArrayList<String> directories = new ArrayList<String>();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                directories.add(p);
                ++n2;
            }
            if (!isWindows) {
                directories.add("/usr/local/bin");
            }
            boolean notFound = true;
            Iterator it = directories.iterator();
            while (notFound && it.hasNext()) {
                String directory = (String)it.next();
                File tempFile = new File(directory, nodeFileName);
                if (!tempFile.exists()) continue;
                notFound = false;
                nodeFile = tempFile;
            }
            return nodeFile;
        }
        nodeFile = new File(output);
        return nodeFile;
    }

    private static String executeCmd(List<String> commands) {
        String output = "";
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
            int exit = process.waitFor();
            if (exit == 0) {
                output = buffer.readLine();
            }
        }
        catch (Exception exception) {}
        return output;
    }
}

