/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.wizards;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewBpelFileLocationPage
extends WizardNewFileCreationPage {
    public static final String PAGE_NAME = "location-page";
    private IContainer resourceContainer;

    public NewBpelFileLocationPage(IStructuredSelection selection) {
        super(PAGE_NAME, selection);
        this.setTitle(Messages.NewFileWizardPage2_3);
        this.setDescription(Messages.NewFileWizardPage2_0);
        this.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("wizban/new_bpel.gif"));
        this.setFileExtension("bpel");
        this.setAllowExistingResources(false);
    }

    public void setVisible(boolean visible) {
        String pName = this.getWizard().getDialogSettings().get("process-name");
        if (pName != null) {
            this.setFileName(String.valueOf(pName) + ".bpel");
        }
        super.setVisible(visible);
    }

    public IContainer getResourceContainer() {
        return this.resourceContainer;
    }

    public IFile getProcessFile() {
        return this.resourceContainer.getFile((IPath)new Path(this.getFileName()));
    }

    protected boolean validatePage() {
        this.setMessage(null, 2);
        boolean valid = super.validatePage();
        if (valid) {
            IPath path = this.getContainerFullPath();
            this.resourceContainer = path.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
            if (!BPELUtil.isBPELProject(this.resourceContainer.getProject())) {
                this.setMessage(Messages.NewFileWizard_Not_A_BPELFaceted_Project, 2);
                valid = true;
            } else if (!this.resourceContainer.equals((Object)BPELUtil.getBPELContentFolder(this.resourceContainer.getProject()))) {
                this.setMessage(Messages.NewFileWizard_Not_A_BPELContent_Folder, 2);
                valid = true;
            }
        }
        return valid;
    }
}

