/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.ui.properties.AbstractConfigurePropertyOptionsPage;
import org.eclipse.cdt.internal.autotools.ui.properties.AutotoolsPropertyMessages;
import org.eclipse.cdt.internal.autotools.ui.properties.ToolListElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AutotoolsCategoryPropertyOptionPage
extends AbstractConfigurePropertyOptionsPage {
    private static final int MARGIN = 3;
    private String catName = "";
    private IAConfiguration cfg;
    private List<FieldEditor> fieldEditors;

    public AutotoolsCategoryPropertyOptionPage(ToolListElement element, IAConfiguration cfg) {
        super(element.getName());
        this.catName = element.getName();
        this.cfg = cfg;
        this.fieldEditors = new ArrayList<FieldEditor>();
    }

    @Override
    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginTop = 3;
        gl.marginLeft = 3;
        gl.marginRight = 3;
        area.setLayout((Layout)gl);
        area.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        AutotoolsConfiguration.Option[] options = AutotoolsConfiguration.getChildOptions((String)this.catName);
        int i = 0;
        while (i < options.length) {
            AutotoolsConfiguration.Option option = options[i];
            switch (option.getType()) {
                case 2: 
                case 3: 
                case 4: {
                    StringFieldEditor f = new StringFieldEditor(option.getName(), option.getDescription(), area);
                    f.getLabelControl(area).setToolTipText(option.getToolTip());
                    this.addField((FieldEditor)f);
                    this.fieldEditors.add((FieldEditor)f);
                    break;
                }
                case 1: 
                case 7: {
                    BooleanFieldEditor b = new BooleanFieldEditor(option.getName(), option.getDescription(), area);
                    b.getDescriptionControl(area).setToolTipText(option.getToolTip());
                    this.addField((FieldEditor)b);
                    this.fieldEditors.add((FieldEditor)b);
                    break;
                }
                case 6: {
                    LabelFieldEditor l = new LabelFieldEditor(area, option.getDescription());
                    this.addField(l);
                    this.fieldEditors.add(l);
                    break;
                }
                case 8: {
                    VariableListEditor listEditor = new VariableListEditor(option.getName(), option.getDescription(), area);
                    listEditor.setToolTipText(option.getToolTip());
                    this.addField((FieldEditor)listEditor);
                    this.fieldEditors.add((FieldEditor)listEditor);
                }
            }
            ++i;
        }
    }

    @Override
    public void updateFields() {
        this.setValues();
    }

    @Override
    public void setValues() {
        int i = 0;
        while (i < this.fieldEditors.size()) {
            this.fieldEditors.get(i).load();
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() instanceof StringFieldEditor) {
            StringFieldEditor f = (StringFieldEditor)event.getSource();
            this.cfg.setOption(f.getPreferenceName(), f.getStringValue());
        } else if (event.getSource() instanceof BooleanFieldEditor) {
            BooleanFieldEditor b = (BooleanFieldEditor)event.getSource();
            this.cfg.setOption(b.getPreferenceName(), Boolean.toString(b.getBooleanValue()));
        } else if (event.getSource() instanceof VariableListEditor) {
            VariableListEditor v = (VariableListEditor)((Object)event.getSource());
            this.cfg.setOption(v.getPreferenceName(), v.getVariablesValue());
        }
    }

    static class LabelFieldEditor
    extends FieldEditor {
        private String fTitle;
        private Label fTitleLabel;

        public LabelFieldEditor(Composite parent, String title) {
            this.fTitle = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.fTitleLabel.getLayoutData()).horizontalSpan = 2;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.fTitleLabel = new Label(parent, 64);
            this.fTitleLabel.setText(this.fTitle);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalSpan = 2;
            this.fTitleLabel.setLayoutData((Object)gd);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }

    static class VariableListEditor
    extends ListEditor {
        Composite fParent;
        String fName;
        String fLabelText;
        boolean isLoaded;

        public VariableListEditor(String name, String labelText, Composite parent) {
            this.fName = name;
            this.fLabelText = labelText;
            this.fParent = parent;
            this.isLoaded = false;
            this.init(this.fName, this.fLabelText);
            this.createControl(this.fParent);
        }

        protected void selectionChanged() {
            super.selectionChanged();
            super.fireValueChanged(this.getPreferenceName(), (Object)"", (Object)"");
        }

        protected String createList(String[] arg0) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = arg0;
            int n = arg0.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                sb.append(item);
                sb.append("\\s");
                ++n2;
            }
            return sb.toString();
        }

        protected void doLoad() {
            if (!this.isLoaded) {
                super.doLoad();
                this.isLoaded = true;
            }
        }

        public void setToolTipText(String toolTip) {
            this.getLabelControl().setToolTipText(toolTip);
        }

        protected String getNewInputObject() {
            DialogNewVar newDialog = new DialogNewVar(this.getShell());
            newDialog.open();
            String name = newDialog.getName();
            if (name != null) {
                String quote = "\"";
                StringBuilder sb = new StringBuilder(name.trim());
                sb.append("=");
                String value = newDialog.getValue();
                if (value != null) {
                    if ((value = value.trim()).length() == 0) {
                        sb.append(quote);
                        sb.append(quote);
                    } else if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        sb.append(value);
                    } else {
                        sb.append(quote);
                        sb.append(value);
                        sb.append(quote);
                    }
                }
                return sb.toString();
            }
            return null;
        }

        protected String[] parseString(String str) {
            if (str == null) {
                return new String[0];
            }
            ArrayList<String> variables = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            int quote = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                sb.append(c);
                if (c == '\"') {
                    ++quote;
                }
                if (quote == 2) {
                    quote = 0;
                    variables.add(sb.toString());
                    sb.delete(0, sb.length());
                    ++i;
                }
                ++i;
            }
            return variables.toArray(new String[0]);
        }

        public String getVariablesValue() {
            org.eclipse.swt.widgets.List list = super.getList();
            StringBuilder sb = new StringBuilder();
            String[] stringArray = list.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                sb.append(var);
                sb.append(" ");
                ++n2;
            }
            return sb.toString().trim();
        }

        class DialogNewVar
        extends Dialog {
            private String name;
            private Text fTextName;
            private String value;
            private Text fTextValue;
            private Button fOkButton;

            public DialogNewVar(Shell shell) {
                super(shell);
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(AutotoolsPropertyMessages.getString("NewEnvVarDialog.title"));
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginWidth = 5;
                layout.numColumns = 2;
                composite.setLayout((Layout)layout);
                GC gc = new GC((Drawable)composite);
                gc.setFont(composite.getFont());
                FontMetrics metrics = gc.getFontMetrics();
                gc.dispose();
                int fieldWidthHint = DialogNewVar.convertWidthInCharsToPixels((FontMetrics)metrics, (int)50);
                Label label = new Label(composite, 0);
                label.setText(AutotoolsPropertyMessages.getString("NewEnvVarDialog.name_field"));
                this.fTextName = new Text(composite, 2052);
                GridData gd = new GridData(1808);
                gd.grabExcessHorizontalSpace = true;
                gd.widthHint = fieldWidthHint;
                this.fTextName.setLayoutData((Object)gd);
                this.fTextName.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (DialogNewVar.this.fOkButton != null) {
                            DialogNewVar.this.fOkButton.setEnabled(DialogNewVar.this.fTextName.getText().length() > 0);
                        }
                    }
                });
                label = new Label(composite, 0);
                label.setText(AutotoolsPropertyMessages.getString("NewEnvVarDialog.value_field"));
                this.fTextValue = new Text(composite, 2052);
                gd = new GridData(1808);
                gd.grabExcessHorizontalSpace = true;
                gd.widthHint = fieldWidthHint;
                this.fTextValue.setLayoutData((Object)gd);
                return composite;
            }

            protected Control createButtonBar(Composite parent) {
                Control control = super.createButtonBar(parent);
                this.fOkButton = this.getButton(0);
                this.fOkButton.setEnabled(false);
                return control;
            }

            protected void okPressed() {
                this.name = this.fTextName.getText().trim();
                this.value = this.fTextValue.getText();
                this.value = this.value != null ? this.value.trim() : "";
                super.okPressed();
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }
        }
    }
}

