/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.contexts;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.contexts.ISuspendTriggerListener;

@ConfinedToDsfExecutor(value="fSession.getExecutor()")
public class DsfSuspendTrigger
implements ISuspendTrigger {
    private final DsfSession fSession;
    private final ILaunch fLaunch;
    private volatile boolean fDisposed = false;
    private boolean fEventListenerRegisterd = false;
    private final DsfServicesTracker fServicesTracker;
    @ThreadSafe
    private final ListenerList<ISuspendTriggerListener> fListeners = new ListenerList();

    @ThreadSafe
    public DsfSuspendTrigger(DsfSession session, ILaunch launch) {
        this.fSession = session;
        this.fLaunch = launch;
        this.fServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), this.fSession.getId());
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (!DsfSuspendTrigger.this.fDisposed) {
                        DsfSuspendTrigger.this.fSession.addServiceEventListener((Object)DsfSuspendTrigger.this, null);
                        DsfSuspendTrigger.this.fEventListenerRegisterd = true;
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @ThreadSafe
    public void addSuspendTriggerListener(final ISuspendTriggerListener listener) {
        this.fListeners.add((Object)listener);
        this.getIsLaunchSuspended(new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), null){

            protected void handleSuccess() {
                if (!DsfSuspendTrigger.this.fDisposed && ((Boolean)this.getData()).booleanValue()) {
                    listener.suspended(DsfSuspendTrigger.this.fLaunch, null);
                }
            }

            protected void handleErrorOrWarning() {
                if (this.getStatus().getCode() > 10003) {
                    super.handleErrorOrWarning();
                }
            }
        });
    }

    @ThreadSafe
    public void removeSuspendTriggerListener(ISuspendTriggerListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @ThreadSafe
    public void dispose() {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (DsfSuspendTrigger.this.fEventListenerRegisterd) {
                        DsfSuspendTrigger.this.fSession.removeServiceEventListener((Object)DsfSuspendTrigger.this);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.fServicesTracker.dispose();
        this.fDisposed = true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fireSuspended(null);
    }

    @DsfServiceEventHandler
    public void eventDispatched(DataModelInitializedEvent e) {
        this.getIsLaunchSuspended(new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), null){

            protected void handleSuccess() {
                if (!DsfSuspendTrigger.this.fDisposed && ((Boolean)this.getData()).booleanValue()) {
                    DsfSuspendTrigger.this.fireSuspended(null);
                }
            }

            protected void handleErrorOrWarning() {
                if (this.getStatus().getCode() > 10003) {
                    super.handleErrorOrWarning();
                }
            }
        });
    }

    protected DsfServicesTracker getServicesTracker() {
        return this.fServicesTracker;
    }

    @ThreadSafe
    protected ILaunch getLaunch() {
        return this.fLaunch;
    }

    @ThreadSafe
    protected DsfSession getSession() {
        return this.fSession;
    }

    @ThreadSafe
    protected void fireSuspended(final Object context) {
        if (!this.fListeners.isEmpty()) {
            new Job("DSF Suspend Trigger Notify"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    final MultiStatus status = new MultiStatus("org.eclipse.cdt.dsf.ui", 0, "DSF Suspend Trigger Notify Job Status", null);
                    for (final ISuspendTriggerListener listener : DsfSuspendTrigger.this.fListeners) {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                listener.suspended(DsfSuspendTrigger.this.fLaunch, context);
                            }

                            public void handleException(Throwable exception) {
                                status.add((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", "Exception while calling suspend trigger listeners", exception));
                            }
                        });
                    }
                    return status;
                }
            }.schedule();
        }
    }

    @ThreadSafe
    protected void getLaunchTopContainers(DataRequestMonitor<IRunControl.IContainerDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "Not implemented.", null));
        rm.done();
    }

    @ThreadSafe
    private void getIsLaunchSuspended(final DataRequestMonitor<Boolean> rm) {
        this.getLaunchTopContainers(new DataRequestMonitor<IRunControl.IContainerDMContext[]>((Executor)this.fSession.getExecutor(), rm){

            protected void handleSuccess() {
                final CountingRequestMonitor crm = new CountingRequestMonitor((Executor)DsfSuspendTrigger.this.fSession.getExecutor(), (RequestMonitor)rm){

                    protected void handleSuccess() {
                        if (rm.getData() == null) {
                            rm.setData((Object)Boolean.FALSE);
                        }
                        rm.done();
                    }
                };
                int count = 0;
                IRunControl.IContainerDMContext[] iContainerDMContextArray = (IRunControl.IContainerDMContext[])this.getData();
                int n = iContainerDMContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IRunControl.IContainerDMContext containerCtx = iContainerDMContextArray[n2];
                    DsfSuspendTrigger.this.getIsContainerSuspended(containerCtx, (DataRequestMonitor<Boolean>)((DataRequestMonitor)new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                        protected void handleSuccess() {
                            if (((Boolean)this.getData()).booleanValue()) {
                                rm.setData((Object)Boolean.TRUE);
                            }
                            crm.done();
                        }
                    }));
                    ++count;
                    ++n2;
                }
                crm.setDoneCount(count);
            }
        });
    }

    @ConfinedToDsfExecutor(value="fSession.getExecutor()")
    private void getIsContainerSuspended(IRunControl.IContainerDMContext container, final DataRequestMonitor<Boolean> rm) {
        IRunControl rc = (IRunControl)this.fServicesTracker.getService(IRunControl.class);
        if (rc == null) {
            rm.setData((Object)Boolean.FALSE);
            rm.done();
            return;
        }
        if (rc.isSuspended((IRunControl.IExecutionDMContext)container)) {
            rm.setData((Object)Boolean.TRUE);
            rm.done();
            return;
        }
        rc.getExecutionContexts(container, (DataRequestMonitor)new DataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.fSession.getExecutor(), rm){

            protected void handleSuccess() {
                IRunControl rc = (IRunControl)DsfSuspendTrigger.this.fServicesTracker.getService(IRunControl.class);
                if (rc == null) {
                    rm.setData((Object)Boolean.FALSE);
                    rm.done();
                    return;
                }
                boolean hasContainers = false;
                IRunControl.IExecutionDMContext[] iExecutionDMContextArray = (IRunControl.IExecutionDMContext[])this.getData();
                int n = iExecutionDMContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IRunControl.IExecutionDMContext execCtx = iExecutionDMContextArray[n2];
                    if (rc.isSuspended(execCtx)) {
                        rm.setData((Object)Boolean.TRUE);
                        rm.done();
                        return;
                    }
                    hasContainers = hasContainers || execCtx instanceof IRunControl.IContainerDMContext;
                    ++n2;
                }
                if (hasContainers) {
                    final CountingRequestMonitor crm = new CountingRequestMonitor((Executor)DsfSuspendTrigger.this.fSession.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            if (rm.getData() == null) {
                                rm.setData((Object)Boolean.FALSE);
                            }
                            rm.done();
                        }
                    };
                    int count = 0;
                    IRunControl.IExecutionDMContext[] iExecutionDMContextArray2 = (IRunControl.IExecutionDMContext[])this.getData();
                    int n3 = iExecutionDMContextArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IRunControl.IExecutionDMContext execCtx = iExecutionDMContextArray2[n4];
                        if (execCtx instanceof IRunControl.IContainerDMContext) {
                            DsfSuspendTrigger.this.getIsContainerSuspended((IRunControl.IContainerDMContext)execCtx, (DataRequestMonitor<Boolean>)((DataRequestMonitor)new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                                protected void handleSuccess() {
                                    if (((Boolean)this.getData()).booleanValue()) {
                                        rm.setData((Object)Boolean.TRUE);
                                    }
                                    crm.done();
                                }
                            }));
                            ++count;
                        }
                        ++n4;
                    }
                    crm.setDoneCount(count);
                } else {
                    rm.setData((Object)Boolean.FALSE);
                    rm.done();
                }
            }
        });
    }
}

