/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.editor;

import java.io.File;
import javax.script.ScriptException;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.qt.ui.actions.OpenDeclarationsAction;
import org.eclipse.cdt.internal.qt.ui.editor.QMLSourceViewerConfiguration;
import org.eclipse.cdt.qt.core.IQMLAnalyzer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class QMLEditor
extends TextEditor {
    public static final String EDITOR_ID = "org.eclipse.cdt.qt.ui.QMLEditor";
    public static final String BRACKET_MATCHING_COLOR_PREFERENCE = "org.eclipse.cdt.qt.ui.qmlMatchingBracketsColor";
    private static final String BRACKET_MATCHING_PREFERENCE = "org.eclipse.cdt.qt.ui.qmlMatchingBrackets";
    private static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    private final IQMLAnalyzer analyzer = Activator.getService(IQMLAnalyzer.class);

    protected void initializeEditor() {
        super.initializeEditor();
        ChainedPreferenceStore prefStore = new ChainedPreferenceStore(new IPreferenceStore[]{Activator.getDefault().getPreferenceStore(), CUIPlugin.getDefault().getPreferenceStore(), CUIPlugin.getDefault().getCorePreferenceStore(), EditorsUI.getPreferenceStore()});
        this.setPreferenceStore((IPreferenceStore)prefStore);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new QMLSourceViewerConfiguration(this, (IPreferenceStore)prefStore));
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        ((QMLSourceViewerConfiguration)this.getSourceViewerConfiguration()).handlePreferenceStoreChanged(event);
        super.handlePreferenceStoreChanged(event);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (((QMLSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event)) {
            return true;
        }
        return super.affectsTextPresentation(event);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IFileEditorInput fileInput = (IFileEditorInput)this.getEditorInput();
        String fileName = new File(fileInput.getFile().getLocationURI()).getAbsolutePath();
        IDocument document = this.getSourceViewer().getDocument();
        try {
            this.analyzer.deleteFile(fileName);
            this.analyzer.addFile(fileName, document.get());
        }
        catch (NoSuchMethodException e) {
            Activator.log(e);
        }
        catch (ScriptException e) {
            Activator.log(e);
        }
        super.doSave(progressMonitor);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        DefaultCharacterPairMatcher matcher = new DefaultCharacterPairMatcher(BRACKETS, "__dftl_partitioning");
        support.setCharacterPairMatcher((ICharacterPairMatcher)matcher);
        support.setMatchingCharacterPainterPreferenceKeys(BRACKET_MATCHING_PREFERENCE, BRACKET_MATCHING_COLOR_PREFERENCE);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setDefault(BRACKET_MATCHING_PREFERENCE, true);
        store.setDefault(BRACKET_MATCHING_COLOR_PREFERENCE, "155,155,155");
    }

    protected void createActions() {
        super.createActions();
        OpenDeclarationsAction action = new OpenDeclarationsAction();
        action.setActionDefinitionId("org.eclipse.cdt.qml.edit.opendecl");
        this.setAction("OpenDeclarations", (IAction)action);
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (--pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

