/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugDelegate;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryProperties;
import org.eclipse.cft.server.core.internal.debug.DebugConnectionDescriptor;
import org.eclipse.cft.server.core.internal.debug.NgrokDebugProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.server.core.IModule;

public class NgrokDebugLaunchConfigDelegate
extends CloudFoundryDebugDelegate {
    public static final String LAUNCH_CONFIGURATION_ID = "org.eclipse.cft.debug.launchconfig.ngrok";
    private static final Pattern NGROK_OUTPUT_FILE = Pattern.compile(".*ngrok\\.txt");

    @Override
    public String getLaunchConfigurationTypeId() {
        return LAUNCH_CONFIGURATION_ID;
    }

    protected EnvironmentVariable getDebugEnvironment(ApplicationDeploymentInfo info) {
        List<EnvironmentVariable> vars = info.getEnvVariables();
        for (EnvironmentVariable var : vars) {
            if (!"JAVA_OPTS".equals(var.getVariable())) continue;
            return var;
        }
        return null;
    }

    public boolean configureApp(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int instance, int debugPort, IProgressMonitor monitor) throws CoreException {
        ApplicationDeploymentInfo info = appModule.getDeploymentInfo();
        List<EnvironmentVariable> vars = info.getEnvVariables();
        EnvironmentVariable javaOpts = this.getDebugEnvironment(info);
        IModule[] mod = new IModule[]{appModule.getLocalModule()};
        boolean restart = CloudFoundryProperties.isModuleStopped.testProperty(mod, cloudServer);
        if (!NgrokDebugProvider.containsDebugOption(javaOpts)) {
            if (javaOpts == null) {
                javaOpts = new EnvironmentVariable();
                javaOpts.setVariable("JAVA_OPTS");
                vars.add(javaOpts);
            }
            String value = javaOpts.getValue();
            String debugOpts = "-Xdebug -Xrunjdwp:server=y,transport=dt_socket,address=4000,suspend=n";
            value = value == null ? debugOpts : String.valueOf(value) + ' ' + debugOpts;
            javaOpts.setValue(value);
            cloudServer.getBehaviour().operations().environmentVariablesUpdate(appModule.getLocalModule(), appModule.getDeployedApplicationName(), vars).run(monitor);
            restart = true;
        }
        if (restart) {
            cloudServer.getBehaviour().operations().applicationDeployment(mod, ApplicationAction.START, false).run(monitor);
        }
        return true;
    }

    @Override
    protected DebugConnectionDescriptor getDebugConnectionDescriptor(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance, int remoteDebugPort, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFile ngrokFile = NgrokDebugProvider.getFile((IResource)appModule.getLocalModule().getProject(), ".profile.d", "ngrok.sh");
        String remoteNgrokOutputFile = null;
        if (ngrokFile != null && ngrokFile.getRawLocation() != null) {
            try {
                Matcher matcher;
                String[] segments;
                StringWriter writer = new StringWriter();
                try (FileReader reader = new FileReader(new File(ngrokFile.getRawLocation().toString()));){
                    IOUtils.copy((Reader)reader, (Writer)writer);
                }
                String fileContents = writer.toString();
                if (fileContents != null && (segments = fileContents.split(">")).length >= 2 && (matcher = NGROK_OUTPUT_FILE.matcher(segments[1])).find() && (remoteNgrokOutputFile = segments[1].substring(matcher.start(), matcher.end())) != null) {
                    remoteNgrokOutputFile = remoteNgrokOutputFile.trim();
                }
            }
            catch (FileNotFoundException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
            catch (IOException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
        }
        if (remoteNgrokOutputFile == null) {
            String errorMessage = "Unable to connect the debugger. Failed to resolve a path to an output ngrok.txt file from the local ngrok.sh file. Please ensure the shell script file exists in your project and is in the project's classpath. Also please ensure that the script includes a command for the ngrok executable running on the Cloud to generate output to an ngrok.txt.";
            throw CloudErrorUtil.toCoreException(errorMessage);
        }
        this.configureApp(appModule, cloudServer, appInstance, remoteDebugPort, (IProgressMonitor)subMonitor);
        String fileContent = NgrokDebugProvider.getFileContent(appModule, cloudServer, remoteNgrokOutputFile, (IProgressMonitor)subMonitor);
        if (fileContent.indexOf("Tunnel established at tcp://ngrok.com:") > -1) {
            String pattern = "Tunnel established at tcp://ngrok.com:";
            int start = fileContent.indexOf(pattern);
            String sub = fileContent.substring(start);
            int end = sub.indexOf(10);
            int port = Integer.parseInt((sub = sub.substring(pattern.length(), end)).trim());
            DebugConnectionDescriptor descriptor = new DebugConnectionDescriptor("ngrok.com", port);
            if (!descriptor.isValid()) {
                throw CloudErrorUtil.toCoreException("Invalid port:" + descriptor.getPort() + " or ngrok server address: " + descriptor.getHost() + " parsed from ngrok output file in the Cloud.");
            }
            return descriptor;
        }
        throw CloudErrorUtil.toCoreException("Unable to parse port or ngrok server address from the ngrok output file in the Cloud for " + appModule.getDeployedApplicationName() + ". Please verify that ngrok executable is present in the application deployment and running in the Cloud");
    }
}

