/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.task.ITaskReporter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.builder.AbstractBuildContext;
import org.eclipse.dltk.internal.core.builder.BuildProblemReporter;

public class SourceModuleBuildContext
extends AbstractBuildContext {
    final IBuildState buildState;
    final BuildProblemReporter reporter;

    public SourceModuleBuildContext(IProblemFactory problemFactory, ISourceModule module, int buildType, IBuildState buildState) {
        super(module, buildType);
        this.buildState = buildState;
        IResource resource = module.getResource();
        this.reporter = resource != null ? new BuildProblemReporter(problemFactory, resource) : null;
    }

    @Override
    public IFileHandle getFileHandle() {
        return null;
    }

    @Override
    public IProblemReporter getProblemReporter() {
        return this.reporter;
    }

    @Override
    public ITaskReporter getTaskReporter() {
        return this.reporter;
    }

    @Override
    public void recordDependency(IPath dependency, int flags) {
        if (this.reporter != null) {
            this.buildState.recordDependency(this.reporter.resource.getFullPath(), dependency, flags);
        }
    }
}

