/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceID;
import org.eclipse.ecf.internal.discovery.DiscoveryPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class IServiceInfoServiceListener {
    private final ServiceTracker serviceTracker;
    static /* synthetic */ Class class$0;

    void logException(String message, Throwable t) {
        DiscoveryPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.discovery", message, t));
    }

    public IServiceInfoServiceListener(final IDiscoveryAdvertiser advertiser) {
        final BundleContext bundleContext = DiscoveryPlugin.getDefault().getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.discovery.IServiceInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.serviceTracker = new ServiceTracker(bundleContext, clazz, new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                IServiceInfo serviceInfo = (IServiceInfo)bundleContext.getService(reference);
                try {
                    advertiser.registerService(IServiceInfoServiceListener.this.convertToProviderSpecific(advertiser, serviceInfo));
                }
                catch (Exception e) {
                    IServiceInfoServiceListener.this.logException("Advertiser.registerService failed", e);
                }
                return serviceInfo;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                try {
                    advertiser.registerService(IServiceInfoServiceListener.this.convertToProviderSpecific(advertiser, (IServiceInfo)service));
                }
                catch (Exception e) {
                    IServiceInfoServiceListener.this.logException("Advertiser.modifiedService failed", e);
                }
            }

            public void removedService(ServiceReference reference, Object service) {
                try {
                    advertiser.unregisterService(IServiceInfoServiceListener.this.convertToProviderSpecific(advertiser, (IServiceInfo)service));
                }
                catch (Exception e) {
                    IServiceInfoServiceListener.this.logException("Advertiser.removedService failed", e);
                }
            }
        });
        this.serviceTracker.open();
    }

    private IServiceInfo convertToProviderSpecific(IDiscoveryAdvertiser advertiser, IServiceInfo genericInfo) {
        Namespace servicesNamespace = advertiser.getServicesNamespace();
        IServiceID genericServiceID = genericInfo.getServiceID();
        ServiceID specificServiceID = (ServiceID)servicesNamespace.createInstance(new Object[]{genericServiceID.getServiceTypeID().getName(), genericServiceID.getLocation()});
        IServiceTypeID serviceTypeID = specificServiceID.getServiceTypeID();
        return new ServiceInfo(genericServiceID.getLocation(), genericInfo.getServiceName(), serviceTypeID, genericInfo.getPriority(), genericInfo.getWeight(), genericInfo.getServiceProperties(), genericInfo.getTTL());
    }

    public void dispose() {
        this.serviceTracker.close();
    }
}

