/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.api;

import org.eclipse.core.runtime.Platform;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Updater;
import org.eclipse.eef.ide.ui.internal.widgets.EEFSectionLifecycleManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public class EEFTab {
    private EEFPage eefPage;
    private EEFSectionLifecycleManager lifecycleManager;
    private Updater updater;

    public EEFTab(EEFPage eefPage) {
        this.eefPage = eefPage;
        this.lifecycleManager = new EEFSectionLifecycleManager(eefPage);
    }

    public void createControls(Composite parent, IEEFFormContainer container) {
        EEFIdeUiPlugin.getPlugin().debug("EEFTab#createControls(...)");
        Composite composite = container.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.lifecycleManager.createControl(composite, container);
        parent.layout();
        this.updater = new Updater(this, container);
    }

    public void aboutToBeShown() {
        EEFIdeUiPlugin.getPlugin().debug("EEFTab#aboutToBeShown(...)");
        this.lifecycleManager.aboutToBeShown();
        this.updater.enable();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EEFIdeUiPlugin.getPlugin().debug("EEFTab#setInput(...)");
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
            Object object = iStructuredSelection.getFirstElement();
            Object inputObject = Platform.getAdapterManager().getAdapter(object, InputDescriptor.class);
            InputDescriptor input = (InputDescriptor)inputObject;
            if (input != null) {
                this.eefPage.getView().setInput(input);
            }
        }
    }

    public void refresh() {
        EEFIdeUiPlugin.getPlugin().debug("EEFTab#refresh(...)");
        this.lifecycleManager.refresh();
    }

    public void aboutToBeHidden() {
        EEFIdeUiPlugin.getPlugin().debug("EEFTab#aboutToBeHidden(...)");
        this.updater.disable();
        this.lifecycleManager.aboutToBeHidden();
    }

    public void dispose() {
        EEFIdeUiPlugin.getPlugin().debug("EEFTab#dispose(...)");
        this.lifecycleManager.dispose();
    }

    public EEFPage getEEFPage() {
        return this.eefPage;
    }
}

