/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public final class StoreThreadLocal {
    private static final ThreadLocal<InternalSession> SESSION = new InheritableThreadLocal<InternalSession>();
    private static final ThreadLocal<IStoreAccessor> ACCESSOR = new InheritableThreadLocal<IStoreAccessor>();
    private static final ThreadLocal<IStoreAccessor.CommitContext> COMMIT_CONTEXT = new InheritableThreadLocal<IStoreAccessor.CommitContext>();

    private StoreThreadLocal() {
    }

    public static void setSession(InternalSession session) {
        if (session == null) {
            SESSION.remove();
        } else {
            SESSION.set(session);
        }
        ACCESSOR.remove();
        COMMIT_CONTEXT.remove();
    }

    public static InternalSession getSession() throws NoSessionRegisteredException {
        InternalSession session = SESSION.get();
        if (session == null) {
            throw new NoSessionRegisteredException();
        }
        return session;
    }

    public static boolean hasSession() {
        return SESSION.get() != null;
    }

    public static void setAccessor(IStoreAccessor accessor) {
        if (accessor == null) {
            ACCESSOR.remove();
            SESSION.remove();
        } else {
            ACCESSOR.set(accessor);
            SESSION.set(accessor.getSession());
        }
    }

    public static IStoreAccessor getAccessor() throws NoSessionRegisteredException {
        IStoreAccessor accessor = ACCESSOR.get();
        if (accessor == null) {
            InternalSession session = StoreThreadLocal.getSession();
            IStore store = session.getManager().getRepository().getStore();
            accessor = store.getReader(session);
            ACCESSOR.set(accessor);
        }
        return accessor;
    }

    public static boolean hasAccessor() {
        return ACCESSOR.get() != null;
    }

    public static void setCommitContext(IStoreAccessor.CommitContext commitContext) {
        if (commitContext == null) {
            COMMIT_CONTEXT.remove();
        } else {
            COMMIT_CONTEXT.set(commitContext);
        }
    }

    public static IStoreAccessor.CommitContext getCommitContext() {
        return COMMIT_CONTEXT.get();
    }

    public static boolean hasCommitContext() {
        return COMMIT_CONTEXT.get() != null;
    }

    public static void release() {
        try {
            IStoreAccessor accessor = ACCESSOR.get();
            if (accessor != null && LifecycleUtil.isActive((Object)accessor)) {
                accessor.release();
            }
        }
        finally {
            StoreThreadLocal.remove();
        }
    }

    public static void remove() {
        ACCESSOR.remove();
        SESSION.remove();
        COMMIT_CONTEXT.remove();
    }

    public static final class NoSessionRegisteredException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public NoSessionRegisteredException() {
            super("session == null");
        }
    }
}

