/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.generator;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableFactory;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

final class ViewCache {
    private static final int CACHE_SIZE = 100;
    private static final Random RANDOMIZER = new Random();
    private final Map<EClass, ViewRecord> views = new LinkedHashMap<EClass, ViewRecord>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<EClass, ViewRecord> eldest) {
            return this.size() > 100;
        }
    };
    private final AdapterFactoryItemDelegator delegator;

    ViewCache() {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        composedAdapterFactory.insertAdapterFactory((AdapterFactory)new CustomReflectiveItemProviderAdapterFactory());
        this.delegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
    }

    VView getView(EObject object) {
        EClass eClass = object.eClass();
        ViewRecord prototype = this.views.get(eClass);
        if (prototype == null) {
            prototype = this.generatePrototype(eClass);
            this.views.put(eClass, prototype);
        }
        VView result = prototype.instantiate(object);
        return result;
    }

    private ViewRecord generatePrototype(EClass eClass) {
        VView view = VViewFactory.eINSTANCE.createView();
        view.setUuid(ViewCache.generateId(eClass, null));
        ViewRecord result = new ViewRecord(view);
        EObject example = EcoreUtil.create((EClass)eClass);
        Predicate<EStructuralFeature> isValidFeature = feature -> this.isValidFeature((EStructuralFeature)feature, example);
        eClass.getEAllStructuralFeatures().stream().filter(isValidFeature).forEach(feature -> {
            VTableControl control;
            if (this.isTableFeature((EStructuralFeature)feature)) {
                control = VTableFactory.eINSTANCE.createTableControl();
                VTableDomainModelReference tableDmr = VTableFactory.eINSTANCE.createTableDomainModelReference();
                tableDmr.setDomainModelReference(this.createModelReference((EStructuralFeature)feature));
                control.setDomainModelReference((VDomainModelReference)tableDmr);
            } else {
                control = VViewFactory.eINSTANCE.createControl();
                control.setDomainModelReference(this.createModelReference((EStructuralFeature)feature));
            }
            control.setUuid(result.generateID(eClass, (EStructuralFeature)feature));
            view.getChildren().add((Object)control);
            IItemPropertyDescriptor propertyDescriptor = this.delegator.getPropertyDescriptor((Object)example, feature);
            result.add((VControl)control, (EStructuralFeature)feature, propertyDescriptor);
        });
        example.eAdapters().clear();
        view.setRootEClass(eClass);
        return result;
    }

    private VDomainModelReference createModelReference(EStructuralFeature feature) {
        VFeaturePathDomainModelReference modelReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
        modelReference.setDomainModelEFeature(feature);
        return modelReference;
    }

    private boolean isTableFeature(EStructuralFeature feature) {
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            return ref.isMany() && ref.isContainment();
        }
        return false;
    }

    private boolean isValidFeature(EStructuralFeature feature, EObject owner) {
        boolean result;
        boolean bl = result = !this.isInvalidFeature(feature);
        if (result) {
            result = this.delegator.getPropertyDescriptor((Object)owner, (Object)feature) != null;
        }
        return result;
    }

    private boolean isInvalidFeature(EStructuralFeature feature) {
        return this.isContainerReference(feature) || this.isTransient(feature) || this.isVolatile(feature);
    }

    private boolean isContainerReference(EStructuralFeature feature) {
        EReference reference;
        return feature instanceof EReference && (reference = (EReference)feature).isContainer();
    }

    private boolean isTransient(EStructuralFeature feature) {
        return feature.isTransient();
    }

    private boolean isVolatile(EStructuralFeature feature) {
        return feature.isVolatile();
    }

    private static String generateId(EClass eClass, EStructuralFeature feature) {
        StringBuilder stringBuilder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        if (ePackage != null) {
            stringBuilder.append(ePackage.getNsURI());
        }
        stringBuilder.append("#");
        stringBuilder.append(eClass.getName());
        if (feature != null) {
            stringBuilder.append("#");
            stringBuilder.append(feature.getName());
        }
        return Integer.toHexString(stringBuilder.toString().hashCode());
    }

    private static final class ControlRecord {
        private final IItemPropertyDescriptor propertyDescriptor;
        private final boolean changeable;

        ControlRecord(EStructuralFeature feature, IItemPropertyDescriptor propertyDescriptor) {
            this.propertyDescriptor = propertyDescriptor;
            this.changeable = feature.isChangeable();
        }

        boolean isEditable(EObject owner) {
            return this.changeable && this.propertyDescriptor.canSetProperty((Object)owner);
        }
    }

    private static final class ViewRecord {
        private final Map<String, ControlRecord> controls = new HashMap<String, ControlRecord>();
        private final VView view;
        private final ViewCopier copier = new ViewCopier();

        ViewRecord(VView view) {
            this.view = view;
        }

        String generateID(EClass eClass, EStructuralFeature feature) {
            String result = ViewCache.generateId(eClass, feature);
            while (this.controls.containsKey(result)) {
                int value = Integer.parseInt(result, 16);
                result = Integer.toHexString(value ^= RANDOMIZER.nextInt());
            }
            return result;
        }

        void add(VControl control, EStructuralFeature feature, IItemPropertyDescriptor propertyDescriptor) {
            this.controls.put(control.getUuid(), new ControlRecord(feature, propertyDescriptor));
        }

        VView instantiate(EObject object) {
            this.copier.setOwner(object);
            VView result = (VView)this.copier.copy((EObject)this.view);
            this.copier.copyReferences();
            this.copier.clear();
            return result;
        }

        private final class ViewCopier
        extends EcoreUtil.Copier {
            private EObject owner;

            ViewCopier() {
            }

            public void clear() {
                this.owner = null;
                super.clear();
            }

            protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
                if (eAttribute != VViewPackage.Literals.ELEMENT__READONLY) {
                    super.copyAttribute(eAttribute, eObject, copyEObject);
                }
                if (eAttribute == VViewPackage.Literals.ELEMENT__UUID && copyEObject instanceof VControl) {
                    VControl control = (VControl)copyEObject;
                    ControlRecord record = (ControlRecord)ViewRecord.this.controls.get(control.getUuid());
                    if (record != null) {
                        control.setReadonly(!record.isEditable(this.owner));
                    }
                }
            }

            void setOwner(EObject owner) {
                this.owner = owner;
            }
        }
    }
}

