/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.ui.wizard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.parsley.dsl.ui.wizard.EmfParsleyDslNewProjectFiles;
import org.eclipse.emf.parsley.dsl.ui.wizard.EmfParsleyDslProjectCreator;
import org.eclipse.emf.parsley.dsl.ui.wizard.template.TemplateWizardConfiguration;
import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGenerator;
import org.eclipse.emf.parsley.wizards.NewEmfParsleyProjectSupport;
import org.eclipse.xtext.ui.util.PluginProjectFactory;

public class EmfParsleyDslProjectCreatorCustom
extends EmfParsleyDslProjectCreator {
    private static final int CREATING_PROJECT_WORK_STEPS = 5;
    static EmfParsleyDslNewProjectFiles filesGenerator = new EmfParsleyDslNewProjectFiles();
    static EmfParsleyProjectFilesGenerator projectFilesGenerator = new EmfParsleyProjectFilesGenerator();

    @Override
    protected List<String> getRequiredBundles() {
        ArrayList requiredBundles = Lists.newArrayList((Object[])new String[]{"org.eclipse.core.runtime"});
        if (this.getProjectInfo().isRapOption()) {
            requiredBundles.addAll(Lists.newArrayList((Object[])new String[]{"org.eclipse.ui;resolution:=optional", "org.eclipse.rap.ui;resolution:=optional", "org.eclipse.emf.parsley.views;resolution:=optional", "org.eclipse.emf.parsley.rap.views;resolution:=optional"}));
        } else {
            requiredBundles.addAll(Lists.newArrayList((Object[])new String[]{"org.eclipse.ui", "org.eclipse.emf.parsley.views"}));
        }
        requiredBundles.add("org.eclipse.xtext.xbase.lib");
        return requiredBundles;
    }

    @Override
    protected PluginProjectFactory createProjectFactory() {
        PluginProjectFactory projectFactory = super.createProjectFactory();
        if (this.getProjectInfo().getSelectedTemplate() != null) {
            projectFactory.setWithPluginXml(true);
        }
        return projectFactory;
    }

    protected String getActivatorClassName() {
        String projectName = this.getFixedProjectName();
        return String.valueOf(projectName) + "." + projectFilesGenerator.activatorName(projectName).toString();
    }

    protected String[] getProjectNatures() {
        ArrayList natures = Lists.newArrayList((Object[])super.getProjectNatures());
        natures.add("org.eclipse.emf.parsley.dsl.additional.builder.emfParsleyDslPluginXmlNature");
        return natures.toArray(new String[natures.size()]);
    }

    protected String[] getBuilders() {
        ArrayList builders = Lists.newArrayList((Object[])super.getBuilders());
        builders.add("org.eclipse.emf.parsley.dsl.additional.builder.emfParsleyDslPluginXmlBuilder");
        return builders.toArray(new String[builders.size()]);
    }

    @Override
    protected void enhanceProject(IProject project, IProgressMonitor monitor) throws CoreException {
        String projectName = this.getFixedProjectName();
        String srcFolder = "src";
        String projectPackagePath = String.valueOf(srcFolder) + "/" + projectName.replaceAll("\\.", "/");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Creating project " + projectName), (int)5);
        String[] paths = new String[]{projectPackagePath};
        NewEmfParsleyProjectSupport.addToProjectStructure((IProject)project, (String[])paths, (IProgressMonitor)subMonitor.newChild(1));
        NewEmfParsleyProjectSupport.createActivator((IProject)project, (String)projectName, (String)projectPackagePath, (IProgressMonitor)subMonitor.newChild(1));
        String dslFileContents = "";
        TemplateWizardConfiguration selectedTemplate = this.getProjectInfo().getSelectedTemplate();
        if (selectedTemplate != null) {
            String partClassName = selectedTemplate.getPartClassName(projectName);
            String partContents = selectedTemplate.getContentsForPart(projectName);
            NewEmfParsleyProjectSupport.createProjectFile((IProject)project, (String)(String.valueOf(projectPackagePath) + "/" + partClassName.concat(".java")), (String)partContents, (IProgressMonitor)subMonitor.newChild(1));
            dslFileContents = selectedTemplate.getParsleyModuleContents(projectName);
        } else {
            dslFileContents = filesGenerator.genEmptyDslModule(projectName).toString();
        }
        NewEmfParsleyProjectSupport.createDslModule((IProject)project, (String)projectName, (String)projectPackagePath, (String)dslFileContents, (IProgressMonitor)subMonitor.newChild(1));
        project.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
        subMonitor.done();
    }

    protected String getFixedProjectName() {
        return NewEmfParsleyProjectSupport.getValidJavaName((String)this.getProjectInfo().getProjectName());
    }
}

