/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.junit.JUnitPreferencesConstants;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.ui.CompareResultsAction;
import org.eclipse.jdt.internal.junit.ui.EnableStackFilterAction;
import org.eclipse.jdt.internal.junit.ui.FailureTableDisplay;
import org.eclipse.jdt.internal.junit.ui.JUnitCopyAction;
import org.eclipse.jdt.internal.junit.ui.OpenEditorAtLineAction;
import org.eclipse.jdt.internal.junit.ui.ShowStackTraceInConsoleViewAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.junit.ui.TextualTrace;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;

public class FailureTrace
implements IMenuListener {
    private static final int MAX_LABEL_LENGTH = 256;
    private static final String FAILURE_FONT = "org.eclipse.jdt.junit.failurePaneFont";
    static final String FRAME_PREFIX = "at ";
    private Table fTable;
    private TestRunnerViewPart fTestRunner;
    private String fInputTrace;
    private final Clipboard fClipboard;
    private TestElement fFailure;
    private CompareResultsAction fCompareAction;
    private final FailureTableDisplay fFailureTableDisplay;
    private IPropertyChangeListener fFontPropertyChangeListener;
    private ShowStackTraceInConsoleViewAction fShowTraceInConsoleAction;

    public FailureTrace(Composite parent, Clipboard clipboard, TestRunnerViewPart testRunner, ToolBar toolBar) {
        Assert.isNotNull((Object)clipboard);
        ToolBarManager failureToolBarmanager = new ToolBarManager(toolBar);
        this.fShowTraceInConsoleAction = new ShowStackTraceInConsoleViewAction(this);
        this.fShowTraceInConsoleAction.setEnabled(false);
        failureToolBarmanager.add((IAction)this.fShowTraceInConsoleAction);
        failureToolBarmanager.add((IAction)new EnableStackFilterAction(this));
        this.fCompareAction = new CompareResultsAction(this);
        this.fCompareAction.setEnabled(false);
        failureToolBarmanager.add((IAction)this.fCompareAction);
        failureToolBarmanager.update(true);
        this.fTable = new Table(parent, 772);
        this.fTable.setFont(JFaceResources.getFont((String)FAILURE_FONT));
        this.fTestRunner = testRunner;
        this.fClipboard = clipboard;
        OpenStrategy handler = new OpenStrategy((Control)this.fTable);
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                Action a;
                if (FailureTrace.this.fTable.getSelectionIndex() == 0 && FailureTrace.this.fFailure.isComparisonFailure()) {
                    FailureTrace.this.fCompareAction.run();
                }
                if (FailureTrace.this.fTable.getSelection().length != 0 && (a = FailureTrace.this.createOpenEditorAction(FailureTrace.this.getSelectedText())) != null) {
                    a.run();
                }
            }
        });
        this.fFontPropertyChangeListener = new FontPropertyChangeListener();
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        this.initMenu();
        this.fFailureTableDisplay = new FailureTableDisplay(this.fTable);
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTable.getSelectionCount() > 0) {
            Action a = this.createOpenEditorAction(this.getSelectedText());
            if (a != null) {
                manager.add((IAction)a);
            }
            manager.add((IAction)new JUnitCopyAction(this, this.fClipboard));
        }
        if (this.fFailure != null && this.fFailure.isComparisonFailure()) {
            manager.add((IAction)this.fCompareAction);
        }
    }

    public String getTrace() {
        return this.fInputTrace;
    }

    private String getSelectedText() {
        return this.fTable.getSelection()[0].getText();
    }

    private Action createOpenEditorAction(String traceLine) {
        int indexOfFramePrefix;
        String testName;
        block6: {
            testName = traceLine;
            indexOfFramePrefix = testName.indexOf(FRAME_PREFIX);
            if (indexOfFramePrefix != -1) break block6;
            return null;
        }
        try {
            int innerSeparatorIndex;
            testName = testName.substring(indexOfFramePrefix);
            testName = testName.substring(FRAME_PREFIX.length(), testName.lastIndexOf(40)).trim();
            int indexOfModuleSeparator = testName.lastIndexOf(47);
            if (indexOfModuleSeparator != -1) {
                testName = testName.substring(indexOfModuleSeparator + 1);
            }
            if ((innerSeparatorIndex = (testName = testName.substring(0, testName.lastIndexOf(46))).indexOf(36)) != -1) {
                testName = testName.substring(0, innerSeparatorIndex);
            }
            String lineNumber = traceLine;
            lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1, lineNumber.lastIndexOf(41));
            int line = Integer.valueOf(lineNumber);
            return new OpenEditorAtLineAction(this.fTestRunner, testName, line);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return null;
    }

    Composite getComposite() {
        return this.fTable;
    }

    public void refresh() {
        this.updateTable(this.fInputTrace);
    }

    public void showFailure(TestElement test) {
        this.fFailure = test;
        String trace = "";
        this.updateEnablement(test);
        if (test != null) {
            trace = test.getTrace();
        }
        if (this.fInputTrace == trace) {
            return;
        }
        this.fInputTrace = trace;
        this.updateTable(trace);
    }

    public void updateEnablement(TestElement test) {
        boolean enableCompare = test != null && test.isComparisonFailure();
        this.fCompareAction.setEnabled(enableCompare);
        if (enableCompare) {
            this.fCompareAction.updateOpenDialog(test);
        }
        boolean enableShowTraceInConsole = test != null && test.getFailureTrace() != null;
        this.fShowTraceInConsoleAction.setEnabled(enableShowTraceInConsole);
    }

    private void updateTable(String trace) {
        if (trace == null || trace.trim().isEmpty()) {
            this.clear();
            return;
        }
        trace = trace.trim();
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        new TextualTrace(trace, this.getFilterPatterns()).display(this.fFailureTableDisplay, 256);
        this.fTable.setRedraw(true);
    }

    private String[] getFilterPatterns() {
        if (JUnitPreferencesConstants.getFilterStack()) {
            return JUnitPreferencesConstants.getFilterPatterns();
        }
        return new String[0];
    }

    public void setInformation(String text) {
        this.clear();
        TableItem tableItem = this.fFailureTableDisplay.newTableItem();
        tableItem.setText(text);
    }

    public void clear() {
        this.fTable.removeAll();
        this.fInputTrace = null;
    }

    public TestElement getFailedTest() {
        return this.fFailure;
    }

    public Shell getShell() {
        return this.fTable.getShell();
    }

    public FailureTableDisplay getFailureTableDisplay() {
        return this.fFailureTableDisplay;
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
    }

    private class FontPropertyChangeListener
    implements IPropertyChangeListener {
        private FontPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (FailureTrace.this.fTable == null) {
                return;
            }
            String property = event.getProperty();
            if (FailureTrace.FAILURE_FONT.equals(property)) {
                FailureTrace.this.fTable.setFont(JFaceResources.getFont((String)FailureTrace.FAILURE_FONT));
            }
        }
    }
}

