/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReentryProperty {
    public static final ReentryProperty CONTINUE = new ReentryProperty(1, "CONTINUE");
    public static final ReentryProperty REPEAT = new ReentryProperty(2, "REPEAT");
    public static final ReentryProperty BREAK = new ReentryProperty(3, "BREAK");
    public static final ReentryProperty GOTO = new ReentryProperty(4, "GO TO");
    public static final ReentryProperty RETURN = new ReentryProperty(5, "RETURN");
    public static final ReentryProperty STOP = new ReentryProperty(6, "PAUSE");
    public static final ReentryProperty EXIT = new ReentryProperty(7, "EXIT");
    public static final ReentryProperty RETRY = new ReentryProperty(8, "RETRY");
    public static final ReentryProperty CONDITION = new ReentryProperty(9, "CONDITION");
    public static final ReentryProperty[] REENTRY_PROP_ARRAY = new ReentryProperty[]{BREAK, CONTINUE, EXIT, RETURN, STOP, RETRY};
    public static final ReentryProperty[] TS_REENTRY_PROP_ARRAY = new ReentryProperty[]{CONTINUE, EXIT, STOP};
    private static final Logger LOG = LoggerFactory.getLogger(ReentryProperty.class);
    private int m_value = 0;
    private String m_name;

    private ReentryProperty(int value, String name) {
        this.m_value = value;
        this.m_name = name;
    }

    private ReentryProperty() {
    }

    public static ReentryProperty getProperty(Integer reentryPropValue) throws InvalidDataException {
        int val = reentryPropValue == null ? 0 : reentryPropValue;
        ReentryProperty.validateValue(val);
        switch (val) {
            case 1: {
                return CONTINUE;
            }
            case 2: {
                return REPEAT;
            }
            case 3: {
                return BREAK;
            }
            case 4: {
                return GOTO;
            }
            case 5: {
                return RETURN;
            }
            case 6: {
                return STOP;
            }
            case 7: {
                return EXIT;
            }
            case 8: {
                return RETRY;
            }
            case 9: {
                return CONDITION;
            }
        }
        return null;
    }

    public static Integer getProperty(String reentryPropValue) throws InvalidDataException {
        String val = StringUtils.defaultIfBlank((String)reentryPropValue, (String)"");
        if (val.equals(Messages.EventExecTestCasePOCONTINUE)) {
            return CONTINUE.getValue();
        }
        if (val.equals(Messages.EventExecTestCasePOREPEAT)) {
            return REPEAT.getValue();
        }
        if (val.equals(Messages.EventExecTestCasePOBREAK)) {
            return BREAK.getValue();
        }
        if (val.equals(Messages.EventExecTestCasePOGOTO)) {
            return GOTO.getValue();
        }
        if (val.equals(Messages.EventExecTestCasePORETURN)) {
            return RETURN.getValue();
        }
        if (val.equals(Messages.EventExecTestCasePOSTOP)) {
            return STOP.getValue();
        }
        if (val.equals(Messages.EventExecTestCasePOEXIT)) {
            return EXIT.getValue();
        }
        if (val.equals(Messages.EventExecTestCasePORETRY)) {
            return RETRY.getValue();
        }
        LOG.error(String.valueOf(Messages.UnsupportedReentryProperty) + " " + val);
        throw new InvalidDataException(String.valueOf(Messages.UnsupportedReentryProperty) + " " + val, MessageIDs.E_UNSUPPORTED_REENTRY);
    }

    public static ReentryProperty getPropertyFromName(String name) throws InvalidDataException {
        String val = StringUtils.defaultIfBlank((String)name, (String)"");
        if (val.equalsIgnoreCase(CONTINUE.getName())) {
            return CONTINUE;
        }
        if (val.equalsIgnoreCase(REPEAT.getName())) {
            return REPEAT;
        }
        if (val.equalsIgnoreCase(BREAK.getName())) {
            return BREAK;
        }
        if (val.equalsIgnoreCase(GOTO.getName())) {
            return GOTO;
        }
        if (val.equalsIgnoreCase(RETURN.getName())) {
            return RETURN;
        }
        if (val.equalsIgnoreCase(STOP.getName()) || val.equalsIgnoreCase("STOP")) {
            return STOP;
        }
        if (val.equalsIgnoreCase(EXIT.getName())) {
            return EXIT;
        }
        if (val.equalsIgnoreCase(RETRY.getName())) {
            return RETRY;
        }
        LOG.error(String.valueOf(Messages.UnsupportedReentryProperty) + " " + val);
        throw new InvalidDataException(String.valueOf(Messages.UnsupportedReentryProperty) + " " + val, MessageIDs.E_UNSUPPORTED_REENTRY);
    }

    private static void validateValue(int value) throws InvalidDataException {
        if (value == 9) {
            return;
        }
        int i = 0;
        while (i < REENTRY_PROP_ARRAY.length) {
            ReentryProperty prop = REENTRY_PROP_ARRAY[i];
            if (prop.getValue() == value) {
                return;
            }
            ++i;
        }
        LOG.error(String.valueOf(Messages.UnsupportedReentryProperty) + " " + value);
        throw new InvalidDataException(String.valueOf(Messages.UnsupportedReentryProperty) + " " + value, MessageIDs.E_UNSUPPORTED_REENTRY);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.m_value).toHashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ReentryProperty ? ((ReentryProperty)obj).getValue() == this.m_value : false;
    }

    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        switch (this.m_value) {
            case 1: {
                return Messages.EventExecTestCasePOCONTINUE;
            }
            case 2: {
                return Messages.EventExecTestCasePOREPEAT;
            }
            case 3: {
                return Messages.EventExecTestCasePOBREAK;
            }
            case 4: {
                return Messages.EventExecTestCasePOGOTO;
            }
            case 5: {
                return Messages.EventExecTestCasePORETURN;
            }
            case 6: {
                return Messages.EventExecTestCasePOSTOP;
            }
            case 7: {
                return Messages.EventExecTestCasePOEXIT;
            }
            case 8: {
                return Messages.EventExecTestCasePORETRY;
            }
            case 9: {
                return "";
            }
        }
        Assert.notReached((String)(String.valueOf(Messages.WrongTypeOfReentryProperty) + "!"));
        return "";
    }
}

