/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.sourceprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.DatabaseStateDispatcher;
import org.eclipse.jubula.client.core.utils.DatabaseStateEvent;
import org.eclipse.jubula.client.core.utils.IDatabaseStateListener;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;

public class ActiveProjectSourceProvider
extends AbstractJBSourceProvider
implements DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener,
IDatabaseStateListener {
    public static final String IS_PROJECT_ACTIVE = "org.eclipse.jubula.client.ui.rcp.variable.isProjectActive";
    public static final String IS_PROJECT_PROTECTED = "org.eclipse.jubula.client.ui.rcp.variable.isProjectProtected";
    public static final String IS_DB_CONNECTION_ESTABLISHED = "org.eclipse.jubula.client.ui.rcp.variable.isConnectionToDatabaseEstablished";
    public static final String ARE_MULTIPLE_TCB_OPEN = "org.eclipse.jubula.client.ui.rcp.variable.areMultipleTCBOpen";

    public ActiveProjectSourceProvider() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        DatabaseStateDispatcher.addDatabaseStateListener((IDatabaseStateListener)this);
        MultipleTCBTracker.getInstance().setProvider(this);
    }

    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        DatabaseStateDispatcher.removeDatabaseStateListener((IDatabaseStateListener)this);
        MultipleTCBTracker.getInstance().setProvider(null);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> currentState = new HashMap<String, Object>();
        IProjectPO cuProject = GeneralStorage.getInstance().getProject();
        currentState.put(IS_PROJECT_ACTIVE, cuProject != null);
        boolean isProjectProtected = false;
        if (cuProject != null) {
            isProjectProtected = cuProject.getIsProtected();
        }
        currentState.put(IS_PROJECT_PROTECTED, isProjectProtected);
        currentState.put(IS_DB_CONNECTION_ESTABLISHED, Persistor.instance() != null);
        currentState.put(ARE_MULTIPLE_TCB_OPEN, MultipleTCBTracker.getInstance().getOpenTCBs().size() > 1);
        return currentState;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_PROJECT_ACTIVE, IS_PROJECT_PROTECTED, IS_DB_CONNECTION_ESTABLISHED, ARE_MULTIPLE_TCB_OPEN};
    }

    public void handleProjectLoaded() {
        this.fireSourceChanged();
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        this.fireSourceChanged();
    }

    private void fireSourceChanged() {
        IProjectPO cuProject = GeneralStorage.getInstance().getProject();
        boolean isProjectProtected = false;
        if (cuProject != null) {
            isProjectProtected = cuProject.getIsProtected();
        }
        this.gdFireSourceChanged(0, IS_PROJECT_ACTIVE, cuProject != null);
        this.gdFireSourceChanged(0, IS_PROJECT_PROTECTED, isProjectProtected);
        this.gdFireSourceChanged(0, IS_DB_CONNECTION_ESTABLISHED, Persistor.instance() != null);
        this.gdFireSourceChanged(0, ARE_MULTIPLE_TCB_OPEN, MultipleTCBTracker.getInstance().getOpenTCBs().size() > 1);
    }

    public void reactOnDatabaseEvent(DatabaseStateEvent e) {
        this.fireSourceChanged();
    }
}

