/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editors;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class BrowserNavigationLocation
extends NavigationLocation {
    private final String title;
    private EClass selectedMetaclass;
    private ITreeSelection treeSelection;

    public BrowserNavigationLocation(IEditorPart editorPart) {
        super(editorPart);
        this.title = editorPart.getTitle();
        this.selectedMetaclass = null;
        this.treeSelection = null;
    }

    public BrowserNavigationLocation(IEditorPart editorPart, EClass selectedMetaclass, ITreeSelection treeSelection) {
        super(editorPart);
        this.title = editorPart.getTitle();
        this.selectedMetaclass = selectedMetaclass;
        this.treeSelection = treeSelection;
    }

    public String getText() {
        String strSelection;
        String name = null;
        if (this.selectedMetaclass != null) {
            name = this.selectedMetaclass.getName();
        }
        if (name == null) {
            name = "";
        }
        if (this.treeSelection != null) {
            int nSelected = this.treeSelection.size();
            if (nSelected == 0) {
                strSelection = Messages.BrowserNavigationLocation_emptySelection;
            } else if (nSelected == 1) {
                Object firstElement = this.treeSelection.getFirstElement();
                if (firstElement instanceof ModelElementItem) {
                    ModelElementItem modelElementItem = (ModelElementItem)firstElement;
                    strSelection = NLS.bind((String)Messages.BrowserNavigationLocation_singleSelection, (Object)modelElementItem.getName());
                } else {
                    strSelection = NLS.bind((String)Messages.BrowserNavigationLocation_singleSelectionUnknownClass, (Object)firstElement.getClass().getSimpleName());
                }
            } else {
                strSelection = NLS.bind((String)Messages.BrowserNavigationLocation_multiSelection, (Object)nSelected);
            }
        } else {
            strSelection = "";
        }
        return String.valueOf(this.title) + " - " + name + strSelection;
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation == null) {
            return false;
        }
        if (currentLocation instanceof BrowserNavigationLocation) {
            BrowserNavigationLocation location = (BrowserNavigationLocation)currentLocation;
            if (!this.title.equals(location.title)) {
                return false;
            }
            if (this.selectedMetaclass == location.selectedMetaclass) {
                location.treeSelection = this.treeSelection;
                return true;
            }
            if (location.selectedMetaclass == null) {
                location.selectedMetaclass = this.selectedMetaclass;
                location.treeSelection = this.treeSelection;
                return true;
            }
        }
        return false;
    }

    public void restoreLocation() {
        if (this.selectedMetaclass == null) {
            return;
        }
        IEditorPart editorPart = this.getEditorPart();
        if (editorPart instanceof EcoreBrowser) {
            EcoreBrowser editor = (EcoreBrowser)editorPart;
            editor.restoreLocation(this.selectedMetaclass, this.treeSelection);
        }
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void update() {
    }

    public void releaseState() {
        super.releaseState();
        this.treeSelection = null;
    }
}

