/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class LoggerBridge {
    public static final String EQUINOX_LOGGER_NAME = "org.eclipse.equinox.logger";

    public static void log(Logger logger, IStatus status) {
        logger.log((Object)LoggerBridge.getLog(status), LoggerBridge.getLevel(status), status.getMessage(), status.getException());
    }

    static FrameworkLogEntry getLog(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(LoggerBridge.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = children = status.getChildren();
            int n2 = children.length;
            int n3 = 0;
            while (n3 < n2) {
                IStatus child = iStatusArray[n3];
                childlist.add(LoggerBridge.getLog(child));
                ++n3;
            }
        }
        children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry((Object)status, status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), stackCode, t, (FrameworkLogEntry[])children);
    }

    public static int getLevel(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 4;
            }
        }
        return 32;
    }
}

