/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.targlets.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.targlets.ImplicitDependency;
import org.eclipse.oomph.setup.targlets.SetupTargletsFactory;
import org.eclipse.oomph.setup.targlets.SetupTargletsPackage;
import org.eclipse.oomph.setup.targlets.TargletTask;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.WorkspaceIUImporter;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargletTaskImpl
extends SetupTaskImpl
implements TargletTask {
    protected EList<Targlet> targlets;
    protected EList<String> targletURIs;
    protected static final String OPERATING_SYSTEM_EDEFAULT = null;
    protected String operatingSystem = OPERATING_SYSTEM_EDEFAULT;
    protected static final String WINDOWING_SYSTEM_EDEFAULT = null;
    protected String windowingSystem = WINDOWING_SYSTEM_EDEFAULT;
    protected static final String ARCHITECTURE_EDEFAULT = null;
    protected String architecture = ARCHITECTURE_EDEFAULT;
    protected static final String LOCALE_EDEFAULT = null;
    protected String locale = LOCALE_EDEFAULT;
    protected static final String PROGRAM_ARGUMENTS_EDEFAULT = null;
    protected String programArguments = PROGRAM_ARGUMENTS_EDEFAULT;
    protected static final String VM_ARGUMENTS_EDEFAULT = null;
    protected String vMArguments = VM_ARGUMENTS_EDEFAULT;
    protected EList<ImplicitDependency> implicitDependencies;
    protected static final String TARGET_NAME_EDEFAULT = "Modular Target";
    protected String targetName = "Modular Target";
    protected static final boolean ACTIVATE_TARGET_EDEFAULT = true;
    protected boolean activateTarget = true;
    private ITargletContainer targletContainer;
    private ITargetDefinition targetDefinition;
    private EList<Targlet> copyTarglets;

    protected TargletTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupTargletsPackage.Literals.TARGLET_TASK;
    }

    @Override
    public EList<Targlet> getTarglets() {
        if (this.targlets == null) {
            this.targlets = new EObjectContainmentEList(Targlet.class, (InternalEObject)this, 10);
        }
        return this.targlets;
    }

    @Override
    public EList<String> getTargletURIs() {
        if (this.targletURIs == null) {
            this.targletURIs = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 11);
        }
        return this.targletURIs;
    }

    @Override
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public void setOperatingSystem(String newOperatingSystem) {
        String oldOperatingSystem = this.operatingSystem;
        this.operatingSystem = newOperatingSystem;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldOperatingSystem, (Object)this.operatingSystem));
        }
    }

    @Override
    public String getWindowingSystem() {
        return this.windowingSystem;
    }

    @Override
    public void setWindowingSystem(String newWindowingSystem) {
        String oldWindowingSystem = this.windowingSystem;
        this.windowingSystem = newWindowingSystem;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldWindowingSystem, (Object)this.windowingSystem));
        }
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public void setArchitecture(String newArchitecture) {
        String oldArchitecture = this.architecture;
        this.architecture = newArchitecture;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldArchitecture, (Object)this.architecture));
        }
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String newLocale) {
        String oldLocale = this.locale;
        this.locale = newLocale;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldLocale, (Object)this.locale));
        }
    }

    @Override
    public String getProgramArguments() {
        return this.programArguments;
    }

    @Override
    public void setProgramArguments(String newProgramArguments) {
        String oldProgramArguments = this.programArguments;
        this.programArguments = newProgramArguments;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldProgramArguments, (Object)this.programArguments));
        }
    }

    @Override
    public String getVMArguments() {
        return this.vMArguments;
    }

    @Override
    public void setVMArguments(String newVMArguments) {
        String oldVMArguments = this.vMArguments;
        this.vMArguments = newVMArguments;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldVMArguments, (Object)this.vMArguments));
        }
    }

    @Override
    public EList<ImplicitDependency> getImplicitDependencies() {
        if (this.implicitDependencies == null) {
            this.implicitDependencies = new EObjectContainmentEList(ImplicitDependency.class, (InternalEObject)this, 18);
        }
        return this.implicitDependencies;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public void setTargetName(String newTargetName) {
        String oldTargetName = this.targetName;
        this.targetName = newTargetName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldTargetName, (Object)this.targetName));
        }
    }

    @Override
    public boolean isActivateTarget() {
        return this.activateTarget;
    }

    @Override
    public void setActivateTarget(boolean newActivateTarget) {
        boolean oldActivateTarget = this.activateTarget;
        this.activateTarget = newActivateTarget;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, oldActivateTarget, this.activateTarget));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getTarglets()).basicRemove((Object)otherEnd, msgs);
            }
            case 18: {
                return ((InternalEList)this.getImplicitDependencies()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getTarglets();
            }
            case 11: {
                return this.getTargletURIs();
            }
            case 12: {
                return this.getOperatingSystem();
            }
            case 13: {
                return this.getWindowingSystem();
            }
            case 14: {
                return this.getArchitecture();
            }
            case 15: {
                return this.getLocale();
            }
            case 16: {
                return this.getProgramArguments();
            }
            case 17: {
                return this.getVMArguments();
            }
            case 18: {
                return this.getImplicitDependencies();
            }
            case 19: {
                return this.getTargetName();
            }
            case 20: {
                return this.isActivateTarget();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.getTarglets().clear();
                this.getTarglets().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getTargletURIs().clear();
                this.getTargletURIs().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setOperatingSystem((String)newValue);
                return;
            }
            case 13: {
                this.setWindowingSystem((String)newValue);
                return;
            }
            case 14: {
                this.setArchitecture((String)newValue);
                return;
            }
            case 15: {
                this.setLocale((String)newValue);
                return;
            }
            case 16: {
                this.setProgramArguments((String)newValue);
                return;
            }
            case 17: {
                this.setVMArguments((String)newValue);
                return;
            }
            case 18: {
                this.getImplicitDependencies().clear();
                this.getImplicitDependencies().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.setTargetName((String)newValue);
                return;
            }
            case 20: {
                this.setActivateTarget((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.getTarglets().clear();
                return;
            }
            case 11: {
                this.getTargletURIs().clear();
                return;
            }
            case 12: {
                this.setOperatingSystem(OPERATING_SYSTEM_EDEFAULT);
                return;
            }
            case 13: {
                this.setWindowingSystem(WINDOWING_SYSTEM_EDEFAULT);
                return;
            }
            case 14: {
                this.setArchitecture(ARCHITECTURE_EDEFAULT);
                return;
            }
            case 15: {
                this.setLocale(LOCALE_EDEFAULT);
                return;
            }
            case 16: {
                this.setProgramArguments(PROGRAM_ARGUMENTS_EDEFAULT);
                return;
            }
            case 17: {
                this.setVMArguments(VM_ARGUMENTS_EDEFAULT);
                return;
            }
            case 18: {
                this.getImplicitDependencies().clear();
                return;
            }
            case 19: {
                this.setTargetName(TARGET_NAME_EDEFAULT);
                return;
            }
            case 20: {
                this.setActivateTarget(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.targlets != null && !this.targlets.isEmpty();
            }
            case 11: {
                return this.targletURIs != null && !this.targletURIs.isEmpty();
            }
            case 12: {
                return OPERATING_SYSTEM_EDEFAULT == null ? this.operatingSystem != null : !OPERATING_SYSTEM_EDEFAULT.equals(this.operatingSystem);
            }
            case 13: {
                return WINDOWING_SYSTEM_EDEFAULT == null ? this.windowingSystem != null : !WINDOWING_SYSTEM_EDEFAULT.equals(this.windowingSystem);
            }
            case 14: {
                return ARCHITECTURE_EDEFAULT == null ? this.architecture != null : !ARCHITECTURE_EDEFAULT.equals(this.architecture);
            }
            case 15: {
                return LOCALE_EDEFAULT == null ? this.locale != null : !LOCALE_EDEFAULT.equals(this.locale);
            }
            case 16: {
                return PROGRAM_ARGUMENTS_EDEFAULT == null ? this.programArguments != null : !PROGRAM_ARGUMENTS_EDEFAULT.equals(this.programArguments);
            }
            case 17: {
                return VM_ARGUMENTS_EDEFAULT == null ? this.vMArguments != null : !VM_ARGUMENTS_EDEFAULT.equals(this.vMArguments);
            }
            case 18: {
                return this.implicitDependencies != null && !this.implicitDependencies.isEmpty();
            }
            case 19: {
                return TARGET_NAME_EDEFAULT == null ? this.targetName != null : !TARGET_NAME_EDEFAULT.equals(this.targetName);
            }
            case 20: {
                return !this.activateTarget;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (targletURIs: ");
        result.append(this.targletURIs);
        result.append(", operatingSystem: ");
        result.append(this.operatingSystem);
        result.append(", windowingSystem: ");
        result.append(this.windowingSystem);
        result.append(", architecture: ");
        result.append(this.architecture);
        result.append(", locale: ");
        result.append(this.locale);
        result.append(", programArguments: ");
        result.append(this.programArguments);
        result.append(", vMArguments: ");
        result.append(this.vMArguments);
        result.append(", targetName: ");
        result.append(this.targetName);
        result.append(", activateTarget: ");
        result.append(this.activateTarget);
        result.append(')');
        return result.toString();
    }

    public Object getOverrideToken() {
        return this.createToken(this.getSafeTargetName());
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        TargletTask targletTask = (TargletTask)overriddenSetupTask;
        this.getTarglets().addAll(targletTask.getTarglets());
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__OPERATING_SYSTEM, "operating systems");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__WINDOWING_SYSTEM, "windowing systems");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__ARCHITECTURE, "architectures");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__LOCALE, "locales");
        this.mergeArguments(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__PROGRAM_ARGUMENTS);
        this.mergeArguments(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__VM_ARGUMENTS);
        this.getImplicitDependencies().addAll(targletTask.getImplicitDependencies());
    }

    private void mergeSetting(TargletTask overriddenTargletTask, EAttribute attribute, String errorLabel) {
        String overriddenValue;
        String overridingValue = (String)this.eGet((EStructuralFeature)attribute);
        if (!ObjectUtil.equals((Object)overridingValue, (Object)(overriddenValue = (String)overriddenTargletTask.eGet((EStructuralFeature)attribute)))) {
            if (overridingValue == null) {
                this.eSet((EStructuralFeature)attribute, overriddenValue);
            } else if (overriddenValue != null) {
                this.getAnnotations().add((Object)BaseFactory.eINSTANCE.createErrorAnnotation("The " + errorLabel + " '" + overriddenValue + "' and '" + overridingValue + "' collide."));
            }
        }
    }

    private void mergeArguments(TargletTask overriddenTargletTask, EAttribute attribute) {
        String overridingValue = this.sanitizeArguments((String)this.eGet((EStructuralFeature)attribute));
        String overriddenValue = this.sanitizeArguments((String)overriddenTargletTask.eGet((EStructuralFeature)attribute));
        if (overridingValue != null) {
            if (overriddenValue != null) {
                this.eSet((EStructuralFeature)attribute, String.valueOf(overriddenValue) + StringUtil.NL + overridingValue);
            } else {
                this.eSet((EStructuralFeature)attribute, overridingValue);
            }
        }
    }

    private String sanitizeArguments(String arguments) {
        if (StringUtil.isEmpty((String)arguments)) {
            return null;
        }
        return arguments.trim().replaceAll("(\n\r?|\r\n?)", StringUtil.NL);
    }

    public void consolidate() {
        super.consolidate();
        HashSet<String> targletNames = new HashSet<String>();
        EList<Targlet> targlets = this.getTarglets();
        Iterator it = targlets.iterator();
        block0: while (it.hasNext()) {
            Targlet targlet = (Targlet)it.next();
            BaseUtil.setReduced((ModelElement)targlet, (boolean)true);
            String name = targlet.getName();
            if (StringUtil.isEmpty((String)name) || !targletNames.add(name)) {
                it.remove();
                continue;
            }
            if (!targlet.getRequirements().isEmpty() || !targlet.getSourceLocators().isEmpty() || !targlet.getDropinLocations().isEmpty()) continue;
            String activeRepositoryList = targlet.getActiveRepositoryListName();
            for (RepositoryList repositoryList : targlet.getRepositoryLists()) {
                if (!ObjectUtil.equals((Object)activeRepositoryList, (Object)repositoryList.getName()) || !repositoryList.getRepositories().isEmpty()) continue;
                it.remove();
                continue block0;
            }
        }
        ECollections.sort(targlets, (Comparator)new Comparator<Targlet>(){

            @Override
            public int compare(Targlet o1, Targlet o2) {
                return StringUtil.safe((String)o1.getName()).compareTo(StringUtil.safe((String)o2.getName()));
            }
        });
        EList<ImplicitDependency> implicitDependencies = this.getImplicitDependencies();
        Set<NameVersionDescriptor> descriptors = TargletTaskImpl.createNameVersionDescriptors(implicitDependencies);
        implicitDependencies.clear();
        for (NameVersionDescriptor descriptor : descriptors) {
            String id = descriptor.getId();
            String version = descriptor.getVersion();
            ImplicitDependency implicitDependency = SetupTargletsFactory.eINSTANCE.createImplicitDependency(id, version);
            implicitDependencies.add((Object)implicitDependency);
        }
        ECollections.sort(implicitDependencies, (Comparator)new Comparator<ImplicitDependency>(){

            @Override
            public int compare(ImplicitDependency o1, ImplicitDependency o2) {
                int result = StringUtil.safe((String)o1.getID()).compareTo(StringUtil.safe((String)o2.getID()));
                if (result == 0) {
                    Version v2;
                    Version v1 = o1.getVersion();
                    if (v1 == null) {
                        v1 = Version.emptyVersion;
                    }
                    if ((v2 = o2.getVersion()) == null) {
                        v2 = Version.emptyVersion;
                    }
                    result = v1.compareTo((Object)v2);
                }
                return result;
            }
        });
        this.setProgramArguments(this.sanitizeArguments(this.getProgramArguments()));
        this.setVMArguments(this.sanitizeArguments(this.getVMArguments()));
    }

    public int getProgressMonitorWork() {
        return 100;
    }

    public boolean isNeeded(final SetupTaskContext context) throws Exception {
        this.copyTarglets = TargletFactory.eINSTANCE.copyTarglets(this.getTarglets());
        boolean isNeeded = (Boolean)TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Boolean>(){

            public Boolean run(ITargetPlatformService service) throws CoreException {
                ITargetHandle activeTargetHandle = service.getWorkspaceTargetHandle();
                TargletTaskImpl.this.targetDefinition = TargletTaskImpl.this.getTargetDefinition(service, context.getProgressMonitor(true));
                if (TargletTaskImpl.this.targetDefinition == null) {
                    return TargletTaskImpl.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets);
                }
                TargletTaskImpl.this.targletContainer = TargletTaskImpl.this.getTargletContainer();
                if (TargletTaskImpl.this.targletContainer == null) {
                    return TargletTaskImpl.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets);
                }
                if (!TargletTaskImpl.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets) && !TargletTaskImpl.hasRequirements((EList<Targlet>)TargletTaskImpl.this.targletContainer.getTarglets())) {
                    return false;
                }
                if (!EcoreUtil.equals((List)TargletTaskImpl.this.targletContainer.getTarglets(), (List)TargletTaskImpl.this.copyTarglets)) {
                    return true;
                }
                if (context.getTrigger() == Trigger.MANUAL) {
                    return true;
                }
                if (TargletTaskImpl.this.isActivateTarget() && !TargletTaskImpl.this.targetDefinition.getHandle().equals(activeTargetHandle)) {
                    return true;
                }
                if (!(ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getOS(), (Object)TargletTaskImpl.this.getOperatingSystem()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getWS(), (Object)TargletTaskImpl.this.getWindowingSystem()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getArch(), (Object)TargletTaskImpl.this.getArchitecture()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getNL(), (Object)TargletTaskImpl.this.getLocale()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getProgramArguments(), (Object)TargletTaskImpl.this.getProgramArguments()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getVMArguments(), (Object)TargletTaskImpl.this.getVMArguments()) && TargletTaskImpl.equalNameVersionDescriptors(TargletTaskImpl.this.targetDefinition.getImplicitDependencies(), (EList<ImplicitDependency>)TargletTaskImpl.this.getImplicitDependencies()))) {
                    return true;
                }
                return false;
            }
        });
        if (isNeeded) {
            SetupUtil.getResolvingTargetDefinitions((SetupTaskContext)context).add(this.getSafeTargetName());
            return true;
        }
        return false;
    }

    public void perform(final SetupTaskContext context) throws Exception {
        for (Targlet targlet : this.copyTarglets) {
            for (Repository p2Repository : targlet.getActiveRepositories()) {
                context.log("Repository " + p2Repository.getURL());
            }
        }
        boolean offline = context.isOffline();
        context.log("Offline = " + offline);
        final boolean mirrors = context.isMirrors();
        context.log("Mirrors = " + mirrors);
        TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Object>(){

            public Object run(ITargetPlatformService service) throws CoreException {
                IProgressMonitor monitor = context.getProgressMonitor(true);
                monitor.beginTask("", 100 + (TargletTaskImpl.this.targetDefinition == null ? 1 : 0));
                try {
                    ITargetLocation[] oldLocations;
                    if (TargletTaskImpl.this.targetDefinition == null) {
                        TargletTaskImpl.this.targetDefinition = TargletTaskImpl.this.getTargetDefinition(service, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                    }
                    String targetName = TargletTaskImpl.this.getSafeTargetName();
                    boolean activateTarget = TargletTaskImpl.this.isActivateTarget();
                    if (TargletTaskImpl.this.targetDefinition == null) {
                        TargletTaskImpl.this.targetDefinition = service.newTarget();
                        TargletTaskImpl.this.targetDefinition.setName(targetName);
                    }
                    TargletTaskImpl.this.targetDefinition.setOS(TargletTaskImpl.this.getOperatingSystem());
                    TargletTaskImpl.this.targetDefinition.setWS(TargletTaskImpl.this.getWindowingSystem());
                    TargletTaskImpl.this.targetDefinition.setArch(TargletTaskImpl.this.getArchitecture());
                    TargletTaskImpl.this.targetDefinition.setNL(TargletTaskImpl.this.getLocale());
                    TargletTaskImpl.this.targetDefinition.setProgramArguments(TargletTaskImpl.this.getProgramArguments());
                    TargletTaskImpl.this.targetDefinition.setVMArguments(TargletTaskImpl.this.getVMArguments());
                    TargletTaskImpl.this.targetDefinition.setImplicitDependencies(TargletTaskImpl.this.getNameVersionDescriptors());
                    if (TargletTaskImpl.this.targletContainer == null) {
                        TargletTaskImpl.this.targletContainer = TargletTaskImpl.this.getTargletContainer();
                    }
                    EList targlets = TargletTaskImpl.this.copyTarglets;
                    if (TargletTaskImpl.this.targletContainer == null) {
                        ITargetLocation[] newLocations;
                        TargletTaskImpl.this.targletContainer = (ITargletContainer)new TargletContainer(targetName);
                        ITargetLocation[] oldLocations2 = TargletTaskImpl.this.targetDefinition.getTargetLocations();
                        if (oldLocations2 != null && oldLocations2.length != 0) {
                            newLocations = new ITargetLocation[oldLocations2.length + 1];
                            System.arraycopy(oldLocations2, 0, newLocations, 0, oldLocations2.length);
                            newLocations[oldLocations2.length] = TargletTaskImpl.this.targletContainer;
                        } else {
                            newLocations = new ITargetLocation[]{TargletTaskImpl.this.targletContainer};
                        }
                        TargletTaskImpl.this.targetDefinition.setTargetLocations(newLocations);
                    } else if (!targetName.equals("Oomph") && (oldLocations = TargletTaskImpl.this.targetDefinition.getTargetLocations()) != null && oldLocations.length != 0) {
                        ArrayList<ITargetLocation> list = new ArrayList<ITargetLocation>(Arrays.asList(oldLocations));
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            Object container;
                            ITargetLocation location = (ITargetLocation)it.next();
                            if (!(location instanceof TargletContainer) || !(container = (TargletContainer)location).getID().equals("Oomph")) continue;
                            it.remove();
                            TargletTaskImpl.this.targetDefinition.setTargetLocations(list.toArray(new ITargetLocation[list.size()]));
                            break;
                        }
                    }
                    CacheUsageConfirmer cacheUsageConfirmer = (CacheUsageConfirmer)context.get(CacheUsageConfirmer.class);
                    CacheUsageConfirmer oldCacheUsageConfirmer = TargletsCorePlugin.INSTANCE.getCacheUsageConfirmer();
                    try {
                        TargletsCorePlugin.INSTANCE.setCacheUsageConfirmer(cacheUsageConfirmer);
                        TargletTaskImpl.this.targletContainer.setTarglets((Collection)targlets);
                        boolean includeAllPlatforms = TargletTaskImpl.this.targletContainer.isIncludeAllPlatforms();
                        context.log("Include All Platforms = " + includeAllPlatforms);
                        if (includeAllPlatforms) {
                            for (Targlet targlet : TargletTaskImpl.this.targletContainer.getTarglets()) {
                                if (!targlet.isIncludeAllPlatforms()) continue;
                                context.log("-> " + targlet.getName());
                            }
                        }
                        boolean includeAllRequirements = TargletTaskImpl.this.targletContainer.isIncludeAllRequirements();
                        context.log("Include All Requirements = " + includeAllRequirements);
                        if (!includeAllRequirements) {
                            for (Targlet targlet : TargletTaskImpl.this.targletContainer.getTarglets()) {
                                if (targlet.isIncludeAllRequirements()) continue;
                                context.log("-> " + targlet.getName());
                            }
                        }
                        boolean includeBinaryEquivalents = TargletTaskImpl.this.targletContainer.isIncludeBinaryEquivalents();
                        context.log("Include Binary Equivalents = " + includeBinaryEquivalents);
                        if (!includeBinaryEquivalents) {
                            for (Targlet targlet : TargletTaskImpl.this.targletContainer.getTarglets()) {
                                if (targlet.isIncludeBinaryEquivalents()) continue;
                                context.log("-> " + targlet.getName());
                            }
                        }
                        boolean includeSources = TargletTaskImpl.this.targletContainer.isIncludeSources();
                        context.log("Include Sources = " + includeSources);
                        String profileProperties = TargletTaskImpl.this.targletContainer.getProfileProperties();
                        if (!StringUtil.isEmpty((String)profileProperties)) {
                            context.log("Profile Properties = " + profileProperties);
                        }
                        TargletTaskImpl.this.targletContainer.forceUpdate(activateTarget, mirrors, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)90));
                        try {
                            Job.getJobManager().join(WorkspaceIUImporter.WORKSPACE_IU_IMPORT_FAMILY, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)10));
                        }
                        catch (InterruptedException ex) {
                            TargletsCorePlugin.INSTANCE.coreException((Throwable)ex);
                        }
                    }
                    finally {
                        TargletsCorePlugin.INSTANCE.setCacheUsageConfirmer(oldCacheUsageConfirmer);
                    }
                    return null;
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private String getSafeTargetName() {
        String targetName = this.getTargetName();
        if (StringUtil.isEmpty((String)targetName)) {
            targetName = TARGET_NAME_EDEFAULT;
        }
        return targetName;
    }

    private ITargetDefinition getTargetDefinition(ITargetPlatformService service, IProgressMonitor monitor) {
        ITargetHandle[] iTargetHandleArray = service.getTargets(monitor);
        int n = iTargetHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetHandle targetHandle = iTargetHandleArray[n2];
            try {
                ITargetDefinition targetDefinition = targetHandle.getTargetDefinition();
                if (ObjectUtil.equals((Object)this.getSafeTargetName(), (Object)targetDefinition.getName())) {
                    return targetDefinition;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    private ITargletContainer getTargletContainer() {
        ITargetLocation[] locations = this.targetDefinition.getTargetLocations();
        if (locations != null) {
            ITargetLocation[] iTargetLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation location = iTargetLocationArray[n2];
                if (location instanceof ITargletContainer) {
                    ITargletContainer targletContainer = (ITargletContainer)location;
                    if (ObjectUtil.equals((Object)this.getSafeTargetName(), (Object)targletContainer.getID())) {
                        return targletContainer;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private NameVersionDescriptor[] getNameVersionDescriptors() {
        EList<ImplicitDependency> implicitDependencies = this.getImplicitDependencies();
        if (implicitDependencies.isEmpty()) {
            return null;
        }
        Set<NameVersionDescriptor> descriptors = TargletTaskImpl.createNameVersionDescriptors(implicitDependencies);
        return descriptors.toArray(new NameVersionDescriptor[descriptors.size()]);
    }

    private static Set<NameVersionDescriptor> createNameVersionDescriptors(Collection<ImplicitDependency> implicitDependencies) {
        LinkedHashSet<NameVersionDescriptor> result = new LinkedHashSet<NameVersionDescriptor>();
        for (ImplicitDependency implicitDependency : implicitDependencies) {
            String id = implicitDependency.getID();
            if (StringUtil.isEmpty((String)id)) continue;
            Version version = implicitDependency.getVersion();
            result.add(new NameVersionDescriptor(id, version == null ? null : version.toString()));
        }
        return result;
    }

    private static boolean equalNameVersionDescriptors(NameVersionDescriptor[] targetImplicitDependencies, EList<ImplicitDependency> targletImplicitDependencies) {
        HashSet<NameVersionDescriptor> targetSet = new HashSet<NameVersionDescriptor>();
        if (targetImplicitDependencies != null) {
            int i = 0;
            while (i < targetImplicitDependencies.length) {
                targetSet.add(targetImplicitDependencies[i]);
                ++i;
            }
        }
        Set<NameVersionDescriptor> targletSet = TargletTaskImpl.createNameVersionDescriptors(targletImplicitDependencies);
        return targetSet.equals(targletSet);
    }

    private static boolean hasRequirements(EList<Targlet> targlets) {
        for (Targlet targlet : targlets) {
            if (targlet.getRequirements().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

