/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.io.Reader;
import java.util.Map;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderHierarchicalLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteTreeUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;

public class PasteHelperUtils {
    private static final char INDENTATION_CHARACTER = ' ';

    private PasteHelperUtils() {
    }

    public static final boolean isPasteWithOverwrite(INattableModelManager tableManager, CSVPasteHelper pasteHelper, Reader reader) {
        boolean isPasteWithOverwrite = false;
        CSVParser parser = pasteHelper.createParser(reader);
        RowIterator rowIter = parser.parse();
        int nbColumnRead = -1;
        while (rowIter.hasNext()) {
            CellIterator cellIter = (CellIterator)rowIter.next();
            int nbColumnReadByRow = 0;
            if (cellIter.hasNext()) {
                while (cellIter.hasNext()) {
                    cellIter.next();
                    ++nbColumnReadByRow;
                }
            }
            int n = nbColumnRead = nbColumnRead >= nbColumnReadByRow ? nbColumnRead : nbColumnReadByRow;
        }
        int nbExpectedColumn = tableManager.getColumnCount();
        nbExpectedColumn = TableHelper.isSingleColumnTreeTable(tableManager) ? ++nbExpectedColumn : (TableHelper.isTreeTable(tableManager) ? (nbExpectedColumn += ((RowHeaderHierarchicalLayerStack)((NattableModelManager)tableManager).getRowHeaderLayerStack()).getRowHeaderColumnHideShowLayer().getColumnCount()) : (nbExpectedColumn += ((NattableModelManager)tableManager).getRowHeaderLayerStack().getRowHeaderLayerLabel().getColumnCount()));
        isPasteWithOverwrite = nbColumnRead != nbExpectedColumn;
        return isPasteWithOverwrite;
    }

    /*
     * Unable to fully structure code
     */
    public static final int getMaxDepthToPaste(INattableModelManager tableManager, CSVPasteHelper pasteHelper, Reader reader) {
        block5: {
            maxDepth = -1;
            if (!TableHelper.isTreeTable(tableManager)) break block5;
            table = tableManager.getTable();
            isSingleHeaderColumnTreeTable = TableHelper.isSingleColumnTreeTable(table);
            parser = pasteHelper.createParser(reader, isSingleHeaderColumnTreeTable);
            rowIter = parser.parse();
            while (rowIter.hasNext()) {
                block6: {
                    cellIter = (CellIterator)rowIter.next();
                    if (!cellIter.hasNext()) continue;
                    valueAsString = (String)cellIter.next();
                    nbReadCell = 1;
                    if (!isSingleHeaderColumnTreeTable || valueAsString.isEmpty()) ** GOTO lbl20
                    while (' ' == valueAsString.charAt(0)) {
                        ++nbReadCell;
                        valueAsString = valueAsString.substring(1);
                    }
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        valueAsString = (String)cellIter.next();
                        ++nbReadCell;
lbl20:
                        // 2 sources

                        ** while (cellIter.hasNext() && valueAsString.isEmpty())
                    }
                }
                currentDepth = PasteTreeUtils.getDepth(nbReadCell, FillingConfigurationUtils.getMaxDepthForTree(table), StyleUtils.getHiddenDepths(table), FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(table, 0));
                if (maxDepth < currentDepth) {
                    maxDepth = currentDepth;
                }
                while (cellIter.hasNext()) {
                    cellIter.next();
                }
            }
        }
        return -1 == maxDepth ? 0x7FFFFFFF : maxDepth;
    }

    public static final int getMinDepthOfSelection(INattableModelManager tableManager, TableSelectionWrapper tableSelectionWrapper) {
        int minDepth = 0;
        if (tableSelectionWrapper != null && !tableSelectionWrapper.getFullySelectedRows().isEmpty() && tableSelectionWrapper.getFullySelectedColumns().isEmpty()) {
            minDepth = Integer.MAX_VALUE;
            Map<Integer, Object> selectedRows = tableSelectionWrapper.getFullySelectedRows();
            for (int rowIndex : selectedRows.keySet()) {
                if (!(selectedRows.get(rowIndex) instanceof TreeFillingConfiguration) || minDepth <= ((TreeFillingConfiguration)selectedRows.get(rowIndex)).getDepth()) continue;
                minDepth = ((TreeFillingConfiguration)selectedRows.get(rowIndex)).getDepth();
            }
        }
        return minDepth;
    }
}

